# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyGroupArgs', 'PolicyGroup']

@pulumi.input_type
class PolicyGroupArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[_builtins.str],
                 solution: pulumi.Input[_builtins.str],
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupDeviceArgs']]]] = None,
                 feature_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PolicyGroup resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] solution: Type of solution
                 - Choices: `sdwan`
        :param pulumi.Input[Sequence[pulumi.Input['PolicyGroupDeviceArgs']]] devices: List of devices
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] feature_profile_ids: List of feature profile IDs
        :param pulumi.Input[_builtins.str] name: The name of the policy group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_versions: List of all associated policy versions
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "solution", solution)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if feature_profile_ids is not None:
            pulumi.set(__self__, "feature_profile_ids", feature_profile_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_versions is not None:
            pulumi.set(__self__, "policy_versions", policy_versions)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def solution(self) -> pulumi.Input[_builtins.str]:
        """
        Type of solution
          - Choices: `sdwan`
        """
        return pulumi.get(self, "solution")

    @solution.setter
    def solution(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "solution", value)

    @_builtins.property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupDeviceArgs']]]]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileIds")
    def feature_profile_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of feature profile IDs
        """
        return pulumi.get(self, "feature_profile_ids")

    @feature_profile_ids.setter
    def feature_profile_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "feature_profile_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyVersions")
    def policy_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of all associated policy versions
        """
        return pulumi.get(self, "policy_versions")

    @policy_versions.setter
    def policy_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_versions", value)


@pulumi.input_type
class _PolicyGroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupDeviceArgs']]]] = None,
                 feature_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 solution: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PolicyGroup resources.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input['PolicyGroupDeviceArgs']]] devices: List of devices
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] feature_profile_ids: List of feature profile IDs
        :param pulumi.Input[_builtins.str] name: The name of the policy group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_versions: List of all associated policy versions
        :param pulumi.Input[_builtins.str] solution: Type of solution
                 - Choices: `sdwan`
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if devices is not None:
            pulumi.set(__self__, "devices", devices)
        if feature_profile_ids is not None:
            pulumi.set(__self__, "feature_profile_ids", feature_profile_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy_versions is not None:
            pulumi.set(__self__, "policy_versions", policy_versions)
        if solution is not None:
            pulumi.set(__self__, "solution", solution)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupDeviceArgs']]]]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

    @devices.setter
    def devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyGroupDeviceArgs']]]]):
        pulumi.set(self, "devices", value)

    @_builtins.property
    @pulumi.getter(name="featureProfileIds")
    def feature_profile_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of feature profile IDs
        """
        return pulumi.get(self, "feature_profile_ids")

    @feature_profile_ids.setter
    def feature_profile_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "feature_profile_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the policy group
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="policyVersions")
    def policy_versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of all associated policy versions
        """
        return pulumi.get(self, "policy_versions")

    @policy_versions.setter
    def policy_versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_versions", value)

    @_builtins.property
    @pulumi.getter
    def solution(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of solution
          - Choices: `sdwan`
        """
        return pulumi.get(self, "solution")

    @solution.setter
    def solution(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "solution", value)


@pulumi.type_token("sdwan:index/policyGroup:PolicyGroup")
class PolicyGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupDeviceArgs', 'PolicyGroupDeviceArgsDict']]]]] = None,
                 feature_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 solution: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Policy Group .
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.PolicyGroup("example",
            name="PG_1",
            description="My policy group 1",
            solution="sdwan",
            feature_profile_ids=["f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"],
            devices=[{
                "id": "C8K-40C0CCFD-9EA8-2B2E-E73B-32C5924EC79B",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/policyGroup:PolicyGroup example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupDeviceArgs', 'PolicyGroupDeviceArgsDict']]]] devices: List of devices
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] feature_profile_ids: List of feature profile IDs
        :param pulumi.Input[_builtins.str] name: The name of the policy group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_versions: List of all associated policy versions
        :param pulumi.Input[_builtins.str] solution: Type of solution
                 - Choices: `sdwan`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Policy Group .
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.PolicyGroup("example",
            name="PG_1",
            description="My policy group 1",
            solution="sdwan",
            feature_profile_ids=["f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"],
            devices=[{
                "id": "C8K-40C0CCFD-9EA8-2B2E-E73B-32C5924EC79B",
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import sdwan:index/policyGroup:PolicyGroup example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param PolicyGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupDeviceArgs', 'PolicyGroupDeviceArgsDict']]]]] = None,
                 feature_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 solution: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyGroupArgs.__new__(PolicyGroupArgs)

            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["devices"] = devices
            __props__.__dict__["feature_profile_ids"] = feature_profile_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["policy_versions"] = policy_versions
            if solution is None and not opts.urn:
                raise TypeError("Missing required property 'solution'")
            __props__.__dict__["solution"] = solution
        super(PolicyGroup, __self__).__init__(
            'sdwan:index/policyGroup:PolicyGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            devices: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupDeviceArgs', 'PolicyGroupDeviceArgsDict']]]]] = None,
            feature_profile_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            policy_versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            solution: Optional[pulumi.Input[_builtins.str]] = None) -> 'PolicyGroup':
        """
        Get an existing PolicyGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[Sequence[pulumi.Input[Union['PolicyGroupDeviceArgs', 'PolicyGroupDeviceArgsDict']]]] devices: List of devices
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] feature_profile_ids: List of feature profile IDs
        :param pulumi.Input[_builtins.str] name: The name of the policy group
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_versions: List of all associated policy versions
        :param pulumi.Input[_builtins.str] solution: Type of solution
                 - Choices: `sdwan`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyGroupState.__new__(_PolicyGroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["devices"] = devices
        __props__.__dict__["feature_profile_ids"] = feature_profile_ids
        __props__.__dict__["name"] = name
        __props__.__dict__["policy_versions"] = policy_versions
        __props__.__dict__["solution"] = solution
        return PolicyGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def devices(self) -> pulumi.Output[Optional[Sequence['outputs.PolicyGroupDevice']]]:
        """
        List of devices
        """
        return pulumi.get(self, "devices")

    @_builtins.property
    @pulumi.getter(name="featureProfileIds")
    def feature_profile_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of feature profile IDs
        """
        return pulumi.get(self, "feature_profile_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the policy group
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="policyVersions")
    def policy_versions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of all associated policy versions
        """
        return pulumi.get(self, "policy_versions")

    @_builtins.property
    @pulumi.getter
    def solution(self) -> pulumi.Output[_builtins.str]:
        """
        Type of solution
          - Choices: `sdwan`
        """
        return pulumi.get(self, "solution")

