<a id="mypy-boto3-organizations"></a>

# mypy-boto3-organizations

[![PyPI - mypy-boto3-organizations](https://img.shields.io/pypi/v/mypy-boto3-organizations.svg?color=blue)](https://pypi.org/project/mypy-boto3-organizations)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-organizations.svg?color=blue)](https://pypi.org/project/mypy-boto3-organizations)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-organizations?color=blue)](https://pypistats.org/packages/mypy-boto3-organizations)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.Organizations 1.18.8](https://boto3.amazonaws.com/v1/documentation/api/1.18.8/reference/services/organizations.html#Organizations)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-organizations docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_organizations/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-organizations](#mypy-boto3-organizations)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `Organizations` service.

```bash
python -m pip install boto3-stubs[organizations]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[organizations]` in your environment:
  `python -m pip install 'boto3-stubs[organizations]'`

Both type checking and auto-complete should work for `Organizations` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[organizations]` in your environment:
  `python -m pip install 'boto3-stubs[organizations]'`

Both type checking and auto-complete should work for `Organizations` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[organizations]` in your environment:
  `python -m pip install 'boto3-stubs[organizations]'`
- Run `mypy` as usual

Type checking should work for `Organizations` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[organizations]` in your environment:
  `python -m pip install 'boto3-stubs[organizations]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Organizations` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`OrganizationsClient` provides annotations for `boto3.client("organizations")`.

```python
import boto3

from mypy_boto3_organizations import OrganizationsClient

client: OrganizationsClient = boto3.client("organizations")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: OrganizationsClient = session.client("organizations")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_organizations.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_organizations import OrganizationsClient
from mypy_boto3_organizations.paginator import (
    ListAWSServiceAccessForOrganizationPaginator,
    ListAccountsPaginator,
    ListAccountsForParentPaginator,
    ListChildrenPaginator,
    ListCreateAccountStatusPaginator,
    ListDelegatedAdministratorsPaginator,
    ListDelegatedServicesForAccountPaginator,
    ListHandshakesForAccountPaginator,
    ListHandshakesForOrganizationPaginator,
    ListOrganizationalUnitsForParentPaginator,
    ListParentsPaginator,
    ListPoliciesPaginator,
    ListPoliciesForTargetPaginator,
    ListRootsPaginator,
    ListTagsForResourcePaginator,
    ListTargetsForPolicyPaginator,
)

client: OrganizationsClient = boto3.client("organizations")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_aws_service_access_for_organization_paginator: ListAWSServiceAccessForOrganizationPaginator = client.get_paginator("list_aws_service_access_for_organization")
list_accounts_paginator: ListAccountsPaginator = client.get_paginator("list_accounts")
list_accounts_for_parent_paginator: ListAccountsForParentPaginator = client.get_paginator("list_accounts_for_parent")
list_children_paginator: ListChildrenPaginator = client.get_paginator("list_children")
list_create_account_status_paginator: ListCreateAccountStatusPaginator = client.get_paginator("list_create_account_status")
list_delegated_administrators_paginator: ListDelegatedAdministratorsPaginator = client.get_paginator("list_delegated_administrators")
list_delegated_services_for_account_paginator: ListDelegatedServicesForAccountPaginator = client.get_paginator("list_delegated_services_for_account")
list_handshakes_for_account_paginator: ListHandshakesForAccountPaginator = client.get_paginator("list_handshakes_for_account")
list_handshakes_for_organization_paginator: ListHandshakesForOrganizationPaginator = client.get_paginator("list_handshakes_for_organization")
list_organizational_units_for_parent_paginator: ListOrganizationalUnitsForParentPaginator = client.get_paginator("list_organizational_units_for_parent")
list_parents_paginator: ListParentsPaginator = client.get_paginator("list_parents")
list_policies_paginator: ListPoliciesPaginator = client.get_paginator("list_policies")
list_policies_for_target_paginator: ListPoliciesForTargetPaginator = client.get_paginator("list_policies_for_target")
list_roots_paginator: ListRootsPaginator = client.get_paginator("list_roots")
list_tags_for_resource_paginator: ListTagsForResourcePaginator = client.get_paginator("list_tags_for_resource")
list_targets_for_policy_paginator: ListTargetsForPolicyPaginator = client.get_paginator("list_targets_for_policy")
```

<a id="literals"></a>

### Literals

`mypy_boto3_organizations.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_organizations.literals import (
    AccountJoinedMethodType,
    AccountStatusType,
    ActionTypeType,
    ChildTypeType,
    CreateAccountFailureReasonType,
    CreateAccountStateType,
    EffectivePolicyTypeType,
    HandshakePartyTypeType,
    HandshakeResourceTypeType,
    HandshakeStateType,
    IAMUserAccessToBillingType,
    ListAWSServiceAccessForOrganizationPaginatorName,
    ListAccountsForParentPaginatorName,
    ListAccountsPaginatorName,
    ListChildrenPaginatorName,
    ListCreateAccountStatusPaginatorName,
    ListDelegatedAdministratorsPaginatorName,
    ListDelegatedServicesForAccountPaginatorName,
    ListHandshakesForAccountPaginatorName,
    ListHandshakesForOrganizationPaginatorName,
    ListOrganizationalUnitsForParentPaginatorName,
    ListParentsPaginatorName,
    ListPoliciesForTargetPaginatorName,
    ListPoliciesPaginatorName,
    ListRootsPaginatorName,
    ListTagsForResourcePaginatorName,
    ListTargetsForPolicyPaginatorName,
    OrganizationFeatureSetType,
    ParentTypeType,
    PolicyTypeStatusType,
    PolicyTypeType,
    TargetTypeType,
)

def check_value(value: AccountJoinedMethodType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_organizations.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_organizations.type_defs import (
    AcceptHandshakeRequestRequestTypeDef,
    AcceptHandshakeResponseTypeDef,
    AccountTypeDef,
    AttachPolicyRequestRequestTypeDef,
    CancelHandshakeRequestRequestTypeDef,
    CancelHandshakeResponseTypeDef,
    ChildTypeDef,
    CreateAccountRequestRequestTypeDef,
    CreateAccountResponseTypeDef,
    CreateAccountStatusTypeDef,
    CreateGovCloudAccountRequestRequestTypeDef,
    CreateGovCloudAccountResponseTypeDef,
    CreateOrganizationRequestRequestTypeDef,
    CreateOrganizationResponseTypeDef,
    CreateOrganizationalUnitRequestRequestTypeDef,
    CreateOrganizationalUnitResponseTypeDef,
    CreatePolicyRequestRequestTypeDef,
    CreatePolicyResponseTypeDef,
    DeclineHandshakeRequestRequestTypeDef,
    DeclineHandshakeResponseTypeDef,
    DelegatedAdministratorTypeDef,
    DelegatedServiceTypeDef,
    DeleteOrganizationalUnitRequestRequestTypeDef,
    DeletePolicyRequestRequestTypeDef,
    DeregisterDelegatedAdministratorRequestRequestTypeDef,
    DescribeAccountRequestRequestTypeDef,
    DescribeAccountResponseTypeDef,
    DescribeCreateAccountStatusRequestRequestTypeDef,
    DescribeCreateAccountStatusResponseTypeDef,
    DescribeEffectivePolicyRequestRequestTypeDef,
    DescribeEffectivePolicyResponseTypeDef,
    DescribeHandshakeRequestRequestTypeDef,
    DescribeHandshakeResponseTypeDef,
    DescribeOrganizationResponseTypeDef,
    DescribeOrganizationalUnitRequestRequestTypeDef,
    DescribeOrganizationalUnitResponseTypeDef,
    DescribePolicyRequestRequestTypeDef,
    DescribePolicyResponseTypeDef,
    DetachPolicyRequestRequestTypeDef,
    DisableAWSServiceAccessRequestRequestTypeDef,
    DisablePolicyTypeRequestRequestTypeDef,
    DisablePolicyTypeResponseTypeDef,
    EffectivePolicyTypeDef,
    EnableAWSServiceAccessRequestRequestTypeDef,
    EnableAllFeaturesResponseTypeDef,
    EnablePolicyTypeRequestRequestTypeDef,
    EnablePolicyTypeResponseTypeDef,
    EnabledServicePrincipalTypeDef,
    HandshakeFilterTypeDef,
    HandshakePartyTypeDef,
    HandshakeResourceTypeDef,
    HandshakeTypeDef,
    InviteAccountToOrganizationRequestRequestTypeDef,
    InviteAccountToOrganizationResponseTypeDef,
    ListAWSServiceAccessForOrganizationRequestRequestTypeDef,
    ListAWSServiceAccessForOrganizationResponseTypeDef,
    ListAccountsForParentRequestRequestTypeDef,
    ListAccountsForParentResponseTypeDef,
    ListAccountsRequestRequestTypeDef,
    ListAccountsResponseTypeDef,
    ListChildrenRequestRequestTypeDef,
    ListChildrenResponseTypeDef,
    ListCreateAccountStatusRequestRequestTypeDef,
    ListCreateAccountStatusResponseTypeDef,
    ListDelegatedAdministratorsRequestRequestTypeDef,
    ListDelegatedAdministratorsResponseTypeDef,
    ListDelegatedServicesForAccountRequestRequestTypeDef,
    ListDelegatedServicesForAccountResponseTypeDef,
    ListHandshakesForAccountRequestRequestTypeDef,
    ListHandshakesForAccountResponseTypeDef,
    ListHandshakesForOrganizationRequestRequestTypeDef,
    ListHandshakesForOrganizationResponseTypeDef,
    ListOrganizationalUnitsForParentRequestRequestTypeDef,
    ListOrganizationalUnitsForParentResponseTypeDef,
    ListParentsRequestRequestTypeDef,
    ListParentsResponseTypeDef,
    ListPoliciesForTargetRequestRequestTypeDef,
    ListPoliciesForTargetResponseTypeDef,
    ListPoliciesRequestRequestTypeDef,
    ListPoliciesResponseTypeDef,
    ListRootsRequestRequestTypeDef,
    ListRootsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListTargetsForPolicyRequestRequestTypeDef,
    ListTargetsForPolicyResponseTypeDef,
    MoveAccountRequestRequestTypeDef,
    OrganizationTypeDef,
    OrganizationalUnitTypeDef,
    PaginatorConfigTypeDef,
    ParentTypeDef,
    PolicySummaryTypeDef,
    PolicyTargetSummaryTypeDef,
    PolicyTypeDef,
    PolicyTypeSummaryTypeDef,
    RegisterDelegatedAdministratorRequestRequestTypeDef,
    RemoveAccountFromOrganizationRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    RootTypeDef,
    TagResourceRequestRequestTypeDef,
    TagTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateOrganizationalUnitRequestRequestTypeDef,
    UpdateOrganizationalUnitResponseTypeDef,
    UpdatePolicyRequestRequestTypeDef,
    UpdatePolicyResponseTypeDef,
)

def get_structure() -> AcceptHandshakeRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-organizations` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-organizations docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_organizations/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
