/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.interactive.client.common;

import com.alibaba.graphscope.interactive.ApiException;
import com.alibaba.graphscope.interactive.ApiResponse;
import com.alibaba.graphscope.interactive.client.common.Status;

public class Result<T> {
    private final Status status;
    private final T value;

    public Result(Status status, T value) {
        this.status = status;
        this.value = value;
    }

    public Result(T value) {
        this.status = Status.Ok();
        this.value = value;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.status.getMessage();
    }

    public Status.StatusCode getStatusCode() {
        return this.status.getCode();
    }

    public T getValue() {
        return this.value;
    }

    public static <T> Result<T> ok(T value) {
        return new Result<T>(Status.Ok(), value);
    }

    public static <T> Result<T> error(String message) {
        return new Result<Object>(new Status(Status.StatusCode.kUnknown, message), null);
    }

    public static <T> Result<T> fromException(ApiException exception) {
        return new Result<Object>(Status.fromException(exception), null);
    }

    public static <T> Result<T> fromResponse(ApiResponse<T> response) {
        return new Result<T>(Status.fromResponse(response), response.getData());
    }

    public boolean isOk() {
        return this.status.IsOk();
    }
}

