/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.interactive.models;

import com.alibaba.graphscope.interactive.JSON;
import com.alibaba.graphscope.interactive.models.AbstractOpenApiSchema;
import com.alibaba.graphscope.interactive.models.PrimitiveType;
import com.alibaba.graphscope.interactive.models.StringType;
import com.alibaba.graphscope.interactive.models.TemporalType;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GSDataType
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(GSDataType.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public GSDataType() {
        super("oneOf", Boolean.FALSE);
    }

    public GSDataType(Object o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof PrimitiveType) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof StringType) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof TemporalType) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be PrimitiveType, StringType, TemporalType");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public PrimitiveType getPrimitiveType() throws ClassCastException {
        return (PrimitiveType)super.getActualInstance();
    }

    public StringType getStringType() throws ClassCastException {
        return (StringType)super.getActualInstance();
    }

    public TemporalType getTemporalType() throws ClassCastException {
        return (TemporalType)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            PrimitiveType.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for PrimitiveType failed with `%s`.", e.getMessage()));
        }
        try {
            StringType.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for StringType failed with `%s`.", e.getMessage()));
        }
        try {
            TemporalType.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for TemporalType failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for GSDataType with oneOf schemas: PrimitiveType, StringType, TemporalType. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
        }
    }

    public static GSDataType fromJson(String jsonString) throws IOException {
        return (GSDataType)JSON.getGson().fromJson(jsonString, GSDataType.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("PrimitiveType", PrimitiveType.class);
        schemas.put("StringType", StringType.class);
        schemas.put("TemporalType", TemporalType.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GSDataType.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterPrimitiveType = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PrimitiveType.class));
            final TypeAdapter adapterStringType = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(StringType.class));
            final TypeAdapter adapterTemporalType = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TemporalType.class));
            return new TypeAdapter<GSDataType>(){

                public void write(JsonWriter out, GSDataType value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof PrimitiveType) {
                        JsonElement element = adapterPrimitiveType.toJsonTree((Object)((PrimitiveType)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof StringType) {
                        JsonElement element = adapterStringType.toJsonTree((Object)((StringType)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof TemporalType) {
                        JsonElement element = adapterTemporalType.toJsonTree((Object)((TemporalType)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: PrimitiveType, StringType, TemporalType");
                }

                public GSDataType read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        PrimitiveType.validateJsonElement(jsonElement);
                        actualAdapter = adapterPrimitiveType;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'PrimitiveType'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for PrimitiveType failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'PrimitiveType'", e);
                    }
                    try {
                        StringType.validateJsonElement(jsonElement);
                        actualAdapter = adapterStringType;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'StringType'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for StringType failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'StringType'", e);
                    }
                    try {
                        TemporalType.validateJsonElement(jsonElement);
                        actualAdapter = adapterTemporalType;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'TemporalType'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for TemporalType failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'TemporalType'", e);
                    }
                    if (match == 1) {
                        GSDataType ret = new GSDataType();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for GSDataType: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }
}

