/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.interactive.models;

import com.alibaba.graphscope.interactive.JSON;
import com.alibaba.graphscope.interactive.models.AbstractOpenApiSchema;
import com.alibaba.graphscope.interactive.models.FixedChar;
import com.alibaba.graphscope.interactive.models.LongText;
import com.alibaba.graphscope.interactive.models.VarChar;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringTypeString
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(StringTypeString.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public StringTypeString() {
        super("oneOf", Boolean.FALSE);
    }

    public StringTypeString(Object o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof LongText) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof FixedChar) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof VarChar) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be FixedChar, LongText, VarChar");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public LongText getLongText() throws ClassCastException {
        return (LongText)super.getActualInstance();
    }

    public FixedChar getFixedChar() throws ClassCastException {
        return (FixedChar)super.getActualInstance();
    }

    public VarChar getVarChar() throws ClassCastException {
        return (VarChar)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            LongText.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for LongText failed with `%s`.", e.getMessage()));
        }
        try {
            FixedChar.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for FixedChar failed with `%s`.", e.getMessage()));
        }
        try {
            VarChar.validateJsonElement(jsonElement);
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format("Deserialization for VarChar failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format("The JSON string is invalid for StringTypeString with oneOf schemas: FixedChar, LongText, VarChar. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
        }
    }

    public static StringTypeString fromJson(String jsonString) throws IOException {
        return (StringTypeString)JSON.getGson().fromJson(jsonString, StringTypeString.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("LongText", LongText.class);
        schemas.put("FixedChar", FixedChar.class);
        schemas.put("VarChar", VarChar.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!StringTypeString.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterLongText = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LongText.class));
            final TypeAdapter adapterFixedChar = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FixedChar.class));
            final TypeAdapter adapterVarChar = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VarChar.class));
            return new TypeAdapter<StringTypeString>(){

                public void write(JsonWriter out, StringTypeString value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof LongText) {
                        JsonElement element = adapterLongText.toJsonTree((Object)((LongText)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof FixedChar) {
                        JsonElement element = adapterFixedChar.toJsonTree((Object)((FixedChar)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof VarChar) {
                        JsonElement element = adapterVarChar.toJsonTree((Object)((VarChar)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: FixedChar, LongText, VarChar");
                }

                public StringTypeString read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        LongText.validateJsonElement(jsonElement);
                        actualAdapter = adapterLongText;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'LongText'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for LongText failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'LongText'", e);
                    }
                    try {
                        FixedChar.validateJsonElement(jsonElement);
                        actualAdapter = adapterFixedChar;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'FixedChar'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for FixedChar failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'FixedChar'", e);
                    }
                    try {
                        VarChar.validateJsonElement(jsonElement);
                        actualAdapter = adapterVarChar;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'VarChar'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format("Deserialization for VarChar failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'VarChar'", e);
                    }
                    if (match == 1) {
                        StringTypeString ret = new StringTypeString();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    throw new IOException(String.format("Failed deserialization for StringTypeString: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }
}

