/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.config;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FileLoadType;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigs
extends Configs {
    private static ImmutableMap<String, ValueGetter> valueGetterMap;

    public YamlConfigs(String file) throws IOException {
        this(file, FileLoadType.RELATIVE_PATH);
    }

    public YamlConfigs(String file, FileLoadType loadType) throws IOException {
        super(YamlConfigs.loadYamlAsMap(file, loadType));
    }

    private static Map<String, String> loadYamlAsMap(String file, FileLoadType loadType) throws IOException {
        InputStream inputStream = loadType == FileLoadType.RELATIVE_PATH ? new FileInputStream(file) : Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        Yaml yaml = new Yaml();
        HashMap flattenKeyValues = Maps.newHashMap();
        YamlConfigs.flattenAndConvert((Map)yaml.load(inputStream), flattenKeyValues, "");
        return flattenKeyValues;
    }

    private static void flattenAndConvert(Map<String, Object> data, Map<String, String> properties, String parentKey) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = parentKey.isEmpty() ? entry.getKey() : parentKey + "." + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                YamlConfigs.flattenAndConvert((Map)value, properties, key);
                continue;
            }
            properties.put(key, value.toString());
        }
    }

    @Override
    public String get(String name) {
        ValueGetter convertor = (ValueGetter)valueGetterMap.get((Object)name);
        if (convertor != null) {
            return convertor.getValue(this);
        }
        return super.get(name);
    }

    @Override
    public String get(String name, String defaultValue) {
        ValueGetter convertor = (ValueGetter)valueGetterMap.get((Object)name);
        if (convertor != null) {
            String value = convertor.getValue(this);
            return value == null ? defaultValue : value;
        }
        return super.get(name, defaultValue);
    }

    static {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"graph.planner.is.on", configs -> configs.get("compiler.planner.is_on")).put((Object)"graph.planner.opt", configs -> configs.get("compiler.planner.opt")).put((Object)"graph.planner.rules", configs -> {
            String rules = configs.get("compiler.planner.rules");
            if (rules != null) {
                rules = rules.replace("[", "").replace("]", "");
            }
            return rules;
        }).put((Object)"graph.schema", configs -> {
            String schema = System.getProperty("graph.schema");
            if (schema != null) {
                return schema;
            }
            return configs.get("compiler.meta.reader.schema.uri");
        }).put((Object)"graph.statistics", configs -> {
            String statistics = System.getProperty("graph.statistics");
            if (statistics != null) {
                return statistics;
            }
            return configs.get("compiler.meta.reader.statistics.uri");
        }).put((Object)"graph.meta.schema.fetch.interval.ms", configs -> configs.get("compiler.meta.reader.schema.interval")).put((Object)"graph.meta.statistics.fetch.interval.ms", configs -> configs.get("compiler.meta.reader.statistics.interval")).put((Object)"graph.store", configs -> {
            if (configs.get("compute_engine.store.type") != null) {
                return configs.get("compute_engine.store.type");
            }
            return "cpp-mcsr";
        }).put((Object)"graph.physical.opt", configs -> {
            if (configs.get("compiler.physical.opt.config") != null) {
                return configs.get("compiler.physical.opt.config");
            }
            return "ffi";
        }).put((Object)"pegasus.worker.num", configs -> {
            String type = configs.get("compute_engine.type");
            if (type == null || !type.equals("pegasus")) {
                return null;
            }
            return configs.get("compute_engine.thread_num_per_worker");
        }).put((Object)"pegasus.batch.size", configs -> {
            String type = configs.get("compute_engine.type");
            if (type == null || !type.equals("pegasus")) {
                return null;
            }
            return configs.get("compute_engine.batch_size");
        }).put((Object)"pegasus.output.capacity", configs -> {
            String type = configs.get("compute_engine.type");
            if (type == null || !type.equals("pegasus")) {
                return null;
            }
            return configs.get("compute_engine.output_capacity");
        }).put((Object)"pegasus.hosts", configs -> {
            String type = configs.get("compute_engine.type");
            if (type == null || !type.equals("pegasus")) {
                return null;
            }
            String hosts = configs.get("compute_engine.workers");
            if (hosts != null) {
                return hosts.replace("[", "").replace("]", "");
            }
            return hosts;
        }).put((Object)"hiactor.hosts", configs -> {
            String type = configs.get("compute_engine.type");
            if (type == null || !type.equals("hiactor")) {
                return null;
            }
            String port = configs.get("http_service.query_port");
            String address = configs.get("http_service.default_listen_address");
            if (port != null && address != null) {
                String hosts = address + ":" + port;
                return hosts.replace("[", "").replace("]", "");
            }
            return null;
        }).put((Object)"interactive.admin.endpoint", configs -> {
            String host = configs.get("http_service.default_listen_address");
            String port = configs.get("http_service.admin_port");
            if (host != null && port != null) {
                return "http://" + host + ":" + port;
            }
            return null;
        }).put((Object)"interactive.query.endpoint", configs -> {
            String host = configs.get("http_service.default_listen_address");
            String port = configs.get("http_service.query_port");
            if (host != null && port != null) {
                return "http://" + host + ":" + port;
            }
            return null;
        }).put((Object)"neo4j.bolt.server.disabled", configs -> configs.get("compiler.endpoint.bolt_connector.disabled")).put((Object)"neo4j.bolt.server.port", configs -> configs.get("compiler.endpoint.bolt_connector.port")).put((Object)"gremlin.server.disabled", configs -> configs.get("compiler.endpoint.gremlin_connector.disabled")).put((Object)"gremlin.server.port", configs -> configs.get("compiler.endpoint.gremlin_connector.port")).put((Object)"query.execution.timeout.ms", configs -> configs.get("compiler.query_timeout")).put((Object)"engine.type", configs -> configs.get("compute_engine.type")).put((Object)"calcite.default.charset", configs -> configs.get("compiler.calcite_default_charset")).put((Object)"gremlin.script.language.name", configs -> configs.get("compiler.gremlin_script_language_name"));
        valueGetterMap = mapBuilder.build();
    }

    private static interface ValueGetter {
        public String getValue(Configs var1);
    }
}

