/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.exception;

import com.alibaba.graphscope.common.exception.ComponentCode;
import com.alibaba.graphscope.proto.frontend.Code;
import com.google.common.collect.Maps;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FrontendException
extends RuntimeException {
    private final ComponentCode componentCode;
    private final Code errorCode;
    private final Map<String, Object> details;

    public FrontendException(Code errorCode, String errorMsg) {
        this(errorCode, errorMsg, null);
    }

    public FrontendException(Code errorCode, String errorMsg, @Nullable Throwable cause) {
        this(errorCode, errorMsg, Maps.newHashMap(), cause);
    }

    public FrontendException(Code errorCode, String errorMsg, Map<String, Object> details, @Nullable Throwable cause) {
        super(errorMsg);
        if (cause != null) {
            this.setStackTrace(cause.getStackTrace());
        }
        this.componentCode = ComponentCode.FRONTEND;
        this.errorCode = errorCode;
        this.details = Maps.newHashMap(details);
    }

    public Map getDetails() {
        return this.details;
    }

    public Code getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("ErrorCode: ").append(this.errorCode.name()).append("\n");
        Object msg = super.getMessage();
        if (!((String)msg).endsWith("\n")) {
            msg = (String)msg + "\n";
        }
        sb.append("Message: ").append((String)msg);
        sb.append("EC: ").append(String.format("%02d-%04d", this.componentCode.getValue(), this.errorCode.getNumber())).append("\n");
        this.details.forEach((k, v) -> sb.append((String)k).append(": ").append(v).append("\n"));
        return sb.toString();
    }
}

