/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.intermediate;

import com.alibaba.graphscope.common.exception.InterOpIllegalArgException;
import com.alibaba.graphscope.common.intermediate.operator.ApplyOp;
import com.alibaba.graphscope.common.intermediate.operator.InterOpBase;
import com.alibaba.graphscope.common.intermediate.operator.OpArg;
import com.alibaba.graphscope.common.intermediate.process.InterOpProcessor;
import com.alibaba.graphscope.common.intermediate.process.SinkOutputProcessor;
import com.alibaba.graphscope.common.intermediate.process.SubGraphProjectProcessor;
import com.alibaba.graphscope.common.intermediate.strategy.InterOpStrategy;
import com.alibaba.graphscope.common.intermediate.strategy.SourceCountFusionStrategy;
import com.alibaba.graphscope.common.intermediate.strategy.TopKStrategy;
import com.alibaba.graphscope.common.intermediate.strategy.UnfoldFusionStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.list.UnmodifiableList;

public class InterOpCollection {
    private List<InterOpBase> opCollection = new ArrayList<InterOpBase>();
    private static List<InterOpStrategy> strategies = Arrays.asList(TopKStrategy.INSTANCE, UnfoldFusionStrategy.INSTANCE, SourceCountFusionStrategy.INSTANCE);
    private static List<InterOpProcessor> processors = Arrays.asList(SubGraphProjectProcessor.INSTANCE, SinkOutputProcessor.INSTANCE);

    public List<InterOpBase> unmodifiableCollection() {
        return UnmodifiableList.decorate(this.opCollection);
    }

    public void appendInterOp(InterOpBase op) {
        this.opCollection.add(op);
    }

    public void removeInterOp(int i) {
        this.opCollection.remove(i);
    }

    public void replaceInterOp(int i, InterOpBase op) {
        this.opCollection.set(i, op);
    }

    public static void applyStrategies(InterOpCollection opCollection) {
        opCollection.unmodifiableCollection().forEach(op -> {
            if (op instanceof ApplyOp) {
                ApplyOp applyOp = (ApplyOp)op;
                Optional<OpArg> subOps = applyOp.getSubOpCollection();
                if (!subOps.isPresent()) {
                    throw new InterOpIllegalArgException(op.getClass(), "subOpCollection", "is not present in apply");
                }
                InterOpCollection subCollection = (InterOpCollection)subOps.get().applyArg();
                InterOpCollection.applyStrategies(subCollection);
            }
        });
        strategies.forEach(k -> k.apply(opCollection));
    }

    public static void process(InterOpCollection opCollection) {
        processors.forEach(k -> k.process(opCollection));
    }
}

