/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.intermediate.operator;

import com.alibaba.graphscope.common.jna.type.FfiNameOrId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.javatuples.Pair;

public class QueryParams {
    public static String SNAPSHOT_CONFIG_NAME = "SID";
    private List<FfiNameOrId.ByValue> tables;
    private List<FfiNameOrId.ByValue> columns;
    private boolean isAllColumns = false;
    private Optional<Pair<Integer, Integer>> range;
    private Optional<String> predicate = Optional.empty();
    private Map<String, String> extraParams;
    private Optional<Double> sampleRatio;

    public QueryParams() {
        this.range = Optional.empty();
        this.tables = new ArrayList<FfiNameOrId.ByValue>();
        this.columns = new ArrayList<FfiNameOrId.ByValue>();
        this.extraParams = new HashMap<String, String>();
        this.sampleRatio = Optional.empty();
    }

    public void addTable(FfiNameOrId.ByValue name) {
        this.tables.add(name);
    }

    public void addColumn(FfiNameOrId.ByValue name) {
        this.columns.add(name);
    }

    public void setPredicate(String predicate) {
        if (predicate != null) {
            this.predicate = Optional.of(predicate);
        }
    }

    public void setRange(Pair<Integer, Integer> range) {
        if (range != null) {
            this.range = Optional.of(range);
        }
    }

    public void setAllColumns(boolean allColumns) {
        this.isAllColumns = allColumns;
    }

    public List<FfiNameOrId.ByValue> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    public List<FfiNameOrId.ByValue> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public Optional<Pair<Integer, Integer>> getRange() {
        return this.range;
    }

    public Optional<String> getPredicate() {
        return this.predicate;
    }

    public void addExtraParams(String key, String value) {
        this.extraParams.put(key, value);
    }

    public Map<String, String> getExtraParams() {
        return Collections.unmodifiableMap(this.extraParams);
    }

    public boolean isAllColumns() {
        return this.isAllColumns;
    }

    public Optional<Double> getSampleRatioOpt() {
        return this.sampleRatio;
    }

    public void setSampleRatio(double sampleRatio) {
        this.sampleRatio = Optional.of(sampleRatio);
    }
}

