/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.intermediate.process;

import com.alibaba.graphscope.common.exception.InterOpIllegalArgException;
import com.alibaba.graphscope.common.exception.InterOpUnsupportedException;
import com.alibaba.graphscope.common.intermediate.ArgAggFn;
import com.alibaba.graphscope.common.intermediate.ArgUtils;
import com.alibaba.graphscope.common.intermediate.InterOpCollection;
import com.alibaba.graphscope.common.intermediate.operator.ApplyOp;
import com.alibaba.graphscope.common.intermediate.operator.AsNoneOp;
import com.alibaba.graphscope.common.intermediate.operator.DedupOp;
import com.alibaba.graphscope.common.intermediate.operator.ExpandOp;
import com.alibaba.graphscope.common.intermediate.operator.GetVOp;
import com.alibaba.graphscope.common.intermediate.operator.GroupOp;
import com.alibaba.graphscope.common.intermediate.operator.InterOpBase;
import com.alibaba.graphscope.common.intermediate.operator.LimitOp;
import com.alibaba.graphscope.common.intermediate.operator.MatchOp;
import com.alibaba.graphscope.common.intermediate.operator.OpArg;
import com.alibaba.graphscope.common.intermediate.operator.OrderOp;
import com.alibaba.graphscope.common.intermediate.operator.ProjectOp;
import com.alibaba.graphscope.common.intermediate.operator.SampleOp;
import com.alibaba.graphscope.common.intermediate.operator.ScanFusionOp;
import com.alibaba.graphscope.common.intermediate.operator.SelectOp;
import com.alibaba.graphscope.common.intermediate.operator.SinkOp;
import com.alibaba.graphscope.common.intermediate.operator.SubGraphAsUnionOp;
import com.alibaba.graphscope.common.intermediate.operator.UnfoldOp;
import com.alibaba.graphscope.common.intermediate.operator.UnionOp;
import com.alibaba.graphscope.common.intermediate.process.InterOpProcessor;
import com.alibaba.graphscope.common.intermediate.process.SinkArg;
import com.alibaba.graphscope.common.intermediate.process.SinkByColumns;
import com.alibaba.graphscope.common.intermediate.process.SinkGraph;
import com.alibaba.graphscope.common.jna.type.FfiAlias;
import com.alibaba.graphscope.common.jna.type.FfiJoinKind;
import com.alibaba.graphscope.common.jna.type.FfiNameOrId;
import java.util.List;
import java.util.Optional;
import org.javatuples.Pair;

public class SinkOutputProcessor
implements InterOpProcessor {
    public static SinkOutputProcessor INSTANCE = new SinkOutputProcessor();

    private SinkOutputProcessor() {
    }

    @Override
    public void process(InterOpCollection opCollection) {
        SinkOp sinkOp = new SinkOp();
        sinkOp.setSinkArg(new OpArg(this.getSinkArg(opCollection)));
        opCollection.appendInterOp(sinkOp);
    }

    private SinkArg getSinkArg(InterOpCollection opCollection) {
        List<InterOpBase> collections = opCollection.unmodifiableCollection();
        for (int i = collections.size() - 1; i >= 0; --i) {
            InterOpBase cur = collections.get(i);
            if (!(cur instanceof SubGraphAsUnionOp)) continue;
            SubGraphAsUnionOp op2 = (SubGraphAsUnionOp)cur;
            return new SinkGraph(op2.getGraphConfigs());
        }
        SinkByColumns sinkArg = new SinkByColumns();
        for (int i = collections.size() - 1; i >= 0; --i) {
            InterOpBase op3;
            InterOpBase cur = collections.get(i);
            if (cur instanceof DedupOp || cur instanceof LimitOp || cur instanceof OrderOp || cur instanceof SelectOp || cur instanceof AsNoneOp || cur instanceof SampleOp) continue;
            if (cur instanceof ExpandOp || cur instanceof ScanFusionOp || cur instanceof GetVOp || cur instanceof UnfoldOp) {
                sinkArg.addColumnName(ArgUtils.asNoneNameOrId());
                break;
            }
            if (cur instanceof ProjectOp) {
                op3 = (ProjectOp)cur;
                List exprWithAlias = (List)((ProjectOp)op3).getExprWithAlias().get().applyArg();
                for (Pair pair : exprWithAlias) {
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)pair.getValue1());
                    sinkArg.addColumnName(alias.alias);
                }
                break;
            }
            if (cur instanceof GroupOp) {
                op3 = (GroupOp)cur;
                List groupKeys = (List)((GroupOp)op3).getGroupByKeys().get().applyArg();
                for (Pair pair : groupKeys) {
                    FfiAlias.ByValue alias = (FfiAlias.ByValue)((Object)pair.getValue1());
                    sinkArg.addColumnName(alias.alias);
                }
                List groupValues = (List)((GroupOp)op3).getGroupByValues().get().applyArg();
                for (ArgAggFn aggFn : groupValues) {
                    sinkArg.addColumnName(aggFn.getAlias().alias);
                }
                break;
            }
            if (cur instanceof ApplyOp) {
                ApplyOp applyOp = (ApplyOp)cur;
                FfiJoinKind joinKind = (FfiJoinKind)applyOp.getJoinKind().get().applyArg();
                if (joinKind == FfiJoinKind.Semi || joinKind == FfiJoinKind.Anti || joinKind == FfiJoinKind.Inner) continue;
                throw new InterOpUnsupportedException(cur.getClass(), "join kind is unsupported yet");
            }
            if (cur instanceof UnionOp) {
                UnionOp unionOp = (UnionOp)cur;
                Optional<OpArg> subOpsListOpt = unionOp.getSubOpCollectionList();
                if (!subOpsListOpt.isPresent()) {
                    throw new InterOpIllegalArgException(cur.getClass(), "subOpCollectionList", "is not present in union");
                }
                List subOpsList = (List)subOpsListOpt.get().applyArg();
                subOpsList.forEach(op -> {
                    SinkByColumns subSink = (SinkByColumns)this.getSinkArg((InterOpCollection)op);
                    subSink.getColumnNames().forEach(c -> sinkArg.addColumnName((FfiNameOrId.ByValue)((Object)((Object)c))));
                });
                sinkArg.dedup();
                break;
            }
            if (cur instanceof MatchOp) {
                List sentences = (List)((MatchOp)cur).getSentences().get().applyArg();
                sentences.forEach(s -> {
                    sinkArg.addColumnName(s.getStartTag().alias);
                    sinkArg.addColumnName(s.getEndTag().alias);
                });
                sinkArg.dedup();
                break;
            }
            throw new InterOpUnsupportedException(cur.getClass(), "unimplemented yet");
        }
        return sinkArg;
    }
}

