/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.intermediate.strategy;

import com.alibaba.graphscope.common.intermediate.InterOpCollection;
import com.alibaba.graphscope.common.intermediate.operator.InterOpBase;
import com.alibaba.graphscope.common.intermediate.operator.LimitOp;
import com.alibaba.graphscope.common.intermediate.operator.OpArg;
import com.alibaba.graphscope.common.intermediate.operator.OrderOp;
import com.alibaba.graphscope.common.intermediate.strategy.InterOpStrategy;
import java.util.List;
import java.util.Optional;

public class TopKStrategy
implements InterOpStrategy {
    public static TopKStrategy INSTANCE = new TopKStrategy();

    private TopKStrategy() {
    }

    @Override
    public void apply(InterOpCollection opCollection) {
        List<InterOpBase> original = opCollection.unmodifiableCollection();
        for (int i = original.size() - 2; i >= 0; --i) {
            InterOpBase cur = original.get(i);
            LimitOp next = this.nextLimit(original, i);
            if (!(cur instanceof OrderOp) || next == null) continue;
            ((OrderOp)cur).setLower(next.getLower().get());
            ((OrderOp)cur).setUpper(next.getUpper().get());
            Optional<OpArg> nextAlias = next.getAlias();
            if (nextAlias.isPresent()) {
                cur.setAlias(nextAlias.get());
            }
            opCollection.removeInterOp(i + 1);
        }
    }

    private LimitOp nextLimit(List<InterOpBase> original, int cur) {
        int next = cur + 1;
        return next >= 0 && next < original.size() && original.get(next) instanceof LimitOp ? (LimitOp)original.get(next) : null;
    }
}

