/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.fetcher;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.GraphConfig;
import com.alibaba.graphscope.common.ir.meta.GraphId;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.IrMetaStats;
import com.alibaba.graphscope.common.ir.meta.IrMetaTracker;
import com.alibaba.graphscope.common.ir.meta.fetcher.IrMetaFetcher;
import com.alibaba.graphscope.common.ir.meta.reader.IrMetaReader;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaSpec;
import com.alibaba.graphscope.groot.common.schema.api.GraphStatistics;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicIrMetaFetcher
extends IrMetaFetcher
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DynamicIrMetaFetcher.class);
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(2);
    private volatile IrMetaStats currentState;
    private volatile StatsState statsState;
    private volatile Boolean statsEnabled = null;

    public DynamicIrMetaFetcher(Configs configs, IrMetaReader dataReader, IrMetaTracker tracker) {
        super(dataReader, tracker);
        this.scheduler.scheduleAtFixedRate(() -> this.syncMeta(), 2000L, GraphConfig.GRAPH_META_SCHEMA_FETCH_INTERVAL_MS.get(configs), TimeUnit.MILLISECONDS);
        this.scheduler.scheduleAtFixedRate(() -> this.syncStats(this.statsEnabled == null ? false : this.statsEnabled), 2000L, GraphConfig.GRAPH_META_STATISTICS_FETCH_INTERVAL_MS.get(configs), TimeUnit.MILLISECONDS);
    }

    @Override
    public Optional<IrMeta> fetch() {
        return this.currentState == null ? Optional.empty() : Optional.of(this.currentState);
    }

    private synchronized void syncMeta() {
        try {
            GraphStatistics curStats;
            IrMeta meta = this.reader.readMeta();
            logger.debug("schema from remote: {}", meta == null ? null : meta.getSchema().getSchemaSpec(SchemaSpec.Type.IR_CORE_IN_JSON));
            if (this.currentState == null || !this.currentState.getGraphId().equals(meta.getGraphId()) || !this.currentState.getSchema().getVersion().equals(meta.getSchema().getVersion())) {
                this.statsState = StatsState.INITIALIZED;
                curStats = null;
            } else {
                curStats = this.currentState.getStatistics();
            }
            this.currentState = new IrMetaStats(meta.getGraphId(), meta.getSnapshotId(), meta.getSchema(), meta.getStoredProcedures(), curStats);
            boolean statsEnabled = this.getStatsEnabled(this.currentState.getGraphId());
            if (statsEnabled && this.statsState != StatsState.SYNCED || !statsEnabled && this.statsState != StatsState.MOCKED) {
                logger.debug("start to sync stats");
                this.syncStats(statsEnabled);
            }
        }
        catch (Throwable e) {
            logger.warn("failed to read meta data, error is {}", e);
        }
    }

    private boolean getStatsEnabled(GraphId graphId) {
        try {
            return this.statsEnabled == null ? this.reader.syncStatsEnabled(graphId) : this.statsEnabled.booleanValue();
        }
        catch (Throwable e) {
            logger.warn("failed to read stats enabled, error is {}", e);
            return false;
        }
    }

    private synchronized void syncStats(boolean statsEnabled) {
        try {
            if (this.currentState != null && statsEnabled) {
                GraphStatistics stats = this.reader.readStats(this.currentState.getGraphId());
                logger.debug("statistics from remote: {}", (Object)stats);
                if (stats != null && stats.getVertexCount() != 0L) {
                    this.currentState = new IrMetaStats(this.currentState.getSnapshotId(), this.currentState.getSchema(), this.currentState.getStoredProcedures(), stats);
                    if (this.tracker != null) {
                        logger.debug("start to update the glogue");
                        this.tracker.onChanged(this.currentState);
                    }
                    this.statsState = StatsState.SYNCED;
                }
            }
        }
        catch (Throwable e) {
            logger.warn("failed to read graph statistics, error is {}", e);
        }
        finally {
            try {
                if (this.currentState != null && this.tracker != null && this.statsState == StatsState.INITIALIZED) {
                    logger.debug("start to mock the glogue");
                    this.tracker.onChanged(this.currentState);
                    this.statsState = StatsState.MOCKED;
                }
            }
            catch (Throwable t) {
                logger.warn("failed to mock the glogue, error is {}", t);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.scheduler.shutdown();
    }

    public static enum StatsState {
        INITIALIZED,
        MOCKED,
        SYNCED;

    }
}

