/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.fetcher;

import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.IrMetaStats;
import com.alibaba.graphscope.common.ir.meta.IrMetaTracker;
import com.alibaba.graphscope.common.ir.meta.fetcher.IrMetaFetcher;
import com.alibaba.graphscope.common.ir.meta.reader.IrMetaReader;
import com.alibaba.graphscope.groot.common.schema.api.GraphStatistics;
import java.io.IOException;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticIrMetaFetcher
extends IrMetaFetcher {
    private static final Logger logger = LoggerFactory.getLogger(StaticIrMetaFetcher.class);
    private final IrMetaStats metaStats;

    public StaticIrMetaFetcher(IrMetaReader dataReader, IrMetaTracker tracker) throws IOException {
        super(dataReader, tracker);
        IrMeta meta = this.reader.readMeta();
        GraphStatistics stats = meta == null ? null : this.fetchStats(meta);
        this.metaStats = new IrMetaStats(meta.getSnapshotId(), meta.getSchema(), meta.getStoredProcedures(), stats);
        if (tracker != null && stats != null) {
            tracker.onChanged(this.metaStats);
        }
    }

    private @Nullable GraphStatistics fetchStats(IrMeta meta) {
        try {
            return this.reader.readStats(meta.getGraphId());
        }
        catch (Exception e) {
            logger.warn("failed to read graph statistics, error is {}", (Throwable)e);
            return null;
        }
    }

    @Override
    public Optional<IrMeta> fetch() {
        return Optional.of(this.metaStats);
    }
}

