/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.glogue;

import com.alibaba.graphscope.common.ir.meta.glogue.CountHandler;
import com.alibaba.graphscope.common.ir.meta.glogue.DetailedExpandCost;
import com.alibaba.graphscope.common.ir.meta.glogue.ExpandJoin;
import com.alibaba.graphscope.common.ir.meta.glogue.Utils;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.ElementDetails;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.FuzzyPatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.FuzzyPatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternVertex;
import com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class EdgeCostEstimator<T> {
    protected final CountHandler handler;

    public EdgeCostEstimator(CountHandler handler) {
        this.handler = handler;
    }

    public abstract T estimate(Pattern var1, PatternEdge var2, PatternVertex var3);

    public static class Extend
    extends EdgeCostEstimator<DetailedExpandCost> {
        public Extend(CountHandler handler) {
            super(handler);
        }

        @Override
        public DetailedExpandCost estimate(@Nullable Pattern srcPattern, PatternEdge edge, PatternVertex target) {
            PatternVertex src = Utils.getExtendFromVertex(edge, target);
            DetailedExpandCost edgeCost = this.estimateEdge(edge, src, target);
            if (srcPattern == null) {
                return edgeCost;
            }
            double srcPatternCount = this.handler.handle(srcPattern);
            double srcIntersectCount = this.getIntersectCount(src);
            double targetIntersectCount = this.getTargetIntersectCount(srcPattern, target);
            return new DetailedExpandCost(this.getExpandCost(edgeCost.getExpandRows(), srcPatternCount, srcIntersectCount, targetIntersectCount), this.getExpandCost(edgeCost.getExpandFilteringRows(), srcPatternCount, srcIntersectCount, targetIntersectCount), this.getExpandCost(edgeCost.getGetVRows(), srcPatternCount, srcIntersectCount, targetIntersectCount), this.getExpandCost(edgeCost.getGetVFilteringRows(), srcPatternCount, srcIntersectCount, targetIntersectCount));
        }

        private double getExpandCost(double edgeRows, double srcPatternCount, double srcIntersectCount, double targetIntersectCount) {
            Preconditions.checkArgument((Double.compare(srcIntersectCount, 0.0) != 0 ? 1 : 0) != 0, (Object)"srcIntersectCount should not be 0");
            Preconditions.checkArgument((Double.compare(targetIntersectCount, 0.0) != 0 ? 1 : 0) != 0, (Object)"targetIntersectCount should not be 0");
            return Math.max(edgeRows * (srcPatternCount / srcIntersectCount / targetIntersectCount), 1.0);
        }

        private double getIntersectCount(PatternVertex vertex) {
            return this.handler.handle(new Pattern(vertex));
        }

        private double getTargetIntersectCount(Pattern pattern, PatternVertex target) {
            if (!pattern.containsVertex(target)) {
                return 1.0;
            }
            return this.getIntersectCount(target);
        }

        private DetailedExpandCost estimateEdge(PatternEdge edge, PatternVertex src, PatternVertex target) {
            double targetSelectivity = target.getElementDetails().getSelectivity();
            if (Double.compare(targetSelectivity, 1.0) != 0) {
                target = target instanceof SinglePatternVertex ? new SinglePatternVertex(target.getVertexTypeIds().get(0), target.getId()) : new FuzzyPatternVertex(target.getVertexTypeIds(), target.getId());
            }
            double edgeSelectivity = edge.getElementDetails().getSelectivity();
            if (Double.compare(targetSelectivity, 1.0) != 0 || Double.compare(edgeSelectivity, 1.0) != 0) {
                PatternVertex edgeSrc = src == edge.getSrcVertex() ? src : target;
                PatternVertex edgeDst = src == edge.getSrcVertex() ? target : src;
                edge = edge instanceof SinglePatternEdge ? new SinglePatternEdge(edgeSrc, edgeDst, edge.getEdgeTypeIds().get(0), edge.getId(), edge.isBoth(), this.createDetailsWithNoFilter(edge.getElementDetails())) : new FuzzyPatternEdge(edgeSrc, edgeDst, edge.getEdgeTypeIds(), edge.getId(), edge.isBoth(), this.createDetailsWithNoFilter(edge.getElementDetails()));
            }
            Pattern pattern = new Pattern();
            pattern.addVertex(edge.getSrcVertex());
            pattern.addVertex(edge.getDstVertex());
            pattern.addEdge(edge.getSrcVertex(), edge.getDstVertex(), edge);
            double patternCost = this.handler.handle(pattern);
            double expandCost = patternCost + this.handler.labelConstraintsDeltaCost(edge, target) * src.getElementDetails().getSelectivity();
            double expandFilteringCost = expandCost * edgeSelectivity;
            double getVCost = patternCost * edgeSelectivity;
            double getVFilteringCost = getVCost * targetSelectivity;
            return new DetailedExpandCost(expandCost, expandFilteringCost, getVCost, getVFilteringCost);
        }

        private ElementDetails createDetailsWithNoFilter(ElementDetails original) {
            return new ElementDetails(1.0, original.getRange(), original.getPxdInnerGetVTypes(), original.getResultOpt(), original.getPathOpt(), original.isOptional());
        }
    }

    public static class Join
    extends EdgeCostEstimator<ExpandJoin> {
        public Join(CountHandler handler) {
            super(handler);
        }

        @Override
        public ExpandJoin estimate(Pattern srcPattern, PatternEdge edge, PatternVertex target) {
            return null;
        }
    }
}

