/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.glogue.calcite.handler;

import com.alibaba.graphscope.common.config.PlannerConfig;
import com.alibaba.graphscope.common.ir.meta.glogue.calcite.handler.ExternalMetaData;
import com.alibaba.graphscope.common.ir.meta.glogue.calcite.handler.GraphGlogueEdgesHandler;
import com.alibaba.graphscope.common.ir.meta.glogue.calcite.handler.GraphNonCumulativeCostHandler;
import com.alibaba.graphscope.common.ir.meta.glogue.calcite.handler.GraphRowCountHandler;
import com.alibaba.graphscope.common.ir.meta.glogue.calcite.handler.GraphSelectivityHandler;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueQuery;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.MetadataHandlerProvider;

public class GraphMetadataHandlerProvider
implements MetadataHandlerProvider {
    private final RelOptPlanner optPlanner;
    private final GlogueQuery glogueQuery;
    private final PlannerConfig plannerConfig;

    public GraphMetadataHandlerProvider(RelOptPlanner optPlanner, GlogueQuery glogueQuery, PlannerConfig plannerConfig) {
        this.optPlanner = optPlanner;
        this.glogueQuery = glogueQuery;
        this.plannerConfig = plannerConfig;
    }

    public MetadataHandler handler(Class handlerClass) {
        if (handlerClass.equals(BuiltInMetadata.RowCount.Handler.class)) {
            return new GraphRowCountHandler(this.optPlanner, this.glogueQuery);
        }
        if (handlerClass.equals(ExternalMetaData.GlogueEdges.Handler.class)) {
            return new GraphGlogueEdgesHandler(this.glogueQuery);
        }
        if (handlerClass.equals(BuiltInMetadata.NonCumulativeCost.Handler.class)) {
            return new GraphNonCumulativeCostHandler(this.optPlanner, this.plannerConfig);
        }
        if (handlerClass.equals(BuiltInMetadata.Selectivity.Handler.class)) {
            return new GraphSelectivityHandler();
        }
        return (MetadataHandler)handlerClass.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{handlerClass}, (proxy, method, args) -> {
            RelNode r = Objects.requireNonNull((RelNode)args[0], "(RelNode) args[0]");
            throw new JaninoRelMetadataProvider.NoHandler(r.getClass());
        }));
    }

    public MetadataHandler revise(Class handlerClass) {
        List handlers = DefaultRelMetadataProvider.INSTANCE.handlers(handlerClass);
        Preconditions.checkArgument((!handlers.isEmpty() ? 1 : 0) != 0, (Object)("handlerClass=" + handlerClass + " not exist in default meta data provider"));
        MetadataHandler first = (MetadataHandler)handlers.get(0);
        InvocationHandler handler = (proxy, method, args) -> {
            RelNode rel = Objects.requireNonNull((RelNode)args[0], "rel must not be null");
            for (Method method1 : first.getClass().getMethods()) {
                Class<?>[] types = method1.getParameterTypes();
                if (!method.getName().equals(method1.getName()) || types.length <= 0 || !types[0].isAssignableFrom(rel.getClass())) continue;
                return method1.invoke((Object)first, args);
            }
            throw new IllegalArgumentException("can not found any matched functions for method=" + method.getName());
        };
        return (MetadataHandler)handlerClass.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{handlerClass}, handler));
    }

    public GlogueQuery getGlogueQuery() {
        return this.glogueQuery;
    }
}

