/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.procedure;

import com.alibaba.graphscope.common.client.type.ExecutionResponseListener;
import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.IrMetaStats;
import com.alibaba.graphscope.common.ir.meta.schema.GSDataTypeConvertor;
import com.alibaba.graphscope.common.ir.meta.schema.GSDataTypeDesc;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphStatistics;
import com.alibaba.graphscope.common.ir.meta.schema.SchemaSpec;
import com.alibaba.graphscope.common.ir.rex.RexProcedureCall;
import com.alibaba.graphscope.common.ir.tools.GraphPlanExecutor;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.IrResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.yaml.snakeyaml.Yaml;

public class StoredProcedureMeta {
    public static final RelDataTypeFactory typeFactory = new JavaTypeFactoryImpl();
    private final String name;
    private final RelDataType returnType;
    private final List<Parameter> parameters;
    private final Mode mode;
    private final String description;
    private final String extension;
    private final Map<String, Object> options;

    public StoredProcedureMeta(String name, Mode mode, String description, String extension, RelDataType returnType, List<Parameter> parameters, Map<String, Object> options) {
        this.name = name;
        this.mode = mode;
        this.description = description;
        this.extension = extension;
        this.returnType = returnType;
        this.parameters = Objects.requireNonNull(parameters);
        this.options = options;
    }

    public StoredProcedureMeta(Configs configs, String queryStr, RelDataType returnType, List<Parameter> parameters) {
        this(Config.NAME.get(configs), Mode.valueOf(Config.MODE.get(configs)), Config.DESCRIPTION.get(configs), Config.EXTENSION.get(configs), returnType, parameters, (Map<String, Object>)ImmutableMap.of((Object)Config.TYPE.getKey(), (Object)Config.TYPE.get(configs), (Object)Config.QUERY.getKey(), (Object)queryStr));
    }

    public String getName() {
        return this.name;
    }

    public RelDataType getReturnType() {
        return this.returnType;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object getOption(String key) {
        return this.options.getOrDefault(key, null);
    }

    public String toString() {
        return "StoredProcedureMeta{name='" + this.name + "', returnType=" + this.returnType + ", parameters=" + this.parameters + ", option=" + this.options + "}";
    }

    public Mode getMode() {
        return this.mode;
    }

    public static class Config {
        public static final com.alibaba.graphscope.common.config.Config<String> NAME = com.alibaba.graphscope.common.config.Config.stringConfig("name", "default");
        public static final com.alibaba.graphscope.common.config.Config<String> DESCRIPTION = com.alibaba.graphscope.common.config.Config.stringConfig("description", "default desc");
        public static final com.alibaba.graphscope.common.config.Config<String> EXTENSION = com.alibaba.graphscope.common.config.Config.stringConfig("extension", ".so");
        public static final com.alibaba.graphscope.common.config.Config<String> MODE = com.alibaba.graphscope.common.config.Config.stringConfig("mode", "READ");
        public static final com.alibaba.graphscope.common.config.Config<String> TYPE = com.alibaba.graphscope.common.config.Config.stringConfig("type", "UNKNOWN");
        public static final com.alibaba.graphscope.common.config.Config<String> QUERY = com.alibaba.graphscope.common.config.Config.stringConfig("query", "UNKNOWN");
    }

    public static enum Mode implements GraphPlanExecutor
    {
        READ,
        WRITE,
        SCHEMA{

            @Override
            public void execute(GraphPlanner.Summary summary, IrMeta irMeta, ExecutionResponseListener listener) throws Exception {
                String metaInJson;
                RexProcedureCall procedureCall = (RexProcedureCall)summary.getLogicalPlan().getProcedureCall();
                String metaProcedure = procedureCall.op.getName();
                if (metaProcedure.endsWith("schema")) {
                    metaInJson = irMeta.getSchema().getSchemaSpec(SchemaSpec.Type.FLEX_IN_JSON);
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode rootNode = mapper.readTree(metaInJson);
                    metaInJson = mapper.writeValueAsString((Object)rootNode.get("schema"));
                } else if (metaProcedure.endsWith("statistics")) {
                    Preconditions.checkArgument((boolean)(irMeta instanceof IrMetaStats), (String)"cannot get statistics from ir meta, should be instance of %s, but is %s", IrMetaStats.class, irMeta.getClass());
                    metaInJson = ((IrGraphStatistics)((IrMetaStats)irMeta).getStatistics()).getStatsJson();
                } else {
                    throw new IllegalArgumentException("invalid meta procedure: " + metaProcedure);
                }
                IrResult.Entry metaEntry = IrResult.Entry.newBuilder().setElement(IrResult.Element.newBuilder().setObject(Common.Value.newBuilder().setStr(metaInJson).build()).build()).build();
                listener.onNext(IrResult.Record.newBuilder().addColumns(IrResult.Column.newBuilder().setEntry(metaEntry).build()).build());
                listener.onCompleted();
            }
        };

    }

    public static class Deserializer {
        public static StoredProcedureMeta perform(InputStream inputStream) throws IOException {
            GSDataTypeConvertor typeConvertor = GSDataTypeConvertor.Factory.create(RelDataType.class, typeFactory);
            Yaml yaml = new Yaml();
            Map config = (Map)yaml.load(inputStream);
            return new StoredProcedureMeta(Deserializer.getValue(Config.NAME, config), Mode.valueOf(Deserializer.getValue(Config.MODE, config)), Deserializer.getValue(Config.DESCRIPTION, config), Deserializer.getValue(Config.EXTENSION, config), Deserializer.createReturnType((List)config.get("returns"), typeConvertor), Deserializer.createParameters((List)config.get("params"), typeConvertor), (Map<String, Object>)ImmutableMap.of((Object)Config.TYPE.getKey(), (Object)Deserializer.getValue(Config.TYPE, config), (Object)Config.QUERY.getKey(), (Object)Deserializer.getValue(Config.QUERY, config)));
        }

        private static <T> T getValue(com.alibaba.graphscope.common.config.Config<T> config, Map<String, Object> valueMap) {
            Object value = valueMap.get(config.getKey());
            return (T)(value != null ? value : config.get(new Configs((Map<String, String>)ImmutableMap.of())));
        }

        private static RelDataType createReturnType(List config, GSDataTypeConvertor<RelDataType> typeConvertor) {
            ArrayList fields = Lists.newArrayList();
            if (config == null) {
                return new RelRecordType((List)fields);
            }
            Iterator iterator = config.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                Map field = (Map)iterator.next();
                fields.add(new RelDataTypeFieldImpl((String)field.get("name"), index, typeConvertor.convert(new GSDataTypeDesc((Map)field.get("type")))));
                ++index;
            }
            return new RelRecordType((List)fields);
        }

        private static List<Parameter> createParameters(List config, GSDataTypeConvertor<RelDataType> typeConvertor) {
            ArrayList parameters = Lists.newArrayList();
            if (config == null) {
                return parameters;
            }
            for (Map field : config) {
                parameters.add(new Parameter((String)field.get("name"), typeConvertor.convert(new GSDataTypeDesc((Map)field.get("type")))));
            }
            return parameters;
        }
    }

    public static class Serializer {
        public static void perform(StoredProcedureMeta meta, OutputStream outputStream) throws IOException {
            Yaml yaml = new Yaml();
            String mapStr = yaml.dump(Serializer.createProduceMetaMap(meta));
            outputStream.write(mapStr.getBytes(StandardCharsets.UTF_8));
        }

        private static Map<String, Object> createProduceMetaMap(StoredProcedureMeta meta) {
            GSDataTypeConvertor typeConvertor = GSDataTypeConvertor.Factory.create(RelDataType.class, typeFactory);
            return ImmutableMap.of((Object)Config.NAME.getKey(), (Object)meta.name, (Object)Config.DESCRIPTION.getKey(), (Object)meta.description, (Object)Config.MODE.getKey(), (Object)meta.mode.name(), (Object)Config.EXTENSION.getKey(), (Object)meta.extension, (Object)"library", (Object)String.format("lib%s%s", meta.name, meta.extension), (Object)"params", meta.parameters.stream().map(k -> ImmutableMap.of((Object)"name", (Object)k.name, (Object)"type", typeConvertor.convert(k.getDataType()).getYamlDesc())).collect(Collectors.toList()), (Object)"returns", meta.returnType.getFieldList().stream().map(k -> ImmutableMap.of((Object)"name", (Object)k.getName(), (Object)"type", typeConvertor.convert(k.getType()).getYamlDesc())).collect(Collectors.toList()), (Object)Config.TYPE.getKey(), (Object)meta.options.get(Config.TYPE.getKey()), (Object)Config.QUERY.getKey(), (Object)meta.options.get(Config.QUERY.getKey()));
        }
    }

    public static class Parameter {
        private final String name;
        private final RelDataType dataType;

        public Parameter(String name, RelDataType dataType) {
            this.name = name;
            this.dataType = dataType;
        }

        public String getName() {
            return this.name;
        }

        public RelDataType getDataType() {
            return this.dataType;
        }

        public String toString() {
            return "Parameter{name='" + this.name + "', dataType=" + this.dataType + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return Objects.equals(this.name, parameter.name) && Objects.equals(this.dataType, parameter.dataType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.dataType);
        }
    }
}

