/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema;

import com.alibaba.graphscope.common.ir.meta.schema.GSDataTypeDesc;
import com.alibaba.graphscope.common.ir.type.ArbitraryArrayType;
import com.alibaba.graphscope.common.ir.type.ArbitraryMapType;
import com.alibaba.graphscope.groot.common.schema.wrapper.DataType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface GSDataTypeConvertor<T> {
    public T convert(GSDataTypeDesc var1);

    public GSDataTypeDesc convert(T var1);

    public static class Factory {
        public static GSDataTypeConvertor create(Class tType, final @Nullable Object config) {
            if (tType.equals(DataType.class)) {
                return new GSDataTypeConvertor<DataType>(){

                    @Override
                    public DataType convert(GSDataTypeDesc from) {
                        Map<String, Object> typeMap = from.getYamlDesc();
                        Object value = typeMap.get("primitive_type");
                        if (value != null) {
                            switch (value.toString()) {
                                case "DT_SIGNED_INT32": {
                                    return DataType.INT;
                                }
                                case "DT_SIGNED_INT64": {
                                    return DataType.LONG;
                                }
                                case "DT_BOOL": {
                                    return DataType.BOOL;
                                }
                                case "DT_FLOAT": {
                                    return DataType.FLOAT;
                                }
                                case "DT_DOUBLE": {
                                    return DataType.DOUBLE;
                                }
                            }
                            throw new UnsupportedOperationException("can not convert GSDataTypeDesc [" + from + "] to DataType");
                        }
                        value = typeMap.get("string");
                        if (value != null) {
                            Map strType = (Map)value;
                            if (strType.containsKey("long_text")) {
                                return DataType.STRING;
                            }
                            throw new UnsupportedOperationException("can not convert GSDataTypeDesc [" + from + "] to DataType");
                        }
                        value = typeMap.get("temporal");
                        if (value != null) {
                            Map temporalType = (Map)value;
                            if (temporalType.containsKey("date32")) {
                                return DataType.DATE;
                            }
                            if (temporalType.containsKey("time32")) {
                                return DataType.TIME32;
                            }
                            if (temporalType.containsKey("timestamp")) {
                                return DataType.TIMESTAMP;
                            }
                            throw new UnsupportedOperationException("can not convert GSDataTypeDesc [" + from + "] to DataType");
                        }
                        throw new UnsupportedOperationException("can not convert GSDataTypeDesc [" + from + "] to DataType");
                    }

                    @Override
                    public GSDataTypeDesc convert(DataType from) {
                        throw new UnsupportedOperationException("convert from DataType to GSDataTypeDesc is unsupported yet");
                    }
                };
            }
            if (tType.equals(RelDataType.class)) {
                return new GSDataTypeConvertor<RelDataType>(){

                    @Override
                    public RelDataType convert(GSDataTypeDesc from) {
                        RelDataTypeFactory typeFactory = (RelDataTypeFactory)config;
                        Map<String, Object> typeMap = from.getYamlDesc();
                        Object value = typeMap.get("primitive_type");
                        if (value != null) {
                            switch (value.toString()) {
                                case "DT_SIGNED_INT32": {
                                    return typeFactory.createSqlType(SqlTypeName.INTEGER);
                                }
                                case "DT_SIGNED_INT64": {
                                    return typeFactory.createSqlType(SqlTypeName.BIGINT);
                                }
                                case "DT_BOOL": {
                                    return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
                                }
                                case "DT_FLOAT": {
                                    return typeFactory.createSqlType(SqlTypeName.FLOAT);
                                }
                                case "DT_DOUBLE": {
                                    return typeFactory.createSqlType(SqlTypeName.DOUBLE);
                                }
                            }
                            throw new UnsupportedOperationException("can not convert GSDataTypeDesc [" + from + "] to RelDataType");
                        }
                        value = typeMap.get("string");
                        if (value != null) {
                            Map strType = (Map)value;
                            if (strType.containsKey("long_text")) {
                                return typeFactory.createSqlType(SqlTypeName.CHAR);
                            }
                            throw new UnsupportedOperationException("can not convert GSDataTypeDesc [" + from + "] to RelDataType");
                        }
                        value = typeMap.get("temporal");
                        if (value != null) {
                            Map temporalType = (Map)value;
                            if (temporalType.containsKey("date32")) {
                                return typeFactory.createSqlType(SqlTypeName.DATE);
                            }
                            if (temporalType.containsKey("time32")) {
                                return typeFactory.createSqlType(SqlTypeName.TIME);
                            }
                            if (temporalType.containsKey("timestamp")) {
                                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
                            }
                            throw new UnsupportedOperationException("can not convert GSDataTypeDesc [" + from + "] to RelDataType");
                        }
                        value = typeMap.get("array");
                        if (value != null) {
                            Map arrayType = (Map)value;
                            Map componentType = (Map)arrayType.get("component_type");
                            Preconditions.checkArgument((componentType != null ? 1 : 0) != 0, (Object)"field 'component_type' is required in array type");
                            return typeFactory.createArrayType(this.convert(new GSDataTypeDesc(componentType)), -1L);
                        }
                        value = typeMap.get("map");
                        if (value != null) {
                            Map mapType = (Map)value;
                            Map keyType = (Map)mapType.get("key_type");
                            Preconditions.checkArgument((keyType != null ? 1 : 0) != 0, (Object)"field 'key_type' is required in map type");
                            Map valueType = (Map)mapType.get("value_type");
                            Preconditions.checkArgument((valueType != null ? 1 : 0) != 0, (Object)"field 'value_type' is required in map type");
                            return typeFactory.createMapType(this.convert(new GSDataTypeDesc(keyType)), this.convert(new GSDataTypeDesc(valueType)));
                        }
                        throw new UnsupportedOperationException("can not convert GSDataTypeDesc [" + from + "] to RelDataType");
                    }

                    @Override
                    public GSDataTypeDesc convert(RelDataType from) {
                        ImmutableMap yamlDesc;
                        SqlTypeName typeName = from.getSqlTypeName();
                        switch (typeName) {
                            case INTEGER: {
                                yamlDesc = ImmutableMap.of((Object)"primitive_type", (Object)"DT_SIGNED_INT32");
                                break;
                            }
                            case BIGINT: {
                                yamlDesc = ImmutableMap.of((Object)"primitive_type", (Object)"DT_SIGNED_INT64");
                                break;
                            }
                            case BOOLEAN: {
                                yamlDesc = ImmutableMap.of((Object)"primitive_type", (Object)"DT_BOOL");
                                break;
                            }
                            case FLOAT: {
                                yamlDesc = ImmutableMap.of((Object)"primitive_type", (Object)"DT_FLOAT");
                                break;
                            }
                            case DOUBLE: {
                                yamlDesc = ImmutableMap.of((Object)"primitive_type", (Object)"DT_DOUBLE");
                                break;
                            }
                            case CHAR: {
                                HashMap longTextMap = Maps.newHashMap();
                                longTextMap.put("long_text", null);
                                yamlDesc = ImmutableMap.of((Object)"string", (Object)longTextMap);
                                break;
                            }
                            case DATE: {
                                HashMap dateMap = Maps.newHashMap();
                                dateMap.put("date32", null);
                                yamlDesc = ImmutableMap.of((Object)"temporal", (Object)dateMap);
                                break;
                            }
                            case TIME: {
                                HashMap timeMap = Maps.newHashMap();
                                timeMap.put("time32", null);
                                yamlDesc = ImmutableMap.of((Object)"temporal", (Object)timeMap);
                                break;
                            }
                            case TIMESTAMP: {
                                HashMap timestampMap = Maps.newHashMap();
                                timestampMap.put("timestamp", null);
                                yamlDesc = ImmutableMap.of((Object)"temporal", (Object)timestampMap);
                                break;
                            }
                            case ARRAY: 
                            case MULTISET: {
                                Object componentType = from instanceof ArbitraryArrayType ? ImmutableMap.of((Object)"primitive_type", (Object)"DT_ANY") : this.convert(from.getComponentType()).getYamlDesc();
                                yamlDesc = ImmutableMap.of((Object)"array", (Object)ImmutableMap.of((Object)"component_type", (Object)componentType, (Object)"max_length", (Object)Integer.MAX_VALUE));
                                break;
                            }
                            case MAP: {
                                Object valueType;
                                Object keyType;
                                if (from instanceof ArbitraryMapType) {
                                    keyType = ImmutableMap.of((Object)"primitive_type", (Object)"DT_ANY");
                                    valueType = ImmutableMap.of((Object)"primitive_type", (Object)"DT_ANY");
                                } else {
                                    keyType = this.convert(from.getKeyType()).getYamlDesc();
                                    valueType = this.convert(from.getValueType()).getYamlDesc();
                                }
                                yamlDesc = ImmutableMap.of((Object)"map", (Object)ImmutableMap.of((Object)"key_type", (Object)keyType, (Object)"value_type", (Object)valueType));
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException("can not convert RelDataType [" + from + "] to GSDataTypeDesc");
                            }
                        }
                        return new GSDataTypeDesc((Map<String, Object>)yamlDesc);
                    }
                };
            }
            throw new UnsupportedOperationException("unsupported type class " + tType + " in GSDataTypeConvertor.Factory.create");
        }
    }
}

