/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema;

import com.alibaba.graphscope.common.ir.meta.schema.GraphOptSchema;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.alibaba.graphscope.groot.common.schema.api.EdgeRelation;
import com.alibaba.graphscope.groot.common.schema.api.GraphEdge;
import com.alibaba.graphscope.groot.common.schema.api.GraphElement;
import com.alibaba.graphscope.groot.common.schema.api.GraphProperty;
import com.alibaba.graphscope.groot.common.schema.api.GraphVertex;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphOptTable
implements RelOptTable {
    private List<String> tableName;
    private RelOptSchema schema;
    private RelDataType dataType;
    private final List<ImmutableBitSet> uniqueKeys;

    protected GraphOptTable(RelOptSchema schema, List<String> tableName, GraphElement element) {
        this.schema = schema;
        this.tableName = tableName;
        this.dataType = this.deriveType(element);
        this.uniqueKeys = this.getUniqueKeys(element, this.dataType, schema);
    }

    private RelDataType deriveType(GraphElement element) {
        List properties = element.getPropertyList();
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
        boolean isColumnId = this.schema instanceof GraphOptSchema ? ((GraphOptSchema)this.schema).getRootSchema().isColumnId() : false;
        for (int i = 0; i < properties.size(); ++i) {
            GraphProperty property = (GraphProperty)properties.get(i);
            fields.add((RelDataTypeField)new RelDataTypeFieldImpl(property.getName(), isColumnId ? property.getId() : -1, this.deriveType(property)));
        }
        if (element instanceof GraphVertex) {
            GraphLabelType labelType = new GraphLabelType(new GraphLabelType.Entry().label(element.getLabel()).labelId(element.getLabelId()));
            return new GraphSchemaType(GraphOpt.Source.VERTEX, labelType, fields);
        }
        if (element instanceof GraphEdge) {
            GraphEdge edge = (GraphEdge)element;
            List relations = edge.getRelationList();
            ArrayList<GraphSchemaType> fuzzyTypes = new ArrayList<GraphSchemaType>();
            for (EdgeRelation relation : relations) {
                GraphLabelType.Entry labelEntry = new GraphLabelType.Entry().label(element.getLabel()).labelId(element.getLabelId());
                GraphVertex src = relation.getSource();
                GraphVertex dst = relation.getTarget();
                labelEntry.srcLabel(src.getLabel()).dstLabel(dst.getLabel());
                labelEntry.srcLabelId(src.getLabelId()).dstLabelId(dst.getLabelId());
                fuzzyTypes.add(new GraphSchemaType(GraphOpt.Source.EDGE, new GraphLabelType(labelEntry), fields));
            }
            ObjectUtils.requireNonEmpty(fuzzyTypes);
            return fuzzyTypes.size() == 1 ? (RelDataType)fuzzyTypes.get(0) : GraphSchemaType.create(fuzzyTypes, this.getRelOptSchema().getTypeFactory());
        }
        throw new IllegalArgumentException("element should be vertex or edge");
    }

    private List<ImmutableBitSet> getUniqueKeys(GraphElement element, RelDataType schemaType, RelOptSchema schema) {
        boolean isColumnId = schema instanceof GraphOptSchema ? ((GraphOptSchema)schema).getRootSchema().isColumnId() : false;
        ArrayList uniqueKeys = Lists.newArrayList();
        List primaryKeyList = element.getPrimaryKeyList();
        if (ObjectUtils.isNotEmpty((Object)primaryKeyList)) {
            block0: for (GraphProperty property : primaryKeyList) {
                for (int i = 0; i < schemaType.getFieldList().size(); ++i) {
                    RelDataTypeField field = (RelDataTypeField)schemaType.getFieldList().get(i);
                    if (!field.getName().equals(property.getName())) continue;
                    uniqueKeys.add(ImmutableBitSet.of((int[])new int[]{isColumnId ? field.getIndex() : i}));
                    continue block0;
                }
            }
        }
        return uniqueKeys;
    }

    private RelDataType deriveType(GraphProperty property) {
        RelDataTypeFactory typeFactory = this.schema.getTypeFactory();
        Objects.requireNonNull(typeFactory, "typeFactory");
        switch (property.getDataType()) {
            case BOOL: {
                return typeFactory.createSqlType(SqlTypeName.BOOLEAN);
            }
            case CHAR: 
            case STRING: {
                return typeFactory.createSqlType(SqlTypeName.CHAR);
            }
            case SHORT: 
            case INT: {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case LONG: {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case FLOAT: {
                return typeFactory.createSqlType(SqlTypeName.FLOAT);
            }
            case DOUBLE: {
                return typeFactory.createSqlType(SqlTypeName.DOUBLE);
            }
            case DATE: {
                return typeFactory.createSqlType(SqlTypeName.DATE);
            }
            case TIME32: {
                return typeFactory.createSqlType(SqlTypeName.TIME);
            }
            case TIMESTAMP: {
                return typeFactory.createSqlType(SqlTypeName.TIMESTAMP);
            }
        }
        throw new UnsupportedOperationException("type " + property.getDataType().name() + " not supported");
    }

    public List<String> getQualifiedName() {
        return this.tableName;
    }

    public RelDataType getRowType() {
        return this.dataType;
    }

    public @Nullable RelOptSchema getRelOptSchema() {
        return this.schema;
    }

    public <C> @Nullable C unwrap(Class<C> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        return null;
    }

    public boolean isKey(ImmutableBitSet properties) {
        return this.uniqueKeys.contains(properties);
    }

    public @Nullable List<ImmutableBitSet> getKeys() {
        return this.uniqueKeys;
    }

    public double getRowCount() {
        throw new UnsupportedOperationException("row count is unsupported yet in statistics");
    }

    public @Nullable RelDistribution getDistribution() {
        throw new UnsupportedOperationException("distribution is unsupported yet in statistics");
    }

    public @Nullable List<RelCollation> getCollationList() {
        throw new UnsupportedOperationException("collations is unsupported yet in statistics");
    }

    public RelNode toRel(RelOptTable.ToRelContext toRelContext) {
        throw new UnsupportedOperationException("toRel is unsupported for it will never be used");
    }

    public @Nullable List<RelReferentialConstraint> getReferentialConstraints() {
        throw new UnsupportedOperationException("referentialConstraints is unsupported for it will never be used");
    }

    public @Nullable Expression getExpression(Class aClass) {
        throw new UnsupportedOperationException("expression is unsupported for it will never be used");
    }

    public RelOptTable extend(List<RelDataTypeField> list) {
        throw new UnsupportedOperationException("extend is unsupported for it will never be used");
    }

    public List<ColumnStrategy> getColumnStrategies() {
        throw new UnsupportedOperationException("columnStrategies is unsupported for it will never be used");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphOptTable that = (GraphOptTable)o;
        return Objects.equals(this.tableName, that.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.tableName);
    }
}

