/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema;

import com.alibaba.graphscope.common.ir.meta.schema.Utils;
import com.alibaba.graphscope.groot.common.schema.api.GraphStatistics;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class IrGraphStatistics
implements GraphStatistics {
    private final String statsJson;
    private final GraphStatistics graphStatistics;

    public IrGraphStatistics(InputStream statisticsStream) throws IOException {
        String content = new String(statisticsStream.readAllBytes(), StandardCharsets.UTF_8);
        statisticsStream.close();
        this.statsJson = content;
        this.graphStatistics = Utils.buildStatisticsFromJson(content);
    }

    public IrGraphStatistics(GraphStatistics statistics) {
        this.graphStatistics = statistics;
        this.statsJson = null;
    }

    public Long getVertexCount() {
        return this.graphStatistics.getVertexCount();
    }

    public Long getEdgeCount() {
        return this.graphStatistics.getEdgeCount();
    }

    public Long getVertexTypeCount(Integer vertexTypeId) {
        return this.graphStatistics.getVertexTypeCount(vertexTypeId);
    }

    public Long getEdgeTypeCount(Optional<Integer> sourceTypeId, Optional<Integer> edgeTypeId, Optional<Integer> targetTypeId) {
        return this.graphStatistics.getEdgeTypeCount(sourceTypeId, edgeTypeId, targetTypeId);
    }

    public String getVersion() {
        return this.graphStatistics.getVersion();
    }

    public String getStatsJson() throws Exception {
        Preconditions.checkArgument((this.statsJson != null ? 1 : 0) != 0, (Object)"conversion from 'GraphStatistics' to json is unsupported yet");
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.INDENT_OUTPUT, false);
        return mapper.writeValueAsString((Object)mapper.readTree(this.statsJson));
    }
}

