/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.meta.schema;

import com.alibaba.graphscope.common.ir.meta.schema.Utils;
import com.alibaba.graphscope.groot.common.schema.api.GraphSchema;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class SchemaSpec {
    private final Type type;
    private final String content;

    public SchemaSpec(Type type, String content) {
        this.type = type;
        this.content = content;
    }

    public GraphSchema convert() throws JacksonException {
        switch (this.type) {
            case IR_CORE_IN_JSON: {
                return Utils.buildSchemaFromJson(this.content);
            }
            case FLEX_IN_YAML: {
                return Utils.buildSchemaFromYaml(this.content);
            }
        }
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(this.content);
        Map rootMap = (Map)mapper.convertValue((Object)rootNode, Map.class);
        Yaml yaml = new Yaml();
        return Utils.buildSchemaFromYaml(yaml.dump((Object)rootMap));
    }

    public String getContent() {
        return this.content;
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        IR_CORE_IN_JSON,
        FLEX_IN_JSON,
        FLEX_IN_YAML;

    }
}

