/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.PlannerConfig;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.IrMetaStats;
import com.alibaba.graphscope.common.ir.meta.IrMetaTracker;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.Glogue;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueQuery;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.GlogueSchema;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GlogueHolder
implements IrMetaTracker {
    private final PlannerConfig config;
    private final AtomicReference<GlogueQuery> glogueRef;

    public GlogueHolder(Configs configs) {
        this.config = new PlannerConfig(configs);
        this.glogueRef = new AtomicReference();
    }

    @Override
    public void onChanged(IrMeta meta) {
        if (meta instanceof IrMetaStats) {
            GlogueSchema g = GlogueSchema.fromMeta((IrMetaStats)meta);
            Glogue gl = new Glogue(g, this.config.getGlogueSize());
            GlogueQuery gq = new GlogueQuery(gl);
            this.glogueRef.compareAndSet(this.glogueRef.get(), gq);
        }
    }

    public @Nullable GlogueQuery getGlogue() {
        return this.glogueRef.get();
    }
}

