/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.PlannerConfig;
import com.alibaba.graphscope.common.ir.meta.IrMeta;
import com.alibaba.graphscope.common.ir.meta.glogue.calcite.GraphRelMetadataQuery;
import com.alibaba.graphscope.common.ir.meta.glogue.calcite.handler.GraphMetadataHandlerProvider;
import com.alibaba.graphscope.common.ir.planner.GlogueHolder;
import com.alibaba.graphscope.common.ir.planner.GraphIOProcessor;
import com.alibaba.graphscope.common.ir.planner.PlannerGroup;
import com.alibaba.graphscope.common.ir.planner.PlannerGroupManager;
import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.graph.match.AbstractLogicalMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueQuery;
import com.alibaba.graphscope.common.ir.tools.GraphBuilderFactory;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.tools.RelBuilderFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphRelOptimizer {
    private final PlannerConfig config;
    private final RelBuilderFactory relBuilderFactory;
    private final GlogueHolder glogueHolder;
    private final PlannerGroupManager plannerGroupManager;

    public GraphRelOptimizer(Configs graphConfig, Class<? extends PlannerGroupManager> instance) {
        try {
            this.config = new PlannerConfig(graphConfig);
            this.relBuilderFactory = new GraphBuilderFactory(graphConfig);
            this.glogueHolder = new GlogueHolder(graphConfig);
            this.plannerGroupManager = instance.getDeclaredConstructor(PlannerConfig.class, RelBuilderFactory.class).newInstance(this.config, this.relBuilderFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public GraphRelOptimizer(Configs graphConfig) {
        this(graphConfig, PlannerGroupManager.Dynamic.class);
    }

    public GlogueHolder getGlogueHolder() {
        return this.glogueHolder;
    }

    public RelOptPlanner getMatchPlanner() {
        PlannerGroup currentGroup = this.plannerGroupManager.getCurrentGroup();
        return currentGroup.getMatchPlanner();
    }

    public RelNode optimize(RelNode before, GraphIOProcessor ioProcessor) {
        PlannerGroup currentGroup = this.plannerGroupManager.getCurrentGroup();
        return currentGroup.optimize(before, ioProcessor);
    }

    public @Nullable RelMetadataQuery createMetaDataQuery(IrMeta irMeta) {
        if (this.config.isOn() && this.config.getOpt() == PlannerConfig.Opt.CBO) {
            GlogueQuery gq = this.glogueHolder.getGlogue();
            Preconditions.checkArgument((gq != null ? 1 : 0) != 0, (Object)"glogue is not ready");
            return new GraphRelMetadataQuery(new GraphMetadataHandlerProvider(this.getMatchPlanner(), gq, this.config));
        }
        return null;
    }

    public static class MatchOptimizer
    extends GraphShuttle {
        private final GraphIOProcessor ioProcessor;
        private final RelOptPlanner matchPlanner;

        public MatchOptimizer(GraphIOProcessor ioProcessor, RelOptPlanner matchPlanner) {
            this.ioProcessor = ioProcessor;
            this.matchPlanner = matchPlanner;
        }

        @Override
        public RelNode visit(GraphLogicalSingleMatch match) {
            this.matchPlanner.setRoot(this.ioProcessor.processInput((RelNode)match));
            return this.ioProcessor.processOutput(this.matchPlanner.findBestExp());
        }

        @Override
        public RelNode visit(GraphLogicalMultiMatch match) {
            this.matchPlanner.setRoot(this.ioProcessor.processInput((RelNode)match));
            return this.ioProcessor.processOutput(this.matchPlanner.findBestExp());
        }

        @Override
        public RelNode visit(LogicalJoin join) {
            ArrayList filterList;
            ArrayList matchList = Lists.newArrayList();
            if (!this.decomposeJoin(join, matchList, filterList = Lists.newArrayList())) {
                return super.visit(join);
            }
            this.matchPlanner.setRoot(this.ioProcessor.processInput(matchList));
            RelNode match = this.ioProcessor.processOutput(this.matchPlanner.findBestExp());
            for (RelNode filter : filterList) {
                match = filter.copy(filter.getTraitSet(), (List)ImmutableList.of((Object)match));
            }
            return match;
        }

        private boolean decomposeJoin(LogicalJoin join, final List<RelNode> matchList, final List<RelNode> filterList) {
            final AtomicBoolean decomposable = new AtomicBoolean(true);
            RelVisitor visitor = new RelVisitor(){

                public void visit(RelNode node, int ordinal, @Nullable RelNode parent) {
                    if (node instanceof LogicalJoin) {
                        JoinRelType joinType = ((LogicalJoin)node).getJoinType();
                        if (joinType != JoinRelType.LEFT && joinType != JoinRelType.INNER) {
                            decomposable.set(false);
                            return;
                        }
                        this.visit(((LogicalJoin)node).getLeft(), 0, node);
                        if (!decomposable.get()) {
                            return;
                        }
                        int leftMatchSize = matchList.size();
                        this.visit(((LogicalJoin)node).getRight(), 1, node);
                        if (!decomposable.get()) {
                            return;
                        }
                        if (joinType == JoinRelType.LEFT) {
                            for (int i = leftMatchSize; i < matchList.size(); ++i) {
                                if (!(matchList.get(i) instanceof GraphLogicalSingleMatch)) continue;
                                GraphLogicalSingleMatch singleMatch = (GraphLogicalSingleMatch)((Object)matchList.get(i));
                                matchList.set(i, GraphLogicalSingleMatch.create((GraphOptCluster)singleMatch.getCluster(), (List<RelHint>)ImmutableList.of(), singleMatch.getInput(), singleMatch.getSentence(), GraphOpt.Match.OPTIONAL));
                            }
                        }
                    } else if (node instanceof AbstractLogicalMatch) {
                        matchList.add(node);
                    } else if (node instanceof GraphLogicalSource) {
                        matchList.add(GraphLogicalSingleMatch.create((GraphOptCluster)node.getCluster(), (List<RelHint>)ImmutableList.of(), null, node, GraphOpt.Match.INNER));
                    } else if (node instanceof Filter) {
                        filterList.add(node);
                        this.visit(node.getInput(0), 0, node);
                    } else {
                        decomposable.set(false);
                    }
                }
            };
            visitor.go((RelNode)join);
            return decomposable.get();
        }
    }
}

