/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner;

import com.alibaba.graphscope.common.config.PlannerConfig;
import com.alibaba.graphscope.common.ir.planner.PlannerGroup;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.tools.RelBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlannerGroupManager {
    protected final PlannerConfig config;
    protected final RelBuilderFactory relBuilderFactory;

    public PlannerGroupManager(PlannerConfig config, RelBuilderFactory relBuilderFactory) {
        this.config = config;
        this.relBuilderFactory = relBuilderFactory;
    }

    public abstract PlannerGroup getCurrentGroup();

    public static class Dynamic
    extends PlannerGroupManager {
        private final Logger logger = LoggerFactory.getLogger(PlannerGroupManager.class);
        private final List<PlannerGroup> plannerGroups;
        private final ScheduledExecutorService clearScheduler;

        public Dynamic(PlannerConfig config, RelBuilderFactory relBuilderFactory) {
            super(config, relBuilderFactory);
            Preconditions.checkArgument((config.getPlannerGroupSize() > 0 ? 1 : 0) != 0, (Object)"planner group size should be greater than 0");
            this.plannerGroups = new ArrayList<PlannerGroup>(config.getPlannerGroupSize());
            for (int i = 0; i < config.getPlannerGroupSize(); ++i) {
                this.plannerGroups.add(new PlannerGroup(config, relBuilderFactory));
            }
            this.clearScheduler = new ScheduledThreadPoolExecutor(1);
            int clearInterval = config.getPlannerGroupClearIntervalMinutes();
            this.clearScheduler.scheduleAtFixedRate(() -> {
                try {
                    long freeMemBytes = Runtime.getRuntime().freeMemory();
                    long totalMemBytes = Runtime.getRuntime().totalMemory();
                    Preconditions.checkArgument((totalMemBytes > 0L ? 1 : 0) != 0, (Object)"total memory should be greater than 0");
                    if ((double)freeMemBytes / (double)totalMemBytes < 0.2) {
                        this.logger.warn("start to clear planner groups. There are no enough memory in JVM, with free memory: {}, total memory: {}", (Object)freeMemBytes, (Object)totalMemBytes);
                        this.plannerGroups.forEach(PlannerGroup::clear);
                    }
                }
                catch (Throwable t) {
                    this.logger.error("failed to clear planner group.", t);
                }
            }, clearInterval, clearInterval, TimeUnit.MINUTES);
        }

        @Override
        public PlannerGroup getCurrentGroup() {
            Preconditions.checkArgument((!this.plannerGroups.isEmpty() ? 1 : 0) != 0, (Object)"planner groups should not be empty");
            int groupId = (int)Thread.currentThread().getId() % this.plannerGroups.size();
            return this.plannerGroups.get(groupId);
        }
    }

    public static class Static
    extends PlannerGroupManager {
        private final PlannerGroup singleGroup;

        public Static(PlannerConfig config, RelBuilderFactory relBuilderFactory) {
            super(config, relBuilderFactory);
            this.singleGroup = new PlannerGroup(config, relBuilderFactory);
        }

        @Override
        public PlannerGroup getCurrentGroup() {
            return this.singleGroup;
        }
    }
}

