/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner.rules;

import com.alibaba.graphscope.common.ir.rel.GraphLogicalAggregate;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalExpand;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphGroupKeys;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class DegreeFusionRule<C extends RelRule.Config>
extends RelRule<C>
implements TransformationRule {
    protected DegreeFusionRule(C config) {
        super(config);
    }

    protected RelNode transform(GraphLogicalAggregate count, GraphLogicalExpand expand, GraphBuilder builder) {
        GraphPhysicalExpand expandDegree = GraphPhysicalExpand.create((GraphOptCluster)expand.getCluster(), (List<RelHint>)ImmutableList.of(), expand.getInput(0), expand, null, GraphOpt.PhysicalExpandOpt.DEGREE, null);
        builder.push((RelNode)expandDegree);
        Preconditions.checkArgument((!count.getAggCalls().isEmpty() ? 1 : 0) != 0, (Object)"there should be at least one aggregate call in count");
        String countAlias = count.getAggCalls().get(0).getAlias();
        return builder.aggregate(builder.groupKey(), new RelBuilder.AggCall[]{builder.sum0(false, countAlias, (RexNode)builder.variable(null))}).build();
    }

    public static class ExpandGetVDegreeFusionRule
    extends DegreeFusionRule<Config> {
        protected ExpandGetVDegreeFusionRule(Config config) {
            super(config);
        }

        public void onMatch(RelOptRuleCall call) {
            GraphLogicalAggregate count = (GraphLogicalAggregate)call.rel(0);
            GraphLogicalExpand expand = (GraphLogicalExpand)call.rel(2);
            GraphBuilder builder = (GraphBuilder)call.builder();
            call.transformTo(this.transform(count, expand, builder));
        }

        public static class Config
        implements RelRule.Config {
            public static Config DEFAULT = new Config().withOperandSupplier(b0 -> b0.operand(GraphLogicalAggregate.class).predicate(aggregate -> {
                GraphGroupKeys key = aggregate.getGroupKey();
                List<GraphAggCall> calls = aggregate.getAggCalls();
                return key.groupKeyCount() == 0 && calls.size() == 1 && calls.get(0).getAggFunction().getKind() == SqlKind.COUNT && !calls.get(0).isDistinct();
            }).oneInput(b1 -> b1.operand(GraphLogicalGetV.class).predicate(getV -> getV.getOpt() != GraphOpt.GetV.BOTH && ObjectUtils.isEmpty(getV.getFilters())).oneInput(b2 -> b2.operand(GraphLogicalExpand.class).anyInputs())));
            private RelRule.OperandTransform operandSupplier;
            private @Nullable String description;
            private RelBuilderFactory builderFactory;

            public Config withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.builderFactory = relBuilderFactory;
                return this;
            }

            public Config withDescription(@Nullable String s) {
                this.description = s;
                return this;
            }

            public Config withOperandSupplier(RelRule.OperandTransform operandTransform) {
                this.operandSupplier = operandTransform;
                return this;
            }

            public RelRule.OperandTransform operandSupplier() {
                return this.operandSupplier;
            }

            public @Nullable String description() {
                return this.description;
            }

            public ExpandGetVDegreeFusionRule toRule() {
                return new ExpandGetVDegreeFusionRule(this);
            }

            public RelBuilderFactory relBuilderFactory() {
                return this.builderFactory;
            }
        }
    }

    public static class ExpandDegreeFusionRule
    extends DegreeFusionRule<Config> {
        protected ExpandDegreeFusionRule(Config config) {
            super(config);
        }

        public void onMatch(RelOptRuleCall call) {
            GraphLogicalAggregate count = (GraphLogicalAggregate)call.rel(0);
            GraphLogicalExpand expand = (GraphLogicalExpand)call.rel(1);
            GraphBuilder builder = (GraphBuilder)call.builder();
            call.transformTo(this.transform(count, expand, builder));
        }

        public static class Config
        implements RelRule.Config {
            public static Config DEFAULT = new Config().withOperandSupplier(b0 -> b0.operand(GraphLogicalAggregate.class).predicate(aggregate -> {
                GraphGroupKeys key = aggregate.getGroupKey();
                List<GraphAggCall> calls = aggregate.getAggCalls();
                return key.groupKeyCount() == 0 && calls.size() == 1 && calls.get(0).getAggFunction().getKind() == SqlKind.COUNT && !calls.get(0).isDistinct();
            }).oneInput(b1 -> b1.operand(GraphLogicalExpand.class).anyInputs()));
            private RelRule.OperandTransform operandSupplier;
            private @Nullable String description;
            private RelBuilderFactory builderFactory;

            public Config withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.builderFactory = relBuilderFactory;
                return this;
            }

            public Config withDescription(@Nullable String s) {
                this.description = s;
                return this;
            }

            public Config withOperandSupplier(RelRule.OperandTransform operandTransform) {
                this.operandSupplier = operandTransform;
                return this;
            }

            public RelRule.OperandTransform operandSupplier() {
                return this.operandSupplier;
            }

            public @Nullable String description() {
                return this.description;
            }

            public ExpandDegreeFusionRule toRule() {
                return new ExpandDegreeFusionRule(this);
            }

            public RelBuilderFactory relBuilderFactory() {
                return this.builderFactory;
            }
        }
    }
}

