/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner.rules;

import com.alibaba.graphscope.common.ir.meta.schema.GraphOptTable;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalGetV;
import com.alibaba.graphscope.common.ir.tools.Utils;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ExpandGetVFusionRule<C extends RelRule.Config>
extends RelRule<C>
implements TransformationRule {
    protected ExpandGetVFusionRule(C config) {
        super(config);
    }

    protected RelNode transform(GraphLogicalGetV getV, GraphLogicalExpand expand, RelNode input) {
        if (expand.getOpt().equals((Object)GraphOpt.Expand.OUT) && getV.getOpt().equals((Object)GraphOpt.GetV.END) || expand.getOpt().equals((Object)GraphOpt.Expand.IN) && getV.getOpt().equals((Object)GraphOpt.GetV.START) || expand.getOpt().equals((Object)GraphOpt.Expand.BOTH) && getV.getOpt().equals((Object)GraphOpt.GetV.OTHER)) {
            if (this.canFuse(getV, expand)) {
                GraphPhysicalExpand physicalExpand = GraphPhysicalExpand.create(expand.getCluster(), (List<RelHint>)expand.getHints(), input, expand, getV, GraphOpt.PhysicalExpandOpt.VERTEX, getV.getAliasName());
                return physicalExpand;
            }
            GraphPhysicalExpand physicalExpand = GraphPhysicalExpand.create(expand.getCluster(), (List<RelHint>)expand.getHints(), input, expand, getV, GraphOpt.PhysicalExpandOpt.VERTEX, "_");
            GraphPhysicalGetV physicalGetV = GraphPhysicalGetV.create(getV.getCluster(), (List<RelHint>)getV.getHints(), (RelNode)physicalExpand, getV, getV.getAliasName(), GraphOpt.PhysicalGetVOpt.ITSELF);
            return physicalGetV;
        }
        return getV;
    }

    private boolean canFuse(GraphLogicalGetV getV, GraphLogicalExpand expand) {
        HashSet<Integer> edgeExpandedVLabels = new HashSet<Integer>();
        List<RelOptTable> optTables = expand.getTableConfig().getTables();
        GraphLabelType edgeParamType = Utils.getGraphLabels(expand.getRowType());
        List<GraphLabelType.Entry> edgeParamLabels = edgeParamType.getLabelsEntry();
        GraphOpt.Expand direction = expand.getOpt();
        HashSet<Integer> edgeExpandedSrcVLabels = new HashSet<Integer>();
        for (GraphLabelType.Entry edgeLabel : edgeParamLabels) {
            switch (direction) {
                case OUT: {
                    edgeExpandedSrcVLabels.add(edgeLabel.getSrcLabelId());
                    break;
                }
                case IN: {
                    edgeExpandedSrcVLabels.add(edgeLabel.getDstLabelId());
                    break;
                }
                case BOTH: {
                    edgeExpandedSrcVLabels.add(edgeLabel.getDstLabelId());
                    edgeExpandedSrcVLabels.add(edgeLabel.getSrcLabelId());
                }
            }
        }
        for (RelOptTable optTable : optTables) {
            if (!(optTable instanceof GraphOptTable)) continue;
            GraphOptTable graphOptTable = (GraphOptTable)optTable;
            List<GraphLabelType.Entry> edgeUserGivenParamLabels = Utils.getGraphLabels(graphOptTable.getRowType()).getLabelsEntry();
            for (GraphLabelType.Entry edgeLabel : edgeUserGivenParamLabels) {
                switch (direction) {
                    case OUT: {
                        if (!edgeExpandedSrcVLabels.contains(edgeLabel.getSrcLabelId())) break;
                        edgeExpandedVLabels.add(edgeLabel.getDstLabelId());
                        break;
                    }
                    case IN: {
                        if (!edgeExpandedSrcVLabels.contains(edgeLabel.getDstLabelId())) break;
                        edgeExpandedVLabels.add(edgeLabel.getSrcLabelId());
                        break;
                    }
                    case BOTH: {
                        if (edgeExpandedSrcVLabels.contains(edgeLabel.getSrcLabelId())) {
                            edgeExpandedVLabels.add(edgeLabel.getDstLabelId());
                        }
                        if (!edgeExpandedSrcVLabels.contains(edgeLabel.getDstLabelId())) break;
                        edgeExpandedVLabels.add(edgeLabel.getSrcLabelId());
                    }
                }
            }
        }
        List<GraphLabelType.Entry> vertexParamLabels = Utils.getGraphLabels(getV.getRowType()).getLabelsEntry();
        HashSet<Integer> vertexExpandedVLabels = new HashSet<Integer>();
        for (GraphLabelType.Entry vertexLabel : vertexParamLabels) {
            vertexExpandedVLabels.add(vertexLabel.getLabelId());
        }
        return ObjectUtils.isEmpty(getV.getFilters()) && vertexExpandedVLabels.containsAll(edgeExpandedVLabels);
    }

    public static class PathBaseExpandGetVFusionRule
    extends ExpandGetVFusionRule<Config> {
        protected PathBaseExpandGetVFusionRule(Config config) {
            super(config);
        }

        public void onMatch(RelOptRuleCall call) {
            GraphLogicalPathExpand pathExpand = (GraphLogicalPathExpand)call.rel(0);
            GraphLogicalGetV getV = (GraphLogicalGetV)pathExpand.getGetV();
            GraphLogicalExpand expand = (GraphLogicalExpand)pathExpand.getExpand();
            RelNode fused = this.transform(getV, expand, null);
            GraphLogicalPathExpand afterPathExpand = GraphLogicalPathExpand.create((GraphOptCluster)pathExpand.getCluster(), (List<RelHint>)ImmutableList.of(), pathExpand.getInput(0), fused, pathExpand.getOffset(), pathExpand.getFetch(), pathExpand.getResultOpt(), pathExpand.getPathOpt(), pathExpand.getUntilCondition(), pathExpand.getAliasName(), pathExpand.getStartAlias(), pathExpand.isOptional());
            if (pathExpand.getCachedCost() != null) {
                afterPathExpand.setCachedCost(pathExpand.getCachedCost());
            }
            call.transformTo((RelNode)afterPathExpand);
        }

        public static class Config
        implements RelRule.Config {
            public static Config DEFAULT = new Config().withOperandSupplier(b0 -> b0.operand(GraphLogicalPathExpand.class).predicate(pathExpand -> {
                if (GraphOpt.PathExpandResult.ALL_V_E.equals((Object)pathExpand.getResultOpt())) {
                    return false;
                }
                if (pathExpand.getExpand() instanceof GraphLogicalExpand) {
                    GraphLogicalExpand expand = (GraphLogicalExpand)pathExpand.getExpand();
                    int alias = expand.getAliasId();
                    return alias == -1;
                }
                return false;
            }).anyInputs());
            private RelRule.OperandTransform operandSupplier;
            private @Nullable String description;
            private RelBuilderFactory builderFactory;

            public RelRule toRule() {
                return new PathBaseExpandGetVFusionRule(this);
            }

            public Config withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.builderFactory = relBuilderFactory;
                return this;
            }

            public Config withDescription(@Nullable String s) {
                this.description = s;
                return this;
            }

            public Config withOperandSupplier(RelRule.OperandTransform operandTransform) {
                this.operandSupplier = operandTransform;
                return this;
            }

            public RelRule.OperandTransform operandSupplier() {
                return this.operandSupplier;
            }

            public @Nullable String description() {
                return this.description;
            }

            public RelBuilderFactory relBuilderFactory() {
                return this.builderFactory;
            }
        }
    }

    public static class BasicExpandGetVFusionRule
    extends ExpandGetVFusionRule<Config> {
        protected BasicExpandGetVFusionRule(Config config) {
            super(config);
        }

        public void onMatch(RelOptRuleCall call) {
            GraphLogicalGetV getV = (GraphLogicalGetV)call.rel(0);
            GraphLogicalExpand expand = (GraphLogicalExpand)call.rel(1);
            call.transformTo(this.transform(getV, expand, expand.getInput(0)));
        }

        public static class Config
        implements RelRule.Config {
            public static Config DEFAULT = new Config().withOperandSupplier(b0 -> b0.operand(GraphLogicalGetV.class).oneInput(b1 -> b1.operand(GraphLogicalExpand.class).predicate(expand -> {
                int alias = expand.getAliasId();
                return alias == -1;
            }).anyInputs()));
            private RelRule.OperandTransform operandSupplier;
            private @Nullable String description;
            private RelBuilderFactory builderFactory;

            public RelRule toRule() {
                return new BasicExpandGetVFusionRule(this);
            }

            public Config withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.builderFactory = relBuilderFactory;
                return this;
            }

            public Config withDescription(@Nullable String s) {
                this.description = s;
                return this;
            }

            public Config withOperandSupplier(RelRule.OperandTransform operandTransform) {
                this.operandSupplier = operandTransform;
                return this;
            }

            public RelRule.OperandTransform operandSupplier() {
                return this.operandSupplier;
            }

            public @Nullable String description() {
                return this.description;
            }

            public RelBuilderFactory relBuilderFactory() {
                return this.builderFactory;
            }
        }
    }
}

