/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.planner.rules;

import com.alibaba.graphscope.common.ir.meta.glogue.Utils;
import com.alibaba.graphscope.common.ir.meta.schema.foreign.ForeignKey;
import com.alibaba.graphscope.common.ir.meta.schema.foreign.ForeignKeyEntry;
import com.alibaba.graphscope.common.ir.meta.schema.foreign.ForeignKeyMeta;
import com.alibaba.graphscope.common.ir.rel.GraphJoinDecomposition;
import com.alibaba.graphscope.common.ir.rel.GraphPattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.ElementDetails;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.FuzzyPatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.FuzzyPatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PathExpandRange;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.EdgeTypeId;
import com.alibaba.graphscope.common.ir.rel.type.JoinVertexEntry;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JoinDecompositionRule<C extends Config>
extends RelRule<C> {
    private static Comparator<GraphJoinDecomposition> comparator = (d1, d2) -> {
        double cost1 = ((GraphPattern)d1.getLeft()).getRowCount() + ((GraphPattern)d1.getRight()).getRowCount();
        double cost2 = ((GraphPattern)d2.getLeft()).getRowCount() + ((GraphPattern)d2.getRight()).getRowCount();
        return Double.compare(cost1, cost2);
    };

    protected JoinDecompositionRule(C config) {
        super(config);
    }

    public void onMatch(RelOptRuleCall relOptRuleCall) {
        GraphPattern graphPattern = (GraphPattern)relOptRuleCall.rel(0);
        RelMetadataQuery mq = relOptRuleCall.getMetadataQuery();
        if (this.getMaxVertexNum(graphPattern.getPattern()) < ((Config)this.config).getMinPatternSize()) {
            return;
        }
        graphPattern.setRowCount(mq.getRowCount((RelNode)graphPattern));
        int queueCapacity = ((Config)this.config).getJoinQueueCapacity();
        PriorityQueue<GraphJoinDecomposition> decompositionQueue = new PriorityQueue<GraphJoinDecomposition>(queueCapacity, comparator.reversed());
        if (this.getMaxEdgeNum(graphPattern.getPattern()) > 2) {
            new JoinByVertex(graphPattern, mq, decompositionQueue, queueCapacity).addDecompositions();
        }
        if (((Config)this.config).getForeignKeyMeta() != null) {
            new JoinByForeignKey(graphPattern, mq, decompositionQueue, queueCapacity).addDecompositions();
        }
        if (((Config)this.config).isJoinByEdgeEnabled()) {
            new JoinByEdge(graphPattern, mq, decompositionQueue, queueCapacity).addDecompositions();
        }
        ArrayList decompositionsInAscOrder = Lists.newArrayList();
        while (!decompositionQueue.isEmpty()) {
            GraphJoinDecomposition decomposition = decompositionQueue.poll();
            decompositionsInAscOrder.add(0, decomposition);
        }
        for (GraphJoinDecomposition decomposition : decompositionsInAscOrder) {
            relOptRuleCall.transformTo((RelNode)decomposition);
        }
    }

    private GraphJoinDecomposition createJoinDecomposition(GraphPattern graphPattern, Pattern probePattern, double probeCount, Pattern buildPattern, double buildCount, List<JoinVertex> jointVertices) {
        if (probeCount > buildCount) {
            return this.createJoinDecomposition(graphPattern, buildPattern, buildCount, probePattern, probeCount, jointVertices.stream().map(JoinVertex::reverse).collect(Collectors.toList()));
        }
        Pattern pattern = graphPattern.getPattern();
        List<GraphJoinDecomposition.JoinVertexPair> jointVertexPairs = jointVertices.stream().map(k -> k.convert(probePattern, buildPattern)).collect(Collectors.toList());
        HashMap leftToTargetOrderMap = Maps.newHashMap();
        for (PatternVertex patternVertex : probePattern.getVertexSet()) {
            leftToTargetOrderMap.put(probePattern.getVertexOrder(patternVertex), pattern.getVertexOrder(patternVertex));
        }
        HashMap rightToTargetOrderMap = Maps.newHashMap();
        for (PatternVertex v2 : buildPattern.getVertexSet()) {
            rightToTargetOrderMap.put(buildPattern.getVertexOrder(v2), pattern.getVertexOrder(v2));
        }
        GraphJoinDecomposition graphJoinDecomposition = new GraphJoinDecomposition(graphPattern.getCluster(), graphPattern.getTraitSet(), pattern, probePattern, buildPattern, jointVertexPairs, new GraphJoinDecomposition.OrderMappings(leftToTargetOrderMap, rightToTargetOrderMap));
        ((GraphPattern)graphJoinDecomposition.getLeft()).setRowCount(probeCount);
        ((GraphPattern)graphJoinDecomposition.getRight()).setRowCount(buildCount);
        return graphJoinDecomposition;
    }

    private int getMaxVertexNum(Pattern pattern) {
        int maxVertexNum = pattern.getVertexNumber();
        for (PatternEdge edge : pattern.getEdgeSet()) {
            if (edge.getElementDetails().getRange() == null) continue;
            PathExpandRange range = edge.getElementDetails().getRange();
            int maxHop = range.getOffset() + range.getFetch() - 1;
            maxVertexNum += maxHop - 1;
        }
        return maxVertexNum;
    }

    private int getMaxEdgeNum(Pattern pattern) {
        int maxEdgeNum = pattern.getEdgeNumber();
        for (PatternEdge edge : pattern.getEdgeSet()) {
            if (edge.getElementDetails().getRange() == null) continue;
            PathExpandRange range = edge.getElementDetails().getRange();
            int maxHop = range.getOffset() + range.getFetch() - 1;
            maxEdgeNum += maxHop - 1;
        }
        return maxEdgeNum;
    }

    public static class Config
    implements RelRule.Config {
        public static Config DEFAULT = new Config().withOperandSupplier(b0 -> b0.operand(GraphPattern.class).anyInputs());
        private RelRule.OperandTransform operandSupplier;
        private @Nullable String description;
        private RelBuilderFactory builderFactory;
        private int minPatternSize;
        private boolean joinByEdgeEnabled;
        private @Nullable ForeignKeyMeta foreignKeyMeta;
        private int joinQueueCapacity;

        public RelRule toRule() {
            return new JoinDecompositionRule<Config>(this);
        }

        public Config withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
            this.builderFactory = relBuilderFactory;
            return this;
        }

        public Config withDescription(@Nullable String s) {
            this.description = s;
            return this;
        }

        public Config withOperandSupplier(RelRule.OperandTransform operandTransform) {
            this.operandSupplier = operandTransform;
            return this;
        }

        public Config withMinPatternSize(int minPatternSize) {
            this.minPatternSize = minPatternSize;
            return this;
        }

        public Config withJoinByEdgeEnabled(boolean joinByEdgeEnabled) {
            this.joinByEdgeEnabled = joinByEdgeEnabled;
            return this;
        }

        public Config withForeignKeyMeta(ForeignKeyMeta foreignKeyMeta) {
            this.foreignKeyMeta = foreignKeyMeta;
            return this;
        }

        public Config withJoinQueueCapacity(int joinQueueCapacity) {
            this.joinQueueCapacity = joinQueueCapacity;
            return this;
        }

        public int getMinPatternSize() {
            return this.minPatternSize;
        }

        public boolean isJoinByEdgeEnabled() {
            return this.joinByEdgeEnabled;
        }

        public @Nullable ForeignKeyMeta getForeignKeyMeta() {
            return this.foreignKeyMeta;
        }

        public int getJoinQueueCapacity() {
            return this.joinQueueCapacity;
        }

        public RelRule.OperandTransform operandSupplier() {
            return this.operandSupplier;
        }

        public @Nullable String description() {
            return this.description;
        }

        public RelBuilderFactory relBuilderFactory() {
            return this.builderFactory;
        }
    }

    private static class JoinVertex
    extends Pair<JoinVertexEntry<PatternVertex>, JoinVertexEntry<PatternVertex>> {
        private final boolean isForeignKey;

        public JoinVertex(PatternVertex singleVertex) {
            this(new JoinVertexEntry<PatternVertex>(singleVertex, null), new JoinVertexEntry<PatternVertex>(singleVertex, null), false);
        }

        public JoinVertex(PatternVertex left, @Nullable String leftKeyName, PatternVertex right, @Nullable String rightKeyName, boolean isForeignKey) {
            this(new JoinVertexEntry<PatternVertex>(left, leftKeyName), new JoinVertexEntry<PatternVertex>(right, rightKeyName), isForeignKey);
        }

        public JoinVertex(JoinVertexEntry<PatternVertex> left, JoinVertexEntry<PatternVertex> right, boolean isForeignKey) {
            super(left, right);
            this.isForeignKey = isForeignKey;
        }

        public GraphJoinDecomposition.JoinVertexPair convert(Pattern probePattern, Pattern buildPattern) {
            return new GraphJoinDecomposition.JoinVertexPair(new JoinVertexEntry<Integer>(probePattern.getVertexOrder((PatternVertex)((JoinVertexEntry)this.left).getVertex()), ((JoinVertexEntry)this.left).getKeyName()), new JoinVertexEntry<Integer>(buildPattern.getVertexOrder((PatternVertex)((JoinVertexEntry)this.right).getVertex()), ((JoinVertexEntry)this.right).getKeyName()), this.isForeignKey);
        }

        public JoinVertex reverse() {
            return new JoinVertex((JoinVertexEntry)this.right, (JoinVertexEntry)this.left, this.isForeignKey);
        }
    }

    private class JoinByVertex
    extends JoinByRule {
        public JoinByVertex(GraphPattern graphPattern, RelMetadataQuery mq, PriorityQueue<GraphJoinDecomposition> decompositionQueue, int queueCapacity) {
            super(graphPattern, mq, decompositionQueue, queueCapacity);
        }

        @Override
        public void addDecompositions() {
            List<GraphJoinDecomposition> queues = this.initDecompositions();
            while (!queues.isEmpty()) {
                List<GraphJoinDecomposition> nextCompositions = this.getDecompositions(queues.remove(0));
                queues.addAll(nextCompositions);
            }
            this.addPxdInnerVDecompositions();
        }

        private List<GraphJoinDecomposition> initDecompositions() {
            Pattern pattern = this.graphPattern.getPattern();
            double patternCount = this.graphPattern.getRowCount();
            ArrayList decompositions = Lists.newArrayList();
            for (PatternVertex vertex : pattern.getVertexSet()) {
                Pattern probePattern = new Pattern(vertex);
                probePattern.reordering();
                double probeCount = this.getRowCount((RelNode)this.graphPattern, vertex, this.mq);
                GraphJoinDecomposition decomposition = JoinDecompositionRule.this.createJoinDecomposition(this.graphPattern, probePattern, probeCount, pattern, patternCount, Lists.newArrayList((Object[])new JoinVertex[]{new JoinVertex(vertex)}));
                decompositions.add(decomposition);
            }
            return decompositions;
        }

        private List<GraphJoinDecomposition> getDecompositions(GraphJoinDecomposition parent) {
            Pattern probePattern = parent.getProbePattern();
            Pattern buildPattern = parent.getBuildPattern();
            PatternVertex jointVertex = buildPattern.getVertexByOrder(parent.getJoinVertexPairs().get(0).getRightOrderId());
            double probeCount = ((GraphPattern)parent.getLeft()).getRowCount();
            double buildCount = ((GraphPattern)parent.getRight()).getRowCount();
            ArrayList decompositions = Lists.newArrayList();
            Set<PatternEdge> edgeCandidates = buildPattern.getEdgesOf(jointVertex);
            for (PatternEdge edge : edgeCandidates) {
                PatternVertex disjointVertex = Utils.getExtendFromVertex(edge, jointVertex);
                Set<PatternEdge> disjointEdges = buildPattern.getEdgesOf(disjointVertex);
                PatternVertex newJointVertex = null;
                if (edgeCandidates.size() == 1 && disjointEdges.size() > 1) {
                    newJointVertex = disjointVertex;
                } else if (edgeCandidates.size() > 1 && disjointEdges.size() == 1) {
                    newJointVertex = jointVertex;
                }
                if (newJointVertex == null) continue;
                Pattern probeClone = new Pattern(probePattern);
                if (!probeClone.containsVertex(edge.getSrcVertex())) {
                    probeClone.addVertex(edge.getSrcVertex());
                }
                if (!probeClone.containsVertex(edge.getDstVertex())) {
                    probeClone.addVertex(edge.getDstVertex());
                }
                probeClone.addEdge(edge.getSrcVertex(), edge.getDstVertex(), edge);
                probeClone.reordering();
                Pattern buildClone = new Pattern(buildPattern);
                buildClone.removeEdge(edge, true);
                if (!buildClone.isConnected() || probeClone.getVertexNumber() > buildClone.getVertexNumber()) continue;
                double probeCloneCount = probeCount * this.getRowCount((RelNode)parent, edge, this.mq) / this.getRowCount((RelNode)parent, jointVertex, this.mq);
                double buildCloneCount = buildCount / this.getRowCount((RelNode)parent, edge, this.mq) * this.getRowCount((RelNode)parent, newJointVertex, this.mq);
                GraphJoinDecomposition decomposition = JoinDecompositionRule.this.createJoinDecomposition(new GraphPattern(parent.getCluster(), parent.getTraitSet(), parent.getParentPatten()), probeClone, probeCloneCount, buildClone, buildCloneCount, Lists.newArrayList((Object[])new JoinVertex[]{new JoinVertex(newJointVertex)}));
                if (!this.addDecompositionToQueue(decomposition)) continue;
                decompositions.add(decomposition);
            }
            return decompositions;
        }

        private void addPxdInnerVDecompositions() {
            Pattern pattern = this.graphPattern.getPattern();
            for (PatternEdge edge : pattern.getEdgeSet()) {
                if (edge.getElementDetails().getRange() == null) continue;
                int minHop = edge.getElementDetails().getRange().getOffset();
                int maxHop = minHop + edge.getElementDetails().getRange().getFetch() - 1;
                List<Pattern> subgraph = this.splitByEdge(pattern, edge);
                if (subgraph.size() != 2) continue;
                Pattern probePattern = subgraph.get(0);
                Pattern buildPattern = subgraph.get(1);
                if (probePattern.getVertexNumber() > buildPattern.getVertexNumber()) continue;
                PatternVertex src = edge.getSrcVertex();
                PatternVertex dst = edge.getDstVertex();
                if (maxHop < ((Config)JoinDecompositionRule.this.config).getMinPatternSize() - 1) continue;
                for (int i = 0; i <= minHop; ++i) {
                    for (int j = 1; j <= maxHop - 1; ++j) {
                        if (i > j || minHop - i > maxHop - j) continue;
                        PatternVertex splitVertex = this.createSplitVertex(dst);
                        PatternEdge probeSplit = this.createSplitEdge(edge, src, splitVertex, new PathExpandRange(i, j - i + 1));
                        PatternEdge buildSplit = this.createSplitEdge(edge, splitVertex, dst, new PathExpandRange(minHop - i, maxHop - j - (minHop - i) + 1));
                        Pattern probeClone = new Pattern(probePattern);
                        probeClone.addVertex(splitVertex);
                        probeClone.addEdge(src, splitVertex, probeSplit);
                        probeClone.reordering();
                        Pattern buildClone = new Pattern(buildPattern);
                        buildClone.addVertex(splitVertex);
                        buildClone.addEdge(splitVertex, dst, buildSplit);
                        buildClone.reordering();
                        double probeCount = this.mq.getRowCount((RelNode)new GraphPattern(this.graphPattern.getCluster(), this.graphPattern.getTraitSet(), probeClone));
                        double buildCount = this.mq.getRowCount((RelNode)new GraphPattern(this.graphPattern.getCluster(), this.graphPattern.getTraitSet(), buildClone));
                        GraphJoinDecomposition decomposition = JoinDecompositionRule.this.createJoinDecomposition(this.graphPattern, probeClone, probeCount, buildClone, buildCount, Lists.newArrayList((Object[])new JoinVertex[]{new JoinVertex(splitVertex)}));
                        this.addDecompositionToQueue(decomposition);
                    }
                }
            }
        }

        private PatternVertex createSplitVertex(PatternVertex oldVertex) {
            int randomId = UUID.randomUUID().hashCode();
            return oldVertex instanceof SinglePatternVertex ? new SinglePatternVertex(oldVertex.getVertexTypeIds().get(0), randomId, new ElementDetails()) : new FuzzyPatternVertex(oldVertex.getVertexTypeIds(), randomId, new ElementDetails());
        }

        private PatternEdge createSplitEdge(PatternEdge oldEdge, PatternVertex newSrc, PatternVertex newDst, PathExpandRange newRange) {
            int newEdgeId = oldEdge.getId();
            ElementDetails newDetails = new ElementDetails(oldEdge.getElementDetails().getSelectivity(), newRange, oldEdge.getElementDetails().getPxdInnerGetVTypes(), oldEdge.getElementDetails().getResultOpt(), oldEdge.getElementDetails().getPathOpt());
            return oldEdge instanceof SinglePatternEdge ? new SinglePatternEdge(newSrc, newDst, oldEdge.getEdgeTypeIds().get(0), newEdgeId, oldEdge.isBoth(), newDetails) : new FuzzyPatternEdge(newSrc, newDst, oldEdge.getEdgeTypeIds(), newEdgeId, oldEdge.isBoth(), newDetails);
        }
    }

    private class JoinByEdge
    extends JoinByRule {
        public JoinByEdge(GraphPattern graphPattern, RelMetadataQuery mq, PriorityQueue<GraphJoinDecomposition> decompositionQueue, int queueCapacity) {
            super(graphPattern, mq, decompositionQueue, queueCapacity);
        }

        @Override
        public void addDecompositions() {
            Pattern pattern = this.graphPattern.getPattern();
            for (PatternEdge edge : pattern.getEdgeSet()) {
                PatternVertex dstVertex;
                PatternVertex srcVertex = edge.getSrcVertex();
                if (srcVertex == (dstVertex = edge.getDstVertex()) || pattern.getEdgesOf(srcVertex).size() <= 1 || pattern.getEdgesOf(dstVertex).size() <= 1) continue;
                Pattern rightPattern = new Pattern(pattern);
                rightPattern.removeEdge(edge, true);
                if (!rightPattern.isConnected()) continue;
                Pattern leftPattern = new Pattern();
                leftPattern.addVertex(srcVertex);
                leftPattern.addVertex(dstVertex);
                leftPattern.addEdge(srcVertex, dstVertex, edge);
                leftPattern.reordering();
                if (leftPattern.getVertexNumber() > rightPattern.getVertexNumber()) {
                    return;
                }
                double leftCount = this.mq.getRowCount((RelNode)new GraphPattern(this.graphPattern.getCluster(), this.graphPattern.getTraitSet(), leftPattern));
                double rightCount = this.graphPattern.getRowCount() * this.getRowCount((RelNode)this.graphPattern, srcVertex, this.mq) * this.getRowCount((RelNode)this.graphPattern, dstVertex, this.mq) / leftCount;
                GraphJoinDecomposition decomposition = JoinDecompositionRule.this.createJoinDecomposition(this.graphPattern, leftPattern, leftCount, rightPattern, rightCount, Lists.newArrayList((Object[])new JoinVertex[]{new JoinVertex(srcVertex), new JoinVertex(dstVertex)}));
                this.addDecompositionToQueue(decomposition);
            }
        }
    }

    private class JoinByForeignKey
    extends JoinByRule {
        public JoinByForeignKey(GraphPattern graphPattern, RelMetadataQuery mq, PriorityQueue<GraphJoinDecomposition> decompositionQueue, int queueCapacity) {
            super(graphPattern, mq, decompositionQueue, queueCapacity);
        }

        @Override
        public void addDecompositions() {
            Pattern pattern = this.graphPattern.getPattern();
            for (PatternEdge edge : pattern.getEdgeSet()) {
                List<Pattern> subgraph;
                if (!(edge instanceof SinglePatternEdge)) continue;
                EdgeTypeId typeId = edge.getEdgeTypeIds().get(0);
                ForeignKeyEntry entry = ((Config)JoinDecompositionRule.this.config).getForeignKeyMeta().getForeignKeyEntry(typeId);
                if (entry == null || (subgraph = this.splitByEdge(pattern, edge)).size() != 2) continue;
                Pattern srcPattern = subgraph.get(0);
                Pattern dstPattern = subgraph.get(1);
                if (srcPattern.getVertexNumber() > dstPattern.getVertexNumber()) {
                    return;
                }
                double srcCount = this.mq.getRowCount((RelNode)new GraphPattern(this.graphPattern.getCluster(), this.graphPattern.getTraitSet(), srcPattern));
                double dstCount = this.mq.getRowCount((RelNode)new GraphPattern(this.graphPattern.getCluster(), this.graphPattern.getTraitSet(), dstPattern));
                GraphJoinDecomposition decomposition = JoinDecompositionRule.this.createJoinDecomposition(this.graphPattern, srcPattern, srcCount, dstPattern, dstCount, Lists.newArrayList((Object[])new JoinVertex[]{this.getJoinVertex(edge.getSrcVertex(), edge, entry)}));
                this.addDecompositionToQueue(decomposition);
            }
        }

        private JoinVertex getJoinVertex(PatternVertex probeVertex, PatternEdge edge, ForeignKeyEntry entry) {
            PatternVertex buildVertex = Utils.getExtendFromVertex(edge, probeVertex);
            String probeKeyName = null;
            String buildKeyName = null;
            for (ForeignKey key : entry) {
                if (probeVertex.getVertexTypeIds().contains(key.getLabelId())) {
                    probeKeyName = key.getKeyName();
                    continue;
                }
                if (!buildVertex.getVertexTypeIds().contains(key.getLabelId())) continue;
                buildKeyName = key.getKeyName();
            }
            Preconditions.checkArgument((probeKeyName != null && buildKeyName != null ? 1 : 0) != 0, (Object)"probe key name or build key name should not be null");
            return new JoinVertex(probeVertex, probeKeyName, buildVertex, buildKeyName, true);
        }
    }

    private class JoinByRule {
        protected final GraphPattern graphPattern;
        protected final RelMetadataQuery mq;
        protected final PriorityQueue<GraphJoinDecomposition> decompositionQueue;
        protected final int queueCapacity;

        public JoinByRule(GraphPattern graphPattern, RelMetadataQuery mq, PriorityQueue<GraphJoinDecomposition> decompositionQueue, int queueCapacity) {
            this.graphPattern = graphPattern;
            this.mq = mq;
            this.decompositionQueue = decompositionQueue;
            this.queueCapacity = queueCapacity;
        }

        public void addDecompositions() {
        }

        protected boolean addDecompositionToQueue(GraphJoinDecomposition decomposition) {
            if (!this.containsDecomposition(this.decompositionQueue.iterator(), decomposition)) {
                if (this.decompositionQueue.size() < this.queueCapacity) {
                    this.decompositionQueue.offer(decomposition);
                    return true;
                }
                if (comparator.compare(this.decompositionQueue.peek(), decomposition) > 0) {
                    this.decompositionQueue.poll();
                    this.decompositionQueue.offer(decomposition);
                    return true;
                }
            }
            return false;
        }

        protected boolean containsDecomposition(Iterator<GraphJoinDecomposition> decompositions, GraphJoinDecomposition target) {
            Pattern targetProbe = ((GraphPattern)target.getLeft()).getPattern();
            Pattern targetBuild = ((GraphPattern)target.getRight()).getPattern();
            while (decompositions.hasNext()) {
                GraphJoinDecomposition d = decompositions.next();
                Pattern dProbe = ((GraphPattern)d.getLeft()).getPattern();
                Pattern dBuild = ((GraphPattern)d.getRight()).getPattern();
                if ((!dProbe.isIsomorphicTo(targetProbe) || !dBuild.isIsomorphicTo(targetBuild)) && (!dProbe.isIsomorphicTo(targetBuild) || !dBuild.isIsomorphicTo(targetProbe))) continue;
                return true;
            }
            return false;
        }

        protected double getRowCount(RelNode parent, PatternEdge edge, RelMetadataQuery mq) {
            Pattern pattern = new Pattern();
            pattern.addVertex(edge.getSrcVertex());
            pattern.addVertex(edge.getDstVertex());
            pattern.addEdge(edge.getSrcVertex(), edge.getDstVertex(), edge);
            return mq.getRowCount((RelNode)new GraphPattern(parent.getCluster(), parent.getTraitSet(), pattern));
        }

        protected double getRowCount(RelNode parent, PatternVertex vertex, RelMetadataQuery mq) {
            Pattern pattern = new Pattern();
            pattern.addVertex(vertex);
            return mq.getRowCount((RelNode)new GraphPattern(parent.getCluster(), parent.getTraitSet(), pattern));
        }

        protected List<Pattern> splitByEdge(Pattern pattern, PatternEdge edge) {
            Pattern clone = new Pattern(pattern);
            clone.removeEdge(edge, false);
            List<Set<PatternVertex>> connected = clone.getConnectedComponents();
            if (connected.size() != 2) {
                return Lists.newArrayList();
            }
            if (connected.get(0).contains(edge.getSrcVertex())) {
                return Lists.newArrayList((Object[])new Pattern[]{this.createSubgraph(pattern, connected.get(0)), this.createSubgraph(pattern, connected.get(1))});
            }
            return Lists.newArrayList((Object[])new Pattern[]{this.createSubgraph(pattern, connected.get(1)), this.createSubgraph(pattern, connected.get(0))});
        }

        protected Pattern createSubgraph(Pattern pattern, Set<PatternVertex> components) {
            Pattern subgraph = new Pattern();
            for (PatternVertex vertex : components) {
                subgraph.addVertex(vertex);
                for (PatternEdge edge : pattern.getEdgesOf(vertex)) {
                    if (!components.contains(edge.getSrcVertex()) || !components.contains(edge.getDstVertex())) continue;
                    if (!subgraph.containsVertex(edge.getSrcVertex())) {
                        subgraph.addVertex(edge.getSrcVertex());
                    }
                    if (!subgraph.containsVertex(edge.getDstVertex())) {
                        subgraph.addVertex(edge.getDstVertex());
                    }
                    subgraph.addEdge(edge.getSrcVertex(), edge.getDstVertex(), edge);
                }
            }
            subgraph.reordering();
            return subgraph;
        }
    }
}

