/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel;

import com.alibaba.graphscope.common.ir.rel.GraphPattern;
import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.type.JoinVertexEntry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;

public class GraphJoinDecomposition
extends BiRel {
    private final List<JoinVertexPair> joinVertexPairs;
    private final OrderMappings orderMappings;
    private final Pattern parentPatten;
    private final Pattern probePattern;
    private final Pattern buildPattern;
    private final JoinRelType joinType;

    public GraphJoinDecomposition(RelOptCluster cluster, RelTraitSet traitSet, Pattern parentPattern, Pattern probePattern, Pattern buildPattern, List<JoinVertexPair> joinVertexPairs, OrderMappings orderMappings) {
        this(cluster, traitSet, parentPattern, probePattern, buildPattern, joinVertexPairs, orderMappings, JoinRelType.INNER);
    }

    public GraphJoinDecomposition(RelOptCluster cluster, RelTraitSet traitSet, Pattern parentPattern, Pattern probePattern, Pattern buildPattern, List<JoinVertexPair> joinVertexPairs, OrderMappings orderMappings, JoinRelType joinType) {
        this(cluster, traitSet, parentPattern, (RelNode)new GraphPattern(cluster, traitSet, probePattern), probePattern, (RelNode)new GraphPattern(cluster, traitSet, buildPattern), buildPattern, joinVertexPairs, orderMappings, joinType);
    }

    public GraphJoinDecomposition(RelOptCluster cluster, RelTraitSet traitSet, Pattern parentPattern, RelNode left, Pattern leftPattern, RelNode right, Pattern rightPattern, List<JoinVertexPair> joinVertexPairs, OrderMappings orderMappings, JoinRelType joinType) {
        super(cluster, traitSet, left, right);
        this.parentPatten = parentPattern;
        this.joinVertexPairs = joinVertexPairs;
        this.orderMappings = orderMappings;
        this.probePattern = leftPattern;
        this.buildPattern = rightPattern;
        this.joinType = joinType;
    }

    public List<JoinVertexPair> getJoinVertexPairs() {
        return Collections.unmodifiableList(this.joinVertexPairs);
    }

    public OrderMappings getOrderMappings() {
        return this.orderMappings;
    }

    public Pattern getParentPatten() {
        return this.parentPatten;
    }

    public Pattern getProbePattern() {
        return this.probePattern;
    }

    public Pattern getBuildPattern() {
        return this.buildPattern;
    }

    public JoinRelType getJoinType() {
        return this.joinType;
    }

    public RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY);
    }

    public GraphJoinDecomposition copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new GraphJoinDecomposition(this.getCluster(), traitSet, this.parentPatten, inputs.get(0), this.probePattern, inputs.get(1), this.buildPattern, this.joinVertexPairs, this.orderMappings, this.joinType);
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof GraphShuttle) {
            return ((GraphShuttle)shuttle).visit(this);
        }
        return super.accept(shuttle);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("jointVertices", this.joinVertexPairs).item("orderMappings", (Object)this.orderMappings);
    }

    public static class OrderMappings {
        private final Map<Integer, Integer> leftToTargetOrderMap;
        private final Map<Integer, Integer> rightToTargetOrderMap;

        public OrderMappings(Map<Integer, Integer> leftToTargetOrderMap, Map<Integer, Integer> rightToTargetOrderMap) {
            this.leftToTargetOrderMap = leftToTargetOrderMap;
            this.rightToTargetOrderMap = rightToTargetOrderMap;
        }

        public Map<Integer, Integer> getLeftToTargetOrderMap() {
            return Collections.unmodifiableMap(this.leftToTargetOrderMap);
        }

        public Map<Integer, Integer> getRightToTargetOrderMap() {
            return Collections.unmodifiableMap(this.rightToTargetOrderMap);
        }

        public String toString() {
            return "OrderMappings{leftToTargetOrderMap=" + this.leftToTargetOrderMap + ", rightToTargetOrderMap=" + this.rightToTargetOrderMap + "}";
        }
    }

    public static class JoinVertexPair
    extends Pair<JoinVertexEntry<Integer>, JoinVertexEntry<Integer>> {
        private final boolean isForeignKey;

        public JoinVertexPair(JoinVertexEntry<Integer> left, JoinVertexEntry<Integer> right, boolean isForeignKey) {
            super(left, right);
            this.isForeignKey = isForeignKey;
        }

        public int getLeftOrderId() {
            return (Integer)((JoinVertexEntry)this.left).getVertex();
        }

        public int getRightOrderId() {
            return (Integer)((JoinVertexEntry)this.right).getVertex();
        }

        public boolean isForeignKey() {
            return this.isForeignKey;
        }

        public String toString() {
            return "JoinVertexPair{leftOrderId=" + this.getLeftOrderId() + ", rightOrderId=" + this.getRightOrderId() + "}";
        }
    }
}

