/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel;

import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.Utils;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphLogicalUnfold
extends SingleRel {
    private final RexNode key;
    private final String aliasName;
    private final int aliasId;

    public GraphLogicalUnfold(GraphOptCluster cluster, RelNode input, RexNode key, @Nullable String aliasName) {
        super((RelOptCluster)cluster, RelTraitSet.createEmpty(), input);
        this.key = key;
        this.aliasName = AliasInference.inferDefault(aliasName, AliasInference.getUniqueAliasList(input, true));
        this.aliasId = cluster.getIdGenerator().generate(this.aliasName);
    }

    public RexNode getUnfoldKey() {
        return this.key;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("key", (Object)this.key).item("alias", (Object)this.aliasName);
    }

    public RelDataType deriveRowType() {
        RelDataType inputOutputType = Utils.getOutputType(this.input);
        List fields = inputOutputType.getFieldList().stream().filter(k -> k.getIndex() != -1).collect(Collectors.toList());
        fields.add(new RelDataTypeFieldImpl(this.aliasName, this.aliasId, this.key.getType().getComponentType()));
        return new RelRecordType(StructKind.FULLY_QUALIFIED, fields);
    }

    public GraphLogicalUnfold copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new GraphLogicalUnfold((GraphOptCluster)this.getCluster(), inputs.get(0), this.key, this.aliasName);
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof GraphShuttle) {
            return ((GraphShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public int getAliasId() {
        return this.aliasId;
    }
}

