/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.graph;

import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalExpand;
import com.alibaba.graphscope.common.ir.rel.type.AliasNameWithId;
import com.alibaba.graphscope.common.ir.rel.type.TableConfig;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractBindableTableScan
extends TableScan {
    protected @Nullable ImmutableList<RexNode> filters;
    protected @Nullable ImmutableIntList project;
    protected @Nullable RelNode input;
    protected final TableConfig tableConfig;
    protected final String aliasName;
    protected final int aliasId;
    protected final AliasNameWithId startAlias;
    protected @Nullable RelOptCost cachedCost = null;

    protected AbstractBindableTableScan(GraphOptCluster cluster, List<RelHint> hints, @Nullable RelNode input, TableConfig tableConfig, @Nullable String aliasName, AliasNameWithId startAlias) {
        super((RelOptCluster)cluster, RelTraitSet.createEmpty(), hints, tableConfig == null || ObjectUtils.isEmpty(tableConfig.getTables()) ? null : tableConfig.getTables().get(0));
        this.input = input;
        this.tableConfig = Objects.requireNonNull(tableConfig);
        this.aliasName = AliasInference.inferDefault(aliasName, AliasInference.getUniqueAliasList(input, true));
        this.aliasId = cluster.getIdGenerator().generate(this.aliasName);
        this.startAlias = Objects.requireNonNull(startAlias);
    }

    protected AbstractBindableTableScan(GraphOptCluster cluster, List<RelHint> hints, TableConfig tableConfig, String aliasName) {
        this(cluster, hints, null, tableConfig, aliasName, AliasNameWithId.DEFAULT);
    }

    public RelDataType deriveRowType() {
        ArrayList<GraphSchemaType> tableTypes = new ArrayList<GraphSchemaType>();
        List tables = (List)ObjectUtils.requireNonEmpty(this.tableConfig.getTables());
        RelDataTypeFactory typeFactory = ((RelOptTable)tables.get(0)).getRelOptSchema().getTypeFactory();
        for (RelOptTable table : tables) {
            GraphSchemaType type = (GraphSchemaType)table.getRowType();
            tableTypes.addAll(type.getSchemaTypeAsList());
        }
        ObjectUtils.requireNonEmpty(tableTypes);
        boolean nullable = this.schemaTypeNullable();
        GraphSchemaType graphType = tableTypes.size() == 1 ? new GraphSchemaType(((GraphSchemaType)((Object)tableTypes.get(0))).getScanOpt(), ((GraphSchemaType)((Object)tableTypes.get(0))).getLabelType(), ((GraphSchemaType)((Object)tableTypes.get(0))).getFieldList(), nullable) : GraphSchemaType.create(tableTypes, typeFactory, nullable);
        RelRecordType rowType = new RelRecordType((List)ImmutableList.of((Object)new RelDataTypeFieldImpl(this.getAliasName(), this.getAliasId(), (RelDataType)graphType)));
        return rowType;
    }

    private boolean schemaTypeNullable() {
        if (this instanceof GraphLogicalExpand) {
            return ((GraphLogicalExpand)this).isOptional();
        }
        if (this.input instanceof GraphLogicalExpand) {
            return ((GraphLogicalExpand)this.input).isOptional();
        }
        if (this.input instanceof GraphPhysicalExpand) {
            return ((GraphPhysicalExpand)this.input).isOptional();
        }
        if (this.input instanceof GraphLogicalPathExpand) {
            return ((GraphLogicalPathExpand)this.input).isOptional();
        }
        return false;
    }

    public void setSchemaType(GraphSchemaType graphType) {
        this.rowType = new RelRecordType((List)ImmutableList.of((Object)new RelDataTypeFieldImpl(this.getAliasName(), this.getAliasId(), (RelDataType)graphType)));
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public int getAliasId() {
        return this.aliasId;
    }

    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return pw.itemIf("input", (Object)this.input, !Objects.isNull(this.input)).item("tableConfig", this.explainTableConfig()).item("alias", (Object)AliasInference.SIMPLE_NAME(this.getAliasName())).itemIf("aliasId", (Object)this.getAliasId(), pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("startAlias", (Object)this.startAlias.getAliasName(), this.startAlias.getAliasName() != "_").itemIf("startAliasId", (Object)this.startAlias.getAliasId(), pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("fusedProject", (Object)this.project, !ObjectUtils.isEmpty((Object)this.project)).itemIf("fusedFilter", this.filters, !ObjectUtils.isEmpty(this.filters));
    }

    protected Object explainTableConfig() {
        if (this instanceof GraphLogicalExpand) {
            GraphSchemaType deriveSchema = (GraphSchemaType)((RelDataTypeField)this.deriveRowType().getFieldList().get(0)).getType();
            GraphSchemaType curSchema = (GraphSchemaType)((RelDataTypeField)this.getRowType().getFieldList().get(0)).getType();
            if (!curSchema.getLabelType().getLabelsEntry().equals(deriveSchema.getLabelType().getLabelsEntry())) {
                return curSchema.getLabelType();
            }
        }
        return this.tableConfig;
    }

    public List<RelNode> getInputs() {
        return this.input == null ? ImmutableList.of() : ImmutableList.of((Object)this.input);
    }

    public void replaceInput(int ordinalInParent, RelNode p) {
        if (this.input == null) {
            return;
        }
        assert (ordinalInParent == 0);
        this.input = p;
        this.recomputeDigest();
    }

    public void setFilters(ImmutableList<RexNode> filters) {
        this.filters = Objects.requireNonNull(filters);
    }

    public @Nullable ImmutableList<RexNode> getFilters() {
        return this.filters;
    }

    public AliasNameWithId getStartAlias() {
        return this.startAlias;
    }

    public void setCachedCost(RelOptCost cost) {
        this.cachedCost = cost;
    }

    public @Nullable RelOptCost getCachedCost() {
        return this.cachedCost;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.cachedCost != null ? this.cachedCost.getRows() : mq.getRowCount((RelNode)this).doubleValue();
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double dRows = this.estimateRowCount(mq);
        double dCpu = dRows + 1.0;
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }
}

