/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.graph;

import com.alibaba.graphscope.common.ir.meta.glogue.DetailedExpandCost;
import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphPhysicalGetV;
import com.alibaba.graphscope.common.ir.rel.type.AliasNameWithId;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphLogicalPathExpand
extends SingleRel {
    private final RelNode expand;
    private final RelNode getV;
    private final RelNode fused;
    private final @Nullable RexNode offset;
    private final @Nullable RexNode fetch;
    private final GraphOpt.PathExpandResult resultOpt;
    private final GraphOpt.PathExpandPath pathOpt;
    private final String aliasName;
    private final int aliasId;
    private final AliasNameWithId startAlias;
    private final boolean optional;
    private final @Nullable RexNode untilCondition;
    private @Nullable RelOptCost cachedCost = null;

    protected GraphLogicalPathExpand(GraphOptCluster cluster, @Nullable List<RelHint> hints, RelNode input, RelNode expand, RelNode getV, @Nullable RexNode offset, @Nullable RexNode fetch, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt, @Nullable RexNode untilCondition, @Nullable String aliasName, AliasNameWithId startAlias, boolean optional) {
        super((RelOptCluster)cluster, RelTraitSet.createEmpty(), input);
        this.expand = Objects.requireNonNull(expand);
        this.getV = Objects.requireNonNull(getV);
        this.fused = null;
        this.offset = offset;
        this.fetch = fetch;
        this.pathOpt = pathOpt;
        this.aliasName = AliasInference.inferDefault(aliasName, AliasInference.getUniqueAliasList(input, true));
        this.aliasId = cluster.getIdGenerator().generate(this.aliasName);
        this.startAlias = Objects.requireNonNull(startAlias);
        this.optional = optional;
        this.resultOpt = resultOpt;
        this.untilCondition = untilCondition;
    }

    protected GraphLogicalPathExpand(GraphOptCluster cluster, @Nullable List<RelHint> hints, RelNode input, RelNode fused, @Nullable RexNode offset, @Nullable RexNode fetch, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt, @Nullable RexNode untilCondition, @Nullable String aliasName, AliasNameWithId startAlias, boolean optional) {
        super((RelOptCluster)cluster, RelTraitSet.createEmpty(), input);
        this.expand = null;
        this.getV = null;
        this.fused = Objects.requireNonNull(fused);
        this.offset = offset;
        this.fetch = fetch;
        this.resultOpt = resultOpt;
        this.pathOpt = pathOpt;
        this.aliasName = AliasInference.inferDefault(aliasName, AliasInference.getUniqueAliasList(input, true));
        this.aliasId = cluster.getIdGenerator().generate(this.aliasName);
        this.startAlias = Objects.requireNonNull(startAlias);
        this.optional = optional;
        this.untilCondition = untilCondition;
    }

    public static GraphLogicalPathExpand create(GraphOptCluster cluster, List<RelHint> hints, RelNode input, RelNode expand, RelNode getV, @Nullable RexNode offset, @Nullable RexNode fetch, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt, @Nullable RexNode untilCondition, String aliasName, AliasNameWithId startAlias, boolean optional) {
        return new GraphLogicalPathExpand(cluster, hints, input, expand, getV, offset, fetch, resultOpt, pathOpt, untilCondition, aliasName, startAlias, optional);
    }

    public static GraphLogicalPathExpand create(GraphOptCluster cluster, List<RelHint> hints, RelNode input, RelNode expand, RelNode getV, @Nullable RexNode offset, @Nullable RexNode fetch, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt, @Nullable RexNode untilCondition, String aliasName, AliasNameWithId startAlias) {
        return GraphLogicalPathExpand.create(cluster, hints, input, expand, getV, offset, fetch, resultOpt, pathOpt, untilCondition, aliasName, startAlias, false);
    }

    public static GraphLogicalPathExpand create(GraphOptCluster cluster, List<RelHint> hints, RelNode input, RelNode fused, @Nullable RexNode offset, @Nullable RexNode fetch, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt, @Nullable RexNode untilCondition, String aliasName, AliasNameWithId startAlias) {
        return GraphLogicalPathExpand.create(cluster, hints, input, fused, offset, fetch, resultOpt, pathOpt, untilCondition, aliasName, startAlias, false);
    }

    public static GraphLogicalPathExpand create(GraphOptCluster cluster, List<RelHint> hints, RelNode input, RelNode fused, @Nullable RexNode offset, @Nullable RexNode fetch, GraphOpt.PathExpandResult resultOpt, GraphOpt.PathExpandPath pathOpt, @Nullable RexNode untilCondition, String aliasName, AliasNameWithId startAlias, boolean optional) {
        Preconditions.checkArgument((resultOpt != GraphOpt.PathExpandResult.ALL_V_E ? 1 : 0) != 0, (Object)("can not fuse expand with getV if result opt is set to " + resultOpt.name()));
        return new GraphLogicalPathExpand(cluster, hints, input, fused, offset, fetch, resultOpt, pathOpt, untilCondition, aliasName, startAlias, optional);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("expand", (Object)RelOptUtil.toString((RelNode)this.expand), this.expand != null).itemIf("getV", (Object)RelOptUtil.toString((RelNode)this.getV), this.getV != null).itemIf("fused", (Object)RelOptUtil.toString((RelNode)this.fused), this.fused != null).itemIf("offset", (Object)this.offset, this.offset != null).itemIf("fetch", (Object)this.fetch, this.fetch != null).item("path_opt", (Object)this.getPathOpt()).item("result_opt", (Object)this.getResultOpt()).itemIf("until_condition", (Object)this.untilCondition, this.untilCondition != null).item("alias", (Object)AliasInference.SIMPLE_NAME(this.getAliasName())).itemIf("aliasId", (Object)this.getAliasId(), pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("start_alias", (Object)this.startAlias.getAliasName(), this.startAlias.getAliasName() != "_").itemIf("startAliasId", (Object)this.startAlias.getAliasId(), pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("optional", (Object)this.optional, this.optional);
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public int getAliasId() {
        return this.aliasId;
    }

    public GraphOpt.PathExpandPath getPathOpt() {
        return this.pathOpt;
    }

    public GraphOpt.PathExpandResult getResultOpt() {
        return this.resultOpt;
    }

    public RelNode getExpand() {
        return this.expand;
    }

    public RelNode getGetV() {
        return this.getV;
    }

    public @Nullable RelNode getFused() {
        return this.fused;
    }

    public @Nullable RexNode getOffset() {
        return this.offset;
    }

    public @Nullable RexNode getFetch() {
        return this.fetch;
    }

    public AliasNameWithId getStartAlias() {
        return this.startAlias;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public @Nullable RexNode getUntilCondition() {
        return this.untilCondition;
    }

    protected RelDataType deriveRowType() {
        return new RelRecordType((List)ImmutableList.of((Object)new RelDataTypeFieldImpl(this.getAliasName(), this.getAliasId(), (RelDataType)new GraphPathType(this.getElementType(), this.optional))));
    }

    private GraphPathType.ElementType getElementType() {
        GraphLogicalExpand innerExpand = null;
        GraphLogicalGetV innerGetV = null;
        if (this.fused instanceof GraphPhysicalGetV) {
            innerExpand = ((GraphPhysicalExpand)this.fused.getInput(0)).getFusedExpand();
            innerGetV = ((GraphPhysicalGetV)this.fused).getFusedGetV();
        } else if (this.fused instanceof GraphPhysicalExpand) {
            innerExpand = ((GraphPhysicalExpand)this.fused).getFusedExpand();
            innerGetV = ((GraphPhysicalExpand)this.fused).getFusedGetV();
        } else if (this.expand != null && this.getV != null) {
            innerExpand = (GraphLogicalExpand)this.expand;
            innerGetV = (GraphLogicalGetV)this.getV;
        }
        Preconditions.checkArgument((innerExpand != null && !innerExpand.getRowType().getFieldList().isEmpty() ? 1 : 0) != 0, (Object)"data type of expand operator should have at least one column field");
        Preconditions.checkArgument((innerGetV != null && !innerGetV.getRowType().getFieldList().isEmpty() ? 1 : 0) != 0, (Object)"data type of getV operator should have at least one column field");
        return new GraphPathType.ElementType(((RelDataTypeField)innerExpand.getRowType().getFieldList().get(0)).getType(), ((RelDataTypeField)innerGetV.getRowType().getFieldList().get(0)).getType());
    }

    public GraphLogicalPathExpand copy(RelTraitSet traitSet, List<RelNode> inputs) {
        GraphLogicalPathExpand copy = this.fused != null ? new GraphLogicalPathExpand((GraphOptCluster)this.getCluster(), (List<RelHint>)ImmutableList.of(), inputs.get(0), this.fused, this.getOffset(), this.getFetch(), this.getResultOpt(), this.getPathOpt(), this.getUntilCondition(), this.getAliasName(), this.getStartAlias(), this.isOptional()) : new GraphLogicalPathExpand((GraphOptCluster)this.getCluster(), (List<RelHint>)ImmutableList.of(), inputs.get(0), this.expand, this.getV, this.getOffset(), this.getFetch(), this.getResultOpt(), this.getPathOpt(), this.getUntilCondition(), this.getAliasName(), this.getStartAlias(), this.isOptional());
        copy.setCachedCost(this.cachedCost);
        return copy;
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof GraphShuttle) {
            return ((GraphShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }

    public void setCachedCost(RelOptCost cost) {
        this.cachedCost = cost;
    }

    public RelOptCost getCachedCost() {
        return this.cachedCost;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.cachedCost instanceof DetailedExpandCost ? ((DetailedExpandCost)this.cachedCost).getExpandFilteringRows() : super.estimateRowCount(mq);
    }
}

