/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.graph;

import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.type.AliasNameWithId;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphPhysicalExpand
extends SingleRel {
    private final GraphOpt.PhysicalExpandOpt physicalOpt;
    private final GraphLogicalExpand fusedExpand;
    private final GraphLogicalGetV fusedGetV;
    private final String aliasName;
    private final int aliasId;
    private final boolean optional;

    protected GraphPhysicalExpand(RelOptCluster cluster, List<RelHint> hints, RelNode input, GraphLogicalExpand fusedExpand, GraphLogicalGetV fusedGetV, GraphOpt.PhysicalExpandOpt physicalOpt, String aliasName, boolean optional) {
        super(cluster, RelTraitSet.createEmpty(), input);
        this.physicalOpt = physicalOpt;
        this.fusedExpand = fusedExpand;
        this.fusedGetV = fusedGetV;
        this.aliasName = AliasInference.inferDefault(aliasName, AliasInference.getUniqueAliasList(input, true));
        this.aliasId = ((GraphOptCluster)cluster).getIdGenerator().generate(this.aliasName);
        this.optional = optional;
    }

    public static GraphPhysicalExpand create(RelOptCluster cluster, List<RelHint> hints, RelNode input, GraphLogicalExpand fusedExpand, GraphLogicalGetV fusedGetV, GraphOpt.PhysicalExpandOpt physicalOpt, String aliasName) {
        GraphLogicalGetV newGetV = null;
        if (fusedGetV != null) {
            if (fusedGetV.getAliasName().equals(aliasName)) {
                newGetV = fusedGetV;
            } else {
                newGetV = GraphLogicalGetV.create((GraphOptCluster)fusedGetV.getCluster(), (List<RelHint>)fusedGetV.getHints(), input, fusedGetV.getOpt(), fusedGetV.getTableConfig(), aliasName, fusedGetV.getStartAlias());
                if (ObjectUtils.isNotEmpty(fusedGetV.getFilters())) {
                    newGetV.setFilters(fusedGetV.getFilters());
                }
            }
        }
        return new GraphPhysicalExpand(cluster, hints, input, fusedExpand, newGetV, physicalOpt, aliasName, fusedExpand.isOptional());
    }

    public GraphOpt.PhysicalExpandOpt getPhysicalOpt() {
        return this.physicalOpt;
    }

    public GraphLogicalExpand getFusedExpand() {
        return this.fusedExpand;
    }

    public AliasNameWithId getStartAlias() {
        return this.fusedExpand.getStartAlias();
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public int getAliasId() {
        return this.aliasId;
    }

    public @Nullable ImmutableList<RexNode> getFilters() {
        return this.fusedExpand.getFilters();
    }

    public boolean isOptional() {
        return this.optional;
    }

    public RelDataType deriveRowType() {
        switch (this.physicalOpt) {
            case EDGE: {
                return this.fusedExpand.getRowType();
            }
            case DEGREE: {
                RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
                RelDataTypeFieldImpl field = new RelDataTypeFieldImpl(this.aliasName, this.aliasId, typeFactory.createSqlType(SqlTypeName.BIGINT));
                return new RelRecordType((List)ImmutableList.of((Object)field));
            }
        }
        return this.fusedGetV.getRowType();
    }

    public List<RelNode> getInputs() {
        return this.input == null ? ImmutableList.of() : ImmutableList.of((Object)this.input);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return pw.itemIf("input", (Object)this.input, !Objects.isNull(this.input)).item("tableConfig", this.fusedExpand.explainTableConfig()).item("alias", (Object)AliasInference.SIMPLE_NAME(this.getAliasName())).itemIf("aliasId", (Object)this.getAliasId(), pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("startAlias", (Object)this.fusedExpand.getStartAlias().getAliasName(), this.fusedExpand.getStartAlias().getAliasName() != "_").itemIf("startAliasId", (Object)this.fusedExpand.getStartAlias().getAliasId(), pw.getDetailLevel() == SqlExplainLevel.DIGEST_ATTRIBUTES).itemIf("fusedFilter", this.fusedExpand.getFilters(), !ObjectUtils.isEmpty(this.fusedExpand.getFilters())).item("opt", (Object)this.fusedExpand.getOpt()).item("physicalOpt", (Object)this.getPhysicalOpt()).itemIf("optional", (Object)this.optional, this.optional);
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof GraphShuttle) {
            return ((GraphShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }

    public GraphPhysicalExpand copy(RelTraitSet traitSet, List<RelNode> inputs) {
        GraphPhysicalExpand copy = new GraphPhysicalExpand(this.getCluster(), (List<RelHint>)this.fusedGetV.getHints(), inputs.get(0), this.fusedExpand, this.fusedGetV, this.getPhysicalOpt(), this.aliasName, this.optional);
        return copy;
    }

    public GraphLogicalGetV getFusedGetV() {
        return this.fusedGetV;
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.fusedExpand != null ? this.fusedExpand.estimateRowCount(mq) : super.estimateRowCount(mq);
    }
}

