/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.graph.match;

import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.match.AbstractLogicalMatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphLogicalMultiMatch
extends AbstractLogicalMatch {
    private List<RelNode> sentences;

    protected GraphLogicalMultiMatch(GraphOptCluster cluster, @Nullable List<RelHint> hints, @Nullable RelNode input, RelNode firstSentence, List<RelNode> otherSentences) {
        super(cluster, hints, input);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.sentences = builder.add((Object)Objects.requireNonNull(firstSentence)).addAll((Iterable)ObjectUtils.requireNonEmpty(otherSentences)).build();
    }

    public static GraphLogicalMultiMatch create(GraphOptCluster cluster, @Nullable List<RelHint> hints, RelNode input, RelNode firstSentence, List<RelNode> otherSentences) {
        return new GraphLogicalMultiMatch(cluster, hints, input, firstSentence, otherSentences);
    }

    public RelWriter explainTerms(RelWriter pw) {
        LinkedHashMap<String, String> strMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.sentences.size(); ++i) {
            strMap.put(String.format("s%d", i), String.format("[%s]", RelOptUtil.toString((RelNode)this.sentences.get(i))));
        }
        return super.explainTerms(pw).itemIf("sentences", strMap, !ObjectUtils.isEmpty(strMap));
    }

    public RelDataType deriveRowType() {
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
        for (RelNode node : this.sentences) {
            this.addFields(fields, node);
        }
        HashSet fieldNames = Sets.newHashSet();
        List dedup = fields.stream().filter(k -> {
            boolean notExist = !fieldNames.contains(k.getName());
            fieldNames.add(k.getName());
            return notExist;
        }).collect(Collectors.toList());
        return new RelRecordType(StructKind.FULLY_QUALIFIED, dedup);
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof GraphShuttle) {
            return ((GraphShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }

    public GraphLogicalMultiMatch copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new GraphLogicalMultiMatch((GraphOptCluster)this.getCluster(), (List<RelHint>)ImmutableList.of(), inputs.get(0), this.sentences.get(0), this.sentences.subList(1, this.sentences.size()));
    }

    public List<RelNode> getSentences() {
        return Collections.unmodifiableList(this.sentences);
    }
}

