/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.graph.match;

import com.alibaba.graphscope.common.ir.rel.GraphShuttle;
import com.alibaba.graphscope.common.ir.rel.graph.match.AbstractLogicalMatch;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphLogicalSingleMatch
extends AbstractLogicalMatch {
    private final RelNode sentence;
    private final GraphOpt.Match matchOpt;

    protected GraphLogicalSingleMatch(GraphOptCluster cluster, @Nullable List<RelHint> hints, @Nullable RelNode input, RelNode sentence, GraphOpt.Match matchOpt) {
        super(cluster, hints, input);
        this.sentence = Objects.requireNonNull(sentence);
        this.matchOpt = matchOpt;
    }

    public static GraphLogicalSingleMatch create(GraphOptCluster cluster, @Nullable List<RelHint> hints, RelNode input, RelNode sentence, GraphOpt.Match matchOpt) {
        return new GraphLogicalSingleMatch(cluster, hints, input, sentence, matchOpt);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("sentence", (Object)RelOptUtil.toString((RelNode)this.sentence)).item("matchOpt", (Object)this.matchOpt);
    }

    public RelDataType deriveRowType() {
        List<Object> fields = Lists.newArrayList();
        this.addFields(fields, this.sentence);
        if (this.matchOpt == GraphOpt.Match.OPTIONAL) {
            RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
            fields = fields.stream().map(k -> new RelDataTypeFieldImpl(k.getName(), k.getIndex(), typeFactory.createTypeWithNullability(k.getType(), true))).collect(Collectors.toList());
        }
        return new RelRecordType(StructKind.FULLY_QUALIFIED, (List)fields);
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof GraphShuttle) {
            return ((GraphShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }

    public GraphLogicalSingleMatch copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new GraphLogicalSingleMatch((GraphOptCluster)this.getCluster(), (List<RelHint>)ImmutableList.of(), inputs.get(0), this.sentence, this.matchOpt);
    }

    public RelNode getSentence() {
        return this.sentence;
    }

    public GraphOpt.Match getMatchOpt() {
        return this.matchOpt;
    }
}

