/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.metadata.glogue;

import com.alibaba.graphscope.common.ir.rel.metadata.glogue.ExtendStep;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueBasicCardinalityEstimationImpl;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueCardinalityEstimation;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.GlogueExtendIntersectEdge;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.Pattern;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.PatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.glogue.pattern.SinglePatternVertex;
import com.alibaba.graphscope.common.ir.rel.metadata.schema.GlogueSchema;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.graph.DirectedPseudograph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Glogue {
    private Graph<Pattern, GlogueEdge> glogueGraph;
    private GlogueCardinalityEstimation glogueCardinalityEstimation;
    private List<Pattern> roots;
    private int maxPatternId;
    private int maxPatternSize;
    private static Logger logger = LoggerFactory.getLogger(Glogue.class);
    protected final GlogueSchema schema;

    public Glogue(GlogueSchema schema, int maxPatternSize) {
        this.schema = schema;
        this.glogueGraph = new DirectedPseudograph(GlogueEdge.class);
        this.roots = new ArrayList<Pattern>();
        this.maxPatternId = 0;
        this.create(schema, maxPatternSize);
    }

    private Glogue create(GlogueSchema schema, int maxPatternSize) {
        this.maxPatternSize = maxPatternSize;
        ArrayDeque<Pattern> patternQueue = new ArrayDeque<Pattern>();
        for (Integer vertexTypeId : schema.getVertexTypes()) {
            SinglePatternVertex vertex = new SinglePatternVertex(vertexTypeId);
            Pattern new_pattern = new Pattern(vertex);
            this.addPattern(new_pattern);
            this.addRoot(new_pattern);
            patternQueue.add(new_pattern);
        }
        while (patternQueue.size() > 0) {
            Pattern pattern = (Pattern)patternQueue.pop();
            if (pattern.getVertexNumber() >= maxPatternSize) continue;
            List<ExtendStep> extendSteps = pattern.getExtendSteps(schema);
            for (ExtendStep extendStep : extendSteps) {
                Map<Integer, Integer> srcToDstPatternMapping;
                logger.debug(extendStep.toString());
                Pattern newPattern = pattern.extend(extendStep);
                Optional<Pattern> existingPattern = this.getGlogueVertex(newPattern);
                if (!existingPattern.isPresent()) {
                    this.addPattern(newPattern);
                    srcToDstPatternMapping = this.computePatternMapping(pattern, newPattern, extendStep);
                    this.addEdge(pattern, newPattern, extendStep, srcToDstPatternMapping);
                    patternQueue.add(newPattern);
                    continue;
                }
                if (this.containsEdge(pattern, existingPattern.get())) continue;
                srcToDstPatternMapping = this.computePatternMapping(pattern, newPattern, extendStep);
                this.addEdge(pattern, existingPattern.get(), extendStep, srcToDstPatternMapping);
            }
        }
        this.glogueCardinalityEstimation = new GlogueBasicCardinalityEstimationImpl(this, schema);
        logger.info("GlogueGraph is created, with {} vertices and {} edges", (Object)this.glogueGraph.vertexSet().size(), (Object)this.glogueGraph.edgeSet().size());
        return this;
    }

    public Set<GlogueEdge> getOutEdges(Pattern pattern) {
        Optional<Pattern> vertex = this.getGlogueVertex(pattern);
        if (vertex.isPresent()) {
            return this.getGlogueOutEdges(vertex.get());
        }
        logger.warn("pattern not found in glogue graph, queried pattern " + pattern);
        return new HashSet<GlogueEdge>();
    }

    public Set<GlogueEdge> getInEdges(Pattern pattern) {
        Optional<Pattern> vertex = this.getGlogueVertex(pattern);
        if (vertex.isPresent()) {
            return this.getGlogueInEdges(vertex.get());
        }
        logger.warn("pattern not found in glogue graph, queried pattern " + pattern);
        return new HashSet<GlogueEdge>();
    }

    public Double getRowCount(Pattern pattern) {
        return this.glogueCardinalityEstimation.getCardinality(pattern);
    }

    public @Nullable Double getRowCount(Pattern pattern, boolean allowsNull) {
        return this.glogueCardinalityEstimation instanceof GlogueBasicCardinalityEstimationImpl ? ((GlogueBasicCardinalityEstimationImpl)this.glogueCardinalityEstimation).getCardinality(pattern, allowsNull) : this.getRowCount(pattern);
    }

    public int getMaxPatternSize() {
        return this.maxPatternSize;
    }

    protected Set<GlogueEdge> getGlogueOutEdges(Pattern pattern) {
        return this.glogueGraph.outgoingEdgesOf((Object)pattern);
    }

    protected Set<GlogueEdge> getGlogueInEdges(Pattern pattern) {
        return this.glogueGraph.incomingEdgesOf((Object)pattern);
    }

    private void addRoot(Pattern pattern) {
        this.roots.add(pattern);
    }

    protected List<Pattern> getRoots() {
        return this.roots;
    }

    private Optional<Pattern> getGlogueVertex(Pattern pattern) {
        for (Pattern p : this.glogueGraph.vertexSet()) {
            if (!p.equals(pattern)) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    private boolean containsEdge(Pattern srcPattern, Pattern dstPattern) {
        return this.glogueGraph.containsEdge((Object)srcPattern, (Object)dstPattern);
    }

    private boolean addPattern(Pattern pattern) {
        pattern.setPatternId(this.maxPatternId++);
        return this.glogueGraph.addVertex((Object)pattern);
    }

    private boolean addEdge(Pattern srcPattern, Pattern dstPattern, ExtendStep edge, Map<Integer, Integer> srcToDstIdMapping) {
        GlogueExtendIntersectEdge glogueEdge = new GlogueExtendIntersectEdge(srcPattern, dstPattern, edge, srcToDstIdMapping);
        return this.glogueGraph.addEdge((Object)srcPattern, (Object)dstPattern, (Object)glogueEdge);
    }

    private Map<Integer, Integer> computePatternMapping(Pattern srcPattern, Pattern dstPattern, ExtendStep extendStep) {
        HashMap<Integer, Integer> srcToDstPatternMapping = new HashMap<Integer, Integer>();
        for (PatternVertex dstVertex : dstPattern.getVertexSet()) {
            Integer dstVertexOrder = dstPattern.getVertexOrder(dstVertex);
            PatternVertex srcVertex = srcPattern.getVertexById(dstVertex.getId());
            if (srcVertex == null) {
                extendStep.setTargetVertexOrder(dstVertexOrder);
                continue;
            }
            Integer srcVertexOrder = srcPattern.getVertexOrder(srcVertex);
            srcToDstPatternMapping.put(srcVertexOrder, dstVertexOrder);
        }
        return srcToDstPatternMapping;
    }

    public String toString() {
        Object s = "GlogueVertices:\n";
        for (Pattern p : this.glogueGraph.vertexSet()) {
            s = (String)s + p.toString() + "\n";
        }
        s = (String)s + "\nGlogueEdges:\n";
        for (GlogueEdge e : this.glogueGraph.edgeSet()) {
            s = (String)s + e.toString() + "\n";
        }
        if (this.glogueCardinalityEstimation != null) {
            s = (String)s + "\nGlogueCardinalityEstimation:\n";
            s = (String)s + this.glogueCardinalityEstimation.toString();
        }
        return s;
    }
}

