/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rel.type.group;

import com.alibaba.graphscope.common.ir.rex.RexCallBinding;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Litmus;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphAggCall
implements RelBuilder.AggCall {
    private final RelDataType type;
    private final RelOptCluster cluster;
    private final List<RexNode> operands;
    private final SqlAggFunction aggFunction;
    private @Nullable String alias;
    private boolean distinct;
    private boolean approximate;
    private boolean ignoreNulls;
    private @Nullable RexNode filter;
    private @Nullable ImmutableList<RexNode> distinctKeys;
    private @Nullable ImmutableList<RexNode> orderKeys;

    public GraphAggCall(RelOptCluster cluster, SqlAggFunction aggFunction, List<RexNode> operands) {
        this.cluster = Objects.requireNonNull(cluster);
        this.aggFunction = aggFunction;
        this.operands = (List)ObjectUtils.requireNonEmpty(operands);
        this.type = this.validateThenDerive(aggFunction, operands);
    }

    public GraphAggCall as(@Nullable String alias) {
        this.alias = alias;
        return this;
    }

    public GraphAggCall distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public GraphAggCall approximate(boolean approximate) {
        this.approximate = approximate;
        return this;
    }

    public GraphAggCall ignoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
        return this;
    }

    public GraphAggCall filter(RexNode rexNode) {
        this.filter = Objects.requireNonNull(rexNode);
        return this;
    }

    public GraphAggCall sort(Iterable<RexNode> orderKeys) {
        this.orderKeys = ImmutableList.copyOf((Iterable)((Iterable)ObjectUtils.requireNonEmpty(orderKeys)));
        return this;
    }

    public GraphAggCall unique(@Nullable Iterable<RexNode> distinctKeys) {
        this.distinctKeys = ImmutableList.copyOf((Iterable)((Iterable)ObjectUtils.requireNonEmpty(distinctKeys)));
        return this;
    }

    public RelBuilder.OverCall over() {
        throw new UnsupportedOperationException("over in AggCall is unsupported yet");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return builder.append("{").append("operands=").append(this.operands).append(", aggFunction=").append(this.aggFunction).append(", alias='").append(AliasInference.SIMPLE_NAME(this.alias)).append('\'').append(", distinct=").append(this.distinct).append('}').toString();
    }

    private RelDataType validateThenDerive(SqlAggFunction aggFunction, List<RexNode> operands) {
        if (this.cluster != null) {
            RelDataTypeFactory factory = this.cluster.getTypeFactory();
            RexCallBinding callBinding = new RexCallBinding(factory, (SqlOperator)aggFunction, operands, (List<RelCollation>)ImmutableList.of());
            aggFunction.validRexOperands(callBinding.getOperandCount(), Litmus.THROW);
            aggFunction.checkOperandTypes((SqlCallBinding)callBinding, true);
            return aggFunction.inferReturnType((SqlOperatorBinding)callBinding);
        }
        return null;
    }

    public RelDataType getType() {
        return this.type;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<RexNode> getOperands() {
        return Collections.unmodifiableList(this.operands);
    }

    public SqlAggFunction getAggFunction() {
        return this.aggFunction;
    }

    public @Nullable String getAlias() {
        return this.alias;
    }

    public RexNode rexCall() {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        return rexBuilder.makeCall(this.type, (SqlOperator)this.aggFunction, this.operands);
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    public GraphAggCall copy(String alias) {
        return new GraphAggCall(this.cluster, this.aggFunction, this.operands).as(alias).distinct(this.distinct);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphAggCall that = (GraphAggCall)o;
        return this.distinct == that.distinct && this.approximate == that.approximate && this.ignoreNulls == that.ignoreNulls && Objects.equals(this.operands, that.operands) && Objects.equals(this.aggFunction, that.aggFunction) && Objects.equals(this.alias, that.alias) && Objects.equals(this.filter, that.filter) && Objects.equals(this.distinctKeys, that.distinctKeys) && Objects.equals(this.orderKeys, that.orderKeys);
    }

    public int hashCode() {
        return Objects.hash(this.operands, this.aggFunction, this.alias, this.distinct, this.approximate, this.ignoreNulls, this.filter, this.distinctKeys, this.orderKeys);
    }
}

