/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex;

import com.alibaba.graphscope.common.ir.rex.RexTmpVariable;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class RexSubQueryPreComputer
extends RexVisitorImpl<RexNode> {
    private final List<RexNode> subQueryNodes;
    private final List<String> subQueryAliases;
    private final Set<String> uniqueAliases;
    private final GraphBuilder builder;

    public RexSubQueryPreComputer(GraphBuilder builder) {
        super(true);
        this.builder = builder;
        this.subQueryNodes = Lists.newArrayList();
        this.subQueryAliases = Lists.newArrayList();
        this.uniqueAliases = AliasInference.getUniqueAliasList(builder.peek(), true);
    }

    public RexNode precompute(RexNode top) {
        switch (top.getKind()) {
            case DESCENDING: 
            case AS: 
            case NOT: 
            case AND: 
            case OR: {
                List operands = ((RexCall)top).getOperands().stream().map(k -> this.precompute((RexNode)k)).collect(Collectors.toList());
                return this.builder.call(((RexCall)top).getOperator(), operands);
            }
        }
        if (top instanceof RexSubQuery) {
            return top;
        }
        return (RexNode)top.accept((RexVisitor)this);
    }

    public RexNode visitCall(RexCall call) {
        ArrayList<RexNode> results = new ArrayList<RexNode>();
        for (RexNode operand : call.getOperands()) {
            results.add((RexNode)operand.accept((RexVisitor)this));
        }
        return this.builder.call(call.getOperator(), results);
    }

    public RexNode visitLiteral(RexLiteral literal) {
        if (literal.getType().getSqlTypeName() == SqlTypeName.SYMBOL && literal.getValue() instanceof TimeUnit) {
            return this.builder.getRexBuilder().makeIntervalLiteral(null, new SqlIntervalQualifier((TimeUnit)literal.getValueAs(TimeUnit.class), null, SqlParserPos.ZERO));
        }
        return literal;
    }

    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef;
    }

    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }

    public RexNode visitSubQuery(RexSubQuery subQuery) {
        String variableName;
        int index = this.subQueryNodes.indexOf(subQuery);
        if (index >= 0) {
            variableName = this.subQueryAliases.get(index);
        } else {
            this.subQueryNodes.add((RexNode)subQuery);
            variableName = this.inferAlias((RexNode)subQuery);
            this.subQueryAliases.add(variableName);
            this.uniqueAliases.add(variableName);
        }
        return RexTmpVariable.of(variableName, subQuery.getType());
    }

    public List<RexNode> getSubQueryNodes() {
        return this.subQueryNodes;
    }

    public List<String> getSubQueryAliases() {
        return this.subQueryAliases;
    }

    private String inferAlias(RexNode node) {
        ArrayList<String> newAliases = new ArrayList<String>();
        AliasInference.inferProject((List<RexNode>)ImmutableList.of((Object)node), newAliases, Sets.newHashSet(this.uniqueAliases));
        return (String)newAliases.get(0);
    }
}

