/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex;

import com.alibaba.graphscope.common.ir.rex.RexTmpVariable;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import java.util.ArrayList;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;

public class RexTmpVariableConverter
extends RexVisitorImpl<RexNode> {
    private final GraphBuilder builder;

    public RexTmpVariableConverter(boolean deep, GraphBuilder builder) {
        super(deep);
        this.builder = builder;
    }

    public RexNode visitCall(RexCall call) {
        if (!this.deep) {
            return null;
        }
        ArrayList<RexNode> results = new ArrayList<RexNode>();
        for (RexNode operand : call.getOperands()) {
            results.add((RexNode)operand.accept((RexVisitor)this));
        }
        return this.builder.call(call.getOperator(), results);
    }

    public RexNode visitLiteral(RexLiteral literal) {
        return literal;
    }

    public RexNode visitInputRef(RexInputRef inputRef) {
        return inputRef instanceof RexTmpVariable ? this.visitTmpVariable((RexTmpVariable)inputRef) : inputRef;
    }

    public RexNode visitTmpVariable(RexTmpVariable tmpVar) {
        return tmpVar.getProperty() == null ? this.builder.variable(tmpVar.getAlias()) : this.builder.variable(tmpVar.getAlias(), tmpVar.getProperty());
    }

    public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
        return dynamicParam;
    }
}

