/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex;

import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;

public class RexVariableAliasCollector<R>
extends RexVisitorImpl<List<R>> {
    private final Function<RexGraphVariable, R> collectFunc;

    public RexVariableAliasCollector(boolean deep, Function<RexGraphVariable, R> collectFunc) {
        super(deep);
        this.collectFunc = collectFunc;
    }

    public List<R> visitCall(RexCall call) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.deep) {
            call.getOperands().forEach(k -> builder.addAll((Iterable)k.accept((RexVisitor)this)));
        }
        return builder.build();
    }

    public List<R> visitLiteral(RexLiteral literal) {
        return ImmutableList.of();
    }

    public List<R> visitInputRef(RexInputRef inputRef) {
        return inputRef instanceof RexGraphVariable ? this.visitGraphVariable((RexGraphVariable)inputRef) : ImmutableList.of();
    }

    public List<R> visitGraphVariable(RexGraphVariable variable) {
        return ImmutableList.of(this.collectFunc.apply(variable));
    }

    public List<R> visitDynamicParam(RexDynamicParam dynamicParam) {
        return ImmutableList.of();
    }

    public List<R> visitSubQuery(RexSubQuery subQuery) {
        return ImmutableList.of();
    }
}

