/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex.operator;

import com.alibaba.graphscope.common.ir.rex.RexCallBinding;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Static;

public class CaseOperator
extends SqlOperator {
    public CaseOperator(SqlOperandTypeInference operandTypeInference) {
        super("CASE", SqlKind.CASE, 200, true, null, operandTypeInference, null);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        Preconditions.checkArgument((boolean)(callBinding instanceof RexCallBinding));
        boolean foundNotNull = false;
        int operandCount = callBinding.getOperandCount();
        for (int i = 0; i < operandCount - 1; ++i) {
            RelDataType type = callBinding.getOperandType(i);
            if ((i & 1) == 0) {
                if (SqlTypeUtil.inBooleanFamily((RelDataType)type)) continue;
                if (throwOnFailure) {
                    throw new IllegalArgumentException("Expected a boolean type at operand idx = " + i);
                }
                return false;
            }
            if (callBinding.isOperandNull(i, false)) continue;
            foundNotNull = true;
        }
        if (operandCount > 2 && !callBinding.isOperandNull(operandCount - 1, false)) {
            foundNotNull = true;
        }
        if (!foundNotNull) {
            if (throwOnFailure && !callBinding.isTypeCoercionEnabled()) {
                throw callBinding.newValidationError(Static.RESOURCE.mustNotNullInElse());
            }
            return false;
        }
        return true;
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        return CaseOperator.inferTypeFromOperands(opBinding);
    }

    private static RelDataType inferTypeFromOperands(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        List argTypes = opBinding.collectOperandTypes();
        assert (argTypes.size() % 2 == 1) : "odd number of arguments expected: " + argTypes.size();
        assert (argTypes.size() > 1) : "CASE must have more than 1 argument. Given " + argTypes.size() + ", " + argTypes;
        ArrayList<RelDataType> thenTypes = new ArrayList<RelDataType>();
        for (int j = 1; j < argTypes.size() - 1; j += 2) {
            RelDataType argType = (RelDataType)argTypes.get(j);
            if (argType == null || argType.getSqlTypeName() == SqlTypeName.NULL) continue;
            thenTypes.add(argType);
        }
        RelDataType lastType = (RelDataType)Iterables.getLast((Iterable)argTypes);
        if (lastType != null && lastType.getSqlTypeName() != SqlTypeName.NULL) {
            thenTypes.add(lastType);
        }
        return Objects.requireNonNull(typeFactory.leastRestrictive(thenTypes), () -> "Can't find leastRestrictive type for " + thenTypes);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.any();
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }
}

