/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.rex.operator;

import com.alibaba.graphscope.common.ir.type.GraphTypeFactoryImpl;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.fun.SqlMultisetValueConstructor;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SqlArrayValueConstructor
extends SqlMultisetValueConstructor {
    public SqlArrayValueConstructor() {
        super("ARRAY", SqlKind.ARRAY_VALUE_CONSTRUCTOR);
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        List argTypes;
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType componentType = this.getComponentType(typeFactory, argTypes = opBinding.collectOperandTypes());
        if (componentType != null && componentType.getSqlTypeName() != SqlTypeName.ANY) {
            return SqlTypeUtil.createArrayType((RelDataTypeFactory)typeFactory, (RelDataType)componentType, (boolean)false);
        }
        return ((GraphTypeFactoryImpl)typeFactory).createArbitraryArrayType(argTypes, false);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        return true;
    }

    protected @Nullable RelDataType getComponentType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        try {
            RelDataType componentType = typeFactory.leastRestrictive(argTypes);
            return componentType == null ? typeFactory.createSqlType(SqlTypeName.ANY) : componentType;
        }
        catch (Throwable e) {
            return typeFactory.createSqlType(SqlTypeName.ANY);
        }
    }
}

