/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.runtime;

import com.alibaba.graphscope.common.ir.runtime.PhysicalBuilder;
import com.alibaba.graphscope.common.ir.runtime.PhysicalPlan;
import com.alibaba.graphscope.common.ir.runtime.proto.Utils;
import com.alibaba.graphscope.common.ir.tools.LogicalPlan;
import com.alibaba.graphscope.gaia.proto.Common;
import com.alibaba.graphscope.gaia.proto.StoredProcedure;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.SqlOperator;

public class ProcedurePhysicalBuilder
extends PhysicalBuilder {
    private final StoredProcedure.Query.Builder builder = StoredProcedure.Query.newBuilder();

    public ProcedurePhysicalBuilder(LogicalPlan logicalPlan) {
        super(logicalPlan);
        RexCall procedureCall = (RexCall)logicalPlan.getProcedureCall();
        this.setStoredProcedureName(procedureCall, this.builder);
        this.setStoredProcedureArgs(procedureCall, this.builder);
    }

    private void setStoredProcedureName(RexCall procedureCall, StoredProcedure.Query.Builder builder) {
        SqlOperator operator = procedureCall.getOperator();
        builder.setQueryName(Common.NameOrId.newBuilder().setName(operator.getName()).build());
    }

    private void setStoredProcedureArgs(RexCall procedureCall, StoredProcedure.Query.Builder builder) {
        List operands = procedureCall.getOperands();
        for (int i = 0; i < operands.size(); ++i) {
            builder.addArguments(StoredProcedure.Argument.newBuilder().setParamInd(i).setValue(Utils.protoValue((RexLiteral)operands.get(i))).build());
        }
    }

    @Override
    public PhysicalPlan build() {
        return new PhysicalPlan<byte[]>(this.builder.build().toByteArray(), this.explain());
    }

    @Override
    public void close() throws Exception {
    }

    private String explain() {
        try {
            return JsonFormat.printer().print((MessageOrBuilder)this.builder);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }
}

