/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FrontendConfig;
import com.alibaba.graphscope.common.exception.FrontendException;
import com.alibaba.graphscope.common.ir.meta.procedure.StoredProcedureMeta;
import com.alibaba.graphscope.common.ir.meta.schema.GraphOptSchema;
import com.alibaba.graphscope.common.ir.meta.schema.IrGraphSchema;
import com.alibaba.graphscope.common.ir.rel.CommonTableScan;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalAggregate;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalDedupBy;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalProject;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalSort;
import com.alibaba.graphscope.common.ir.rel.GraphLogicalUnfold;
import com.alibaba.graphscope.common.ir.rel.PushFilterVisitor;
import com.alibaba.graphscope.common.ir.rel.graph.AbstractBindableTableScan;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.graph.match.AbstractLogicalMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.rel.type.AliasNameWithId;
import com.alibaba.graphscope.common.ir.rel.type.TableConfig;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphAggCall;
import com.alibaba.graphscope.common.ir.rel.type.group.GraphGroupKeys;
import com.alibaba.graphscope.common.ir.rel.type.order.GraphFieldCollation;
import com.alibaba.graphscope.common.ir.rel.type.order.GraphRelCollations;
import com.alibaba.graphscope.common.ir.rex.ClassifiedFilter;
import com.alibaba.graphscope.common.ir.rex.RexCallBinding;
import com.alibaba.graphscope.common.ir.rex.RexFilterClassifier;
import com.alibaba.graphscope.common.ir.rex.RexGraphDynamicParam;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariable;
import com.alibaba.graphscope.common.ir.rex.RexGraphVariableList;
import com.alibaba.graphscope.common.ir.rex.RexProcedureCall;
import com.alibaba.graphscope.common.ir.rex.RexPropertyChecker;
import com.alibaba.graphscope.common.ir.rex.RexSubQueryPreComputer;
import com.alibaba.graphscope.common.ir.rex.RexTmpVariableConverter;
import com.alibaba.graphscope.common.ir.rex.RexVariableAliasCollector;
import com.alibaba.graphscope.common.ir.rex.RexVariableAliasConverter;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.tools.GraphRexBuilder;
import com.alibaba.graphscope.common.ir.tools.GraphStdOperatorTable;
import com.alibaba.graphscope.common.ir.tools.Registrar;
import com.alibaba.graphscope.common.ir.tools.Utils;
import com.alibaba.graphscope.common.ir.tools.config.ExpandConfig;
import com.alibaba.graphscope.common.ir.tools.config.GetVConfig;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.tools.config.LabelConfig;
import com.alibaba.graphscope.common.ir.tools.config.PathExpandConfig;
import com.alibaba.graphscope.common.ir.tools.config.SourceConfig;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphNameOrId;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.common.ir.type.GraphProperty;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.alibaba.graphscope.common.ir.type.GraphTypeInference;
import com.alibaba.graphscope.proto.frontend.Code;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.rex.GraphRexSimplify;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.GraphInferTypes;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphBuilder
extends RelBuilder {
    private final Configs configs;

    protected GraphBuilder(Context context, GraphOptCluster cluster, RelOptSchema relOptSchema) {
        super(Objects.requireNonNull(context), (RelOptCluster)cluster, relOptSchema);
        com.alibaba.graphscope.gremlin.Utils.setFieldValue(RelBuilder.class, (Object)this, "simplifier", new GraphRexSimplify(cluster.getRexBuilder(), RelOptPredicateList.EMPTY, RexUtil.EXECUTOR));
        this.configs = (Configs)context.unwrapOrThrow(Configs.class);
    }

    public static GraphBuilder create(Context context, GraphOptCluster cluster, RelOptSchema relOptSchema) {
        return new GraphBuilder(context, cluster, relOptSchema);
    }

    public Context getContext() {
        return this.configs;
    }

    public GraphBuilder source(SourceConfig config) {
        GraphLogicalSource source = GraphLogicalSource.create((GraphOptCluster)this.cluster, (List<RelHint>)ImmutableList.of(), config.getOpt(), this.getTableConfig(config.getLabels(), config.getOpt()), config.getAlias());
        this.push((RelNode)source);
        return this;
    }

    public GraphBuilder expand(ExpandConfig config) {
        RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        GraphLogicalExpand expand = GraphLogicalExpand.create((GraphOptCluster)this.cluster, (List<RelHint>)ImmutableList.of(), input, config.getOpt(), this.getTableConfig(config.getLabels(), GraphOpt.Source.EDGE), config.getAlias(), this.getAliasNameWithId(config.getStartAlias(), type -> type instanceof GraphSchemaType && ((GraphSchemaType)((Object)type)).getScanOpt() == GraphOpt.Source.VERTEX));
        this.replaceTop((RelNode)expand);
        return this;
    }

    public GraphBuilder getV(GetVConfig config) {
        RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        GraphLogicalGetV getV = GraphLogicalGetV.create((GraphOptCluster)this.cluster, (List<RelHint>)ImmutableList.of(), input, config.getOpt(), this.getTableConfig(config.getLabels(), GraphOpt.Source.VERTEX), config.getAlias(), this.getAliasNameWithId(config.getStartAlias(), type -> type instanceof GraphSchemaType && ((GraphSchemaType)((Object)type)).getScanOpt() == GraphOpt.Source.EDGE || type instanceof GraphPathType));
        this.replaceTop((RelNode)getV);
        return this;
    }

    public GraphBuilder pathExpand(PathExpandConfig pxdConfig) {
        RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        RexLiteral offsetNode = pxdConfig.getOffset() <= 0 ? null : this.literal(pxdConfig.getOffset());
        RexLiteral fetchNode = pxdConfig.getFetch() < 0 ? null : this.literal(pxdConfig.getFetch());
        RelBuilder.Config config = (RelBuilder.Config)com.alibaba.graphscope.gremlin.Utils.getFieldValue(RelBuilder.class, (Object)this, "config");
        if (fetchNode != null && RexLiteral.intValue((RexNode)fetchNode) == 0 && config.simplifyLimit()) {
            return (GraphBuilder)this.empty();
        }
        RelNode expand = Objects.requireNonNull(pxdConfig.getExpand());
        RelNode getV = Objects.requireNonNull(pxdConfig.getGetV());
        GraphLogicalPathExpand pathExpand = GraphLogicalPathExpand.create((GraphOptCluster)this.cluster, (List<RelHint>)ImmutableList.of(), input, expand, getV, (RexNode)offsetNode, (RexNode)fetchNode, pxdConfig.getResultOpt(), pxdConfig.getPathOpt(), pxdConfig.getUntilCondition(), pxdConfig.getAlias(), this.getAliasNameWithId(pxdConfig.getStartAlias(), type -> type instanceof GraphSchemaType && ((GraphSchemaType)((Object)type)).getScanOpt() == GraphOpt.Source.VERTEX));
        this.replaceTop((RelNode)pathExpand);
        return this;
    }

    public TableConfig getTableConfig(LabelConfig labelConfig, GraphOpt.Source opt) {
        Preconditions.checkArgument((this.relOptSchema != null ? 1 : 0) != 0, (Object)"cannot create table config from the 'null' schema");
        ArrayList<RelOptTable> relOptTables = new ArrayList<RelOptTable>();
        if (!labelConfig.isAll()) {
            ObjectUtils.requireNonEmpty(labelConfig.getLabels());
            for (String label : labelConfig.getLabels()) {
                relOptTables.add(this.relOptSchema.getTableForMember((List)ImmutableList.of((Object)label)));
            }
        } else if (this.relOptSchema instanceof GraphOptSchema) {
            List<List<String>> allLabels = this.getTableNames(opt, ((GraphOptSchema)this.relOptSchema).getRootSchema());
            for (List<String> label : allLabels) {
                relOptTables.add(this.relOptSchema.getTableForMember(label));
            }
        } else {
            throw new IllegalArgumentException("cannot infer label types from the query given config");
        }
        return new TableConfig(relOptTables).isAll(labelConfig.isAll());
    }

    private AliasNameWithId getAliasNameWithId(@Nullable String aliasName, Predicate<RelDataType> checkType) {
        aliasName = AliasInference.isDefaultAlias(aliasName) ? "_" : aliasName;
        RexGraphVariable variable = this.variable(aliasName);
        Preconditions.checkArgument((boolean)checkType.test(variable.getType()), (String)"object with tag=%s mismatch with the expected type, current type is %s", (Object)aliasName, (Object)variable.getType());
        return new AliasNameWithId(aliasName, variable.getAliasId());
    }

    private List<List<String>> getTableNames(GraphOpt.Source opt, IrGraphSchema rootSchema) {
        switch (opt) {
            case VERTEX: {
                return rootSchema.getVertexList().stream().map(k -> ImmutableList.of((Object)k.getLabel())).collect(Collectors.toList());
            }
        }
        return rootSchema.getEdgeList().stream().map(k -> ImmutableList.of((Object)k.getLabel())).collect(Collectors.toList());
    }

    private int generateAliasId(@Nullable String alias) {
        RelOptCluster cluster = this.getCluster();
        return ((GraphOptCluster)cluster).getIdGenerator().generate(alias);
    }

    public GraphBuilder match(RelNode single, GraphOpt.Match opt) {
        RelNode match;
        RelNode input;
        if (FrontendConfig.GRAPH_TYPE_INFERENCE_ENABLED.get(this.configs).booleanValue()) {
            single = new GraphTypeInference(GraphBuilder.create(this.configs, (GraphOptCluster)this.cluster, this.relOptSchema)).inferTypes(single);
        }
        RelNode relNode = input = this.size() > 0 ? this.peek() : null;
        Object object = input == null && single instanceof GraphLogicalSource ? single : (match = GraphLogicalSingleMatch.create((GraphOptCluster)this.cluster, null, null, single, input == null ? opt : GraphOpt.Match.INNER));
        if (input == null) {
            this.push(match);
        } else {
            JoinRelType joinType = this.getJoinRelType(opt);
            RexNode joinCondition = this.getJoinCondition(input, match);
            if (joinType == JoinRelType.ANTI) {
                this.push(match).antiJoin(new RexNode[]{joinCondition});
            } else {
                this.push(match).join(joinType, joinCondition);
            }
        }
        return this;
    }

    public GraphBuilder match(RelNode first, Iterable<? extends RelNode> others) {
        List<Object> sentences = Lists.newArrayList();
        sentences.add(first);
        for (RelNode relNode : others) {
            sentences.add(relNode);
        }
        Preconditions.checkArgument((sentences.size() > 1 ? 1 : 0) != 0, (Object)"at least two sentences are required in multiple match");
        if (FrontendConfig.GRAPH_TYPE_INFERENCE_ENABLED.get(this.configs).booleanValue()) {
            sentences = new GraphTypeInference(GraphBuilder.create(this.configs, (GraphOptCluster)this.cluster, this.relOptSchema)).inferTypes((List<RelNode>)sentences);
        }
        RelNode input = this.size() > 0 ? this.peek() : null;
        GraphLogicalMultiMatch graphLogicalMultiMatch = GraphLogicalMultiMatch.create((GraphOptCluster)this.cluster, null, null, (RelNode)sentences.get(0), sentences.subList(1, sentences.size()));
        if (input == null) {
            this.push((RelNode)graphLogicalMultiMatch);
        } else {
            this.push((RelNode)graphLogicalMultiMatch).join(this.getJoinRelType(GraphOpt.Match.INNER), this.getJoinCondition(input, (RelNode)graphLogicalMultiMatch));
        }
        return this;
    }

    public GraphBuilder push(RelNode node) {
        super.push(node);
        return this;
    }

    public RexNode getJoinCondition(RelNode first, RelNode second) {
        ArrayList conditions = Lists.newArrayList();
        List firstFields = Utils.getOutputType(first).getFieldList();
        List secondFields = Utils.getOutputType(second).getFieldList();
        for (RelDataTypeField firstField : firstFields) {
            for (RelDataTypeField secondField : secondFields) {
                if (!this.isGraphElementTypeWithSameOpt(firstField.getType(), secondField.getType()) || firstField.getIndex() == -1 || firstField.getIndex() != secondField.getIndex() || !firstField.getName().equals(secondField.getName())) continue;
                RexGraphVariable leftKey = RexGraphVariable.of(firstField.getIndex(), this.getColumnIndex(first, firstField), AliasInference.SIMPLE_NAME(firstField.getName()), firstField.getType());
                RexGraphVariable rightKey = RexGraphVariable.of(secondField.getIndex(), firstFields.size() + this.getColumnIndex(second, secondField), AliasInference.SIMPLE_NAME(secondField.getName()), secondField.getType());
                conditions.add(this.equals((RexNode)leftKey, (RexNode)rightKey));
            }
        }
        return this.and(conditions);
    }

    private boolean isGraphElementTypeWithSameOpt(RelDataType first, RelDataType second) {
        return first instanceof GraphSchemaType && second instanceof GraphSchemaType && ((GraphSchemaType)first).getScanOpt() == ((GraphSchemaType)second).getScanOpt();
    }

    private JoinRelType getJoinRelType(GraphOpt.Match opt) {
        switch (opt) {
            case OPTIONAL: {
                return JoinRelType.LEFT;
            }
            case ANTI: {
                return JoinRelType.ANTI;
            }
        }
        return JoinRelType.INNER;
    }

    public RexGraphVariable variable(@Nullable String alias) {
        List<ColumnField> columnFields = this.getAliasField(alias = AliasInference.isDefaultAlias(alias) ? "_" : alias);
        if (columnFields.size() == 1) {
            ColumnField columnField = columnFields.get(0);
            RelDataTypeField aliasField = (RelDataTypeField)columnField.right;
            return RexGraphVariable.of(aliasField.getIndex(), (Integer)columnField.left, aliasField.getName(), aliasField.getType());
        }
        return RexGraphVariableList.of(columnFields.stream().map(field -> RexGraphVariable.of(((RelDataTypeField)field.right).getIndex(), (Integer)field.left, AliasInference.SIMPLE_NAME(((RelDataTypeField)field.right).getName()), ((RelDataTypeField)field.right).getType())).collect(Collectors.toList()));
    }

    public RexGraphVariable variable(@Nullable String alias, String property) {
        alias = AliasInference.isDefaultAlias(alias) ? "_" : alias;
        Objects.requireNonNull(property);
        String varName = AliasInference.SIMPLE_NAME(alias) + "." + property;
        List<ColumnField> columnFields = this.getAliasField(alias);
        if (columnFields.size() != 1) {
            throw new FrontendException(Code.PROPERTY_NOT_FOUND, "cannot get property=" + property + " from alias=" + alias + ", expected one column, but found " + columnFields.size());
        }
        ColumnField columnField = columnFields.get(0);
        RelDataTypeField aliasField = (RelDataTypeField)columnField.right;
        if (property.equals("~len")) {
            if (!(aliasField.getType() instanceof GraphPathType)) {
                throw new FrontendException(Code.PROPERTY_NOT_FOUND, "cannot get property='len' from type class [" + aliasField.getType().getClass() + "], should be [" + GraphPathType.class + "]");
            }
            return RexGraphVariable.of(aliasField.getIndex(), new GraphProperty(GraphProperty.Opt.LEN), (Integer)columnField.left, varName, this.getTypeFactory().createSqlType(SqlTypeName.INTEGER));
        }
        if (!(aliasField.getType() instanceof GraphSchemaType)) {
            throw new FrontendException(Code.PROPERTY_NOT_FOUND, "cannot get property=['id', 'label', 'all', 'key'] from type class [" + aliasField.getType().getClass() + "], should be [" + GraphSchemaType.class + "]");
        }
        if (property.equals("~label")) {
            GraphSchemaType schemaType = (GraphSchemaType)aliasField.getType();
            return RexGraphVariable.of(aliasField.getIndex(), new GraphProperty(GraphProperty.Opt.LABEL), (Integer)columnField.left, varName, (RelDataType)schemaType.getLabelType());
        }
        if (property.equals("~id")) {
            return RexGraphVariable.of(aliasField.getIndex(), new GraphProperty(GraphProperty.Opt.ID), (Integer)columnField.left, varName, this.getTypeFactory().createSqlType(SqlTypeName.BIGINT));
        }
        if (property.equals("~all")) {
            return RexGraphVariable.of(aliasField.getIndex(), new GraphProperty(GraphProperty.Opt.ALL), (Integer)columnField.left, varName, this.getTypeFactory().createSqlType(SqlTypeName.ANY));
        }
        if (property.equals("~start_v")) {
            if (!(aliasField.getType() instanceof GraphPathType)) {
                throw new FrontendException(Code.PROPERTY_NOT_FOUND, "cannot get property='start_v' from type class [" + aliasField.getType().getClass() + "], should be [" + GraphPathType.class + "]");
            }
            Preconditions.checkArgument((this.size() > 0 ? 1 : 0) != 0, (Object)"frame stack is empty");
            RelNode peek = this.peek();
            Preconditions.checkArgument((peek != null && !peek.getInputs().isEmpty() ? 1 : 0) != 0, (Object)"path expand should have start vertex");
            RelNode input = peek.getInput(0);
            return RexGraphVariable.of(aliasField.getIndex(), new GraphProperty(GraphProperty.Opt.START_V), (Integer)columnField.left, varName, ((RelDataTypeField)input.getRowType().getFieldList().get(0)).getType());
        }
        if (property.equals("~end_v")) {
            if (!(aliasField.getType() instanceof GraphPathType)) {
                throw new FrontendException(Code.PROPERTY_NOT_FOUND, "cannot get property='end_v' from type class [" + aliasField.getType().getClass() + "], should be [" + GraphPathType.class + "]");
            }
            GraphPathType pathType = (GraphPathType)aliasField.getType();
            return RexGraphVariable.of(aliasField.getIndex(), new GraphProperty(GraphProperty.Opt.END_V), (Integer)columnField.left, varName, pathType.getComponentType().getGetVType());
        }
        GraphSchemaType graphType = (GraphSchemaType)aliasField.getType();
        ArrayList<String> properties = new ArrayList<String>();
        boolean isColumnId = this.relOptSchema instanceof GraphOptSchema ? ((GraphOptSchema)this.relOptSchema).getRootSchema().isColumnId() : false;
        for (RelDataTypeField pField : graphType.getFieldList()) {
            if (pField.getName().equals(property)) {
                return RexGraphVariable.of(aliasField.getIndex(), isColumnId ? new GraphProperty(new GraphNameOrId(pField.getIndex())) : new GraphProperty(new GraphNameOrId(pField.getName())), (Integer)columnField.left, varName, pField.getType());
            }
            properties.add(pField.getName());
        }
        throw new FrontendException(Code.PROPERTY_NOT_FOUND, "{property=" + property + "} not found; expected properties are: " + properties);
    }

    private List<ColumnField> getAliasField(String alias) {
        Objects.requireNonNull(alias);
        if (alias.equals("*")) {
            RelNode peek = Objects.requireNonNull(this.peek(), "frame stack is empty");
            RelDataType outputType = Utils.getOutputType(peek);
            return outputType.getFieldList().stream().map(field -> {
                int columnIdx = AliasInference.isDefaultAlias(field.getName()) ? 100 : this.getColumnIndex(peek, (RelDataTypeField)field);
                return new ColumnField(columnIdx, (RelDataTypeField)field);
            }).collect(Collectors.toList());
        }
        HashSet<String> aliases = new HashSet<String>();
        int nodeIdx = 0;
        block0: for (int inputOrdinal = 0; inputOrdinal < this.size(); ++inputOrdinal) {
            ArrayList inputQueue = Lists.newArrayList((Object[])new RelNode[]{this.peek(inputOrdinal)});
            while (!inputQueue.isEmpty()) {
                RelNode cur = (RelNode)inputQueue.remove(0);
                List fields = cur.getRowType().getFieldList();
                if (nodeIdx++ == 0 && AliasInference.isDefaultAlias(alias)) {
                    if (fields.size() == 1) {
                        return ImmutableList.of((Object)((Object)new ColumnField(100, (RelDataTypeField)new RelDataTypeFieldImpl("_", -1, ((RelDataTypeField)fields.get(0)).getType()))));
                    }
                    if (cur instanceof CommonTableScan) {
                        return ImmutableList.of((Object)((Object)new ColumnField(100, (RelDataTypeField)new RelDataTypeFieldImpl("_", -1, ((RelDataTypeField)fields.get(fields.size() - 1)).getType()))));
                    }
                    return fields.stream().map(field -> new ColumnField(this.getColumnIndex(cur, (RelDataTypeField)field), (RelDataTypeField)field)).collect(Collectors.toList());
                }
                for (RelDataTypeField field2 : fields) {
                    if (!AliasInference.isDefaultAlias(alias) && field2.getName().equals(alias)) {
                        return ImmutableList.of((Object)((Object)new ColumnField(this.getColumnIndex(cur, field2), field2)));
                    }
                    aliases.add(AliasInference.SIMPLE_NAME(field2.getName()));
                }
                if (AliasInference.removeAlias(cur)) continue block0;
                inputQueue.addAll(cur.getInputs());
            }
        }
        throw new FrontendException(Code.TAG_NOT_FOUND, "{alias=" + AliasInference.SIMPLE_NAME(alias) + "} not found; expected aliases are: " + aliases);
    }

    private int getColumnIndex(RelNode node, RelDataTypeField field) {
        HashSet uniqueFieldNames = Sets.newHashSet();
        if (!this.visitField(node, field, uniqueFieldNames)) {
            throw new IllegalArgumentException("field " + field + " not found in node" + node);
        }
        return uniqueFieldNames.size();
    }

    private boolean visitField(RelNode topNode, RelDataTypeField targetField, Set<String> uniqueFieldNames) {
        if (!(AliasInference.removeAlias(topNode) || topNode instanceof Join || topNode instanceof AbstractLogicalMatch)) {
            for (RelNode child : topNode.getInputs()) {
                if (!this.visitField(child, targetField, uniqueFieldNames)) continue;
                return true;
            }
        }
        List fields = topNode.getRowType().getFieldList();
        for (RelDataTypeField field : fields) {
            if (!AliasInference.isDefaultAlias(field.getName()) && field.equals(targetField)) {
                return true;
            }
            if (AliasInference.isDefaultAlias(field.getName()) || uniqueFieldNames.contains(field.getName())) continue;
            uniqueFieldNames.add(field.getName());
        }
        return false;
    }

    public RexNode call(SqlOperator operator, RexNode ... operands) {
        return this.call_(operator, (List<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RexNode procedureCall(SqlOperator operator, Iterable<? extends RexNode> operands, StoredProcedureMeta procedureMeta) {
        RexCall call = (RexCall)this.call(operator, operands);
        return new RexProcedureCall(call.getType(), call.getOperator(), call.getOperands(), procedureMeta);
    }

    public RexNode call(SqlOperator operator, Iterable<? extends RexNode> operands) {
        return this.call_(operator, (List<RexNode>)ImmutableList.copyOf(operands));
    }

    private RexNode call_(SqlOperator operator, List<RexNode> operandList) {
        if (!this.isCurrentSupported(operator)) {
            throw new UnsupportedOperationException("operator " + operator.getKind().name() + " not supported");
        }
        if (operator.getOperandTypeInference() != GraphInferTypes.RETURN_TYPE) {
            operandList = this.inferOperandTypes(operator, this.getTypeFactory().createUnknownType(), operandList);
        }
        RexCallBinding callBinding = new RexCallBinding(this.getTypeFactory(), operator, operandList, (List<RelCollation>)ImmutableList.of());
        operator.validRexOperands(callBinding.getOperandCount(), Litmus.THROW);
        operator.checkOperandTypes((SqlCallBinding)callBinding, true);
        RelDataType returnType = operator.inferReturnType((SqlOperatorBinding)callBinding);
        operandList = this.inferOperandTypes(operator, returnType, this.convertOperands(operator, operandList));
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        if (operator.getKind() == SqlKind.OTHER && operator.getName().equals("IN")) {
            return rexBuilder.makeIn(operandList.get(0), operandList.subList(1, operandList.size()));
        }
        return rexBuilder.makeCall(returnType, operator, operandList);
    }

    private List<RexNode> convertOperands(SqlOperator operator, List<RexNode> operandList) {
        RexNode intervalOperand;
        if (operator.getKind() == SqlKind.EXTRACT && (intervalOperand = operandList.get(0)) instanceof RexLiteral && ((RexLiteral)intervalOperand).isNull() && intervalOperand.getType() instanceof IntervalSqlType) {
            IntervalSqlType intervalType = (IntervalSqlType)intervalOperand.getType();
            ArrayList newOperands = Lists.newArrayList();
            newOperands.add(this.getRexBuilder().makeFlag((Enum)intervalType.getIntervalQualifier().getStartUnit()));
            newOperands.add(operandList.get(1));
            return newOperands;
        }
        return operandList;
    }

    private List<RexNode> inferOperandTypes(SqlOperator operator, RelDataType returnType, List<RexNode> operandList) {
        if (operator.getOperandTypeInference() != null && operandList.stream().anyMatch(t -> t.getType().getSqlTypeName() == SqlTypeName.UNKNOWN)) {
            RexCallBinding callBinding = new RexCallBinding(this.getTypeFactory(), operator, operandList, (List<RelCollation>)ImmutableList.of());
            RelDataType[] newTypes = callBinding.collectOperandTypes().toArray(new RelDataType[0]);
            operator.getOperandTypeInference().inferOperandTypes((SqlCallBinding)callBinding, returnType, newTypes);
            ArrayList<RexNode> typeInferredOperands = new ArrayList<RexNode>(operandList.size());
            GraphRexBuilder rexBuilder = (GraphRexBuilder)this.getRexBuilder();
            for (int i = 0; i < operandList.size(); ++i) {
                Object rexNode = operandList.get(i);
                if (rexNode instanceof RexGraphDynamicParam) {
                    RexGraphDynamicParam graphDynamicParam = (RexGraphDynamicParam)((Object)rexNode);
                    rexNode = rexBuilder.makeGraphDynamicParam(newTypes[i], graphDynamicParam.getName(), graphDynamicParam.getIndex());
                }
                typeInferredOperands.add((RexNode)rexNode);
            }
            return typeInferredOperands;
        }
        return operandList;
    }

    private boolean isCurrentSupported(SqlOperator operator) {
        SqlKind sqlKind = operator.getKind();
        return sqlKind.belongsTo((Collection)SqlKind.BINARY_ARITHMETIC) || sqlKind.belongsTo((Collection)SqlKind.COMPARISON) || sqlKind == SqlKind.AND || sqlKind == SqlKind.OR || sqlKind == SqlKind.DESCENDING || sqlKind == SqlKind.OTHER_FUNCTION && (operator.getName().equals("POWER") || operator.getName().equals("<<") || operator.getName().equals(">>")) || sqlKind == SqlKind.MINUS_PREFIX || sqlKind == SqlKind.CASE || sqlKind == SqlKind.PROCEDURE_CALL || sqlKind == SqlKind.NOT || sqlKind == SqlKind.ARRAY_VALUE_CONSTRUCTOR || sqlKind == SqlKind.MAP_VALUE_CONSTRUCTOR || sqlKind == SqlKind.IS_NULL || sqlKind == SqlKind.IS_NOT_NULL || sqlKind == SqlKind.EXTRACT || sqlKind == SqlKind.SEARCH || sqlKind == SqlKind.POSIX_REGEX_CASE_SENSITIVE || sqlKind == SqlKind.AS || sqlKind == SqlKind.BIT_AND || sqlKind == SqlKind.BIT_OR || sqlKind == SqlKind.BIT_XOR || sqlKind == SqlKind.OTHER && (operator.getName().equals("IN") || operator.getName().equals("DATETIME_MINUS") || operator.getName().equals("PATH_CONCAT") || operator.getName().equals("PATH_FUNCTION")) || operator.getName().startsWith("gs.function.") || sqlKind == SqlKind.ARRAY_CONCAT;
    }

    public GraphBuilder filter(RexNode ... conditions) {
        return this.filter((Iterable)ImmutableList.copyOf((Object[])conditions));
    }

    public GraphBuilder filter(Iterable<? extends RexNode> conditions) {
        conditions = this.flatExprs(conditions);
        RexPropertyChecker propertyChecker = new RexPropertyChecker(true, this);
        for (RexNode condition : conditions) {
            RelDataType type = condition.getType();
            if (!(type instanceof BasicSqlType) || type.getSqlTypeName() != SqlTypeName.BOOLEAN) {
                throw new IllegalArgumentException("filter condition " + condition + " should return Boolean value, but is " + type);
            }
            condition.accept((RexVisitor)propertyChecker);
        }
        RelDataTypeField recoverHead = null;
        RexSubQueryPreComputer preComputer = new RexSubQueryPreComputer(this);
        ArrayList newConditions = Lists.newArrayList();
        for (RexNode condition : conditions) {
            newConditions.add(preComputer.precompute(condition));
        }
        if (!preComputer.getSubQueryNodes().isEmpty()) {
            RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
            if (input.getRowType().getFieldList().size() == 1) {
                RelDataTypeField field = (RelDataTypeField)input.getRowType().getFieldList().get(0);
                if (field.getName() == "_") {
                    Set<String> uniqueAliases = AliasInference.getUniqueAliasList(input, true);
                    uniqueAliases.addAll(preComputer.getSubQueryAliases());
                    String nonDefault = AliasInference.inferAliasWithPrefix("$f", uniqueAliases);
                    this.as(nonDefault);
                    recoverHead = new RelDataTypeFieldImpl(nonDefault, this.generateAliasId(nonDefault), field.getType());
                } else {
                    recoverHead = field;
                }
            }
            this.project(preComputer.getSubQueryNodes(), preComputer.getSubQueryAliases(), true);
            conditions = newConditions.stream().map(k -> (RexNode)k.accept((RexVisitor)new RexTmpVariableConverter(true, this))).collect(Collectors.toList());
        }
        super.filter((Iterable)ImmutableSet.of(), conditions);
        Filter filter = this.topFilter();
        if (filter != null) {
            ArrayList extraFilters;
            AbstractLogicalMatch match;
            RelNode input;
            GraphBuilder builder = GraphBuilder.create(this.configs, (GraphOptCluster)this.getCluster(), this.getRelOptSchema());
            RexNode condition = filter.getCondition();
            RelNode relNode = input = !filter.getInputs().isEmpty() ? filter.getInput(0) : null;
            if (input instanceof AbstractBindableTableScan) {
                AbstractBindableTableScan tableScan = (AbstractBindableTableScan)input;
                List aliasIds = (List)condition.accept(new RexVariableAliasCollector<Integer>(true, RexGraphVariable::getAliasId));
                if (!aliasIds.isEmpty() && ImmutableList.of((Object)-1, (Object)tableScan.getAliasId()).containsAll((Collection)aliasIds)) {
                    condition = (RexNode)condition.accept((RexVisitor)new RexVariableAliasConverter(true, this, AliasInference.SIMPLE_NAME("_"), -1));
                    this.replaceTop((RelNode)this.fuseFilters(tableScan, condition, builder));
                }
            } else if (input instanceof AbstractLogicalMatch && !(match = this.fuseFilters((AbstractLogicalMatch)input, condition, extraFilters = Lists.newArrayList(), builder)).equals(input)) {
                if (extraFilters.isEmpty()) {
                    this.replaceTop((RelNode)match);
                } else {
                    this.replaceTop(builder.push((RelNode)match).filter((Iterable)extraFilters).build());
                }
            }
        }
        if (recoverHead != null) {
            this.project((Iterable)ImmutableList.of((Object)((Object)this.variable(recoverHead.getName()))), (Iterable)ImmutableList.of(), true);
        }
        return this;
    }

    private AbstractBindableTableScan fuseFilters(AbstractBindableTableScan tableScan, RexNode condition, GraphBuilder builder) {
        RexFilterClassifier classifier = new RexFilterClassifier(builder, tableScan);
        ClassifiedFilter filterResult = classifier.classify(condition);
        List<Comparable> labelValues = filterResult.getLabelValues();
        ArrayList uniqueKeyFilters = Lists.newArrayList(filterResult.getUniqueKeyFilters());
        ArrayList extraFilters = Lists.newArrayList(filterResult.getExtraFilters());
        if (!labelValues.isEmpty()) {
            GraphLabelType labelType = ((GraphSchemaType)((RelDataTypeField)tableScan.getRowType().getFieldList().get(0)).getType()).getLabelType();
            List<String> labelsToKeep = labelType.getLabelsEntry().stream().filter((? super T k) -> labelValues.contains(k.getLabel())).map(k -> k.getLabel()).collect(Collectors.toList());
            Preconditions.checkArgument((!labelsToKeep.isEmpty() ? 1 : 0) != 0, (String)("cannot find common labels between values= " + labelValues + " and label="), (Object)((Object)labelType));
            if (labelsToKeep.size() < labelType.getLabelsEntry().size()) {
                LabelConfig newLabelConfig = new LabelConfig(false);
                labelsToKeep.forEach(k -> newLabelConfig.addLabel((String)k));
                if (tableScan instanceof GraphLogicalSource) {
                    builder.source(new SourceConfig(((GraphLogicalSource)tableScan).getOpt(), newLabelConfig, tableScan.getAliasName()));
                } else if (tableScan instanceof GraphLogicalExpand) {
                    builder.push(tableScan.getInput(0)).expand(new ExpandConfig(((GraphLogicalExpand)tableScan).getOpt(), newLabelConfig, tableScan.getAliasName()));
                } else if (tableScan instanceof GraphLogicalGetV) {
                    builder.push(tableScan.getInput(0)).getV(new GetVConfig(((GraphLogicalGetV)tableScan).getOpt(), newLabelConfig, tableScan.getAliasName()));
                }
                if (builder.size() > 0) {
                    ImmutableList<RexNode> originalFilters;
                    RexPropertyChecker propertyChecker = new RexPropertyChecker(true, builder);
                    if (tableScan instanceof GraphLogicalSource) {
                        RexNode originalUniqueKeyFilters = ((GraphLogicalSource)tableScan).getUniqueKeyFilters();
                        if (originalUniqueKeyFilters != null) {
                            originalUniqueKeyFilters.accept((RexVisitor)propertyChecker);
                            builder.filter(originalUniqueKeyFilters);
                        }
                        if (!uniqueKeyFilters.isEmpty()) {
                            builder.filter((Iterable)uniqueKeyFilters);
                            uniqueKeyFilters.clear();
                        }
                    }
                    if (ObjectUtils.isNotEmpty(originalFilters = tableScan.getFilters())) {
                        originalFilters.forEach(arg_0 -> GraphBuilder.lambda$fuseFilters$13((RexVisitor)propertyChecker, arg_0));
                        builder.filter((Iterable)originalFilters);
                    }
                    if (!extraFilters.isEmpty()) {
                        extraFilters.forEach(arg_0 -> GraphBuilder.lambda$fuseFilters$14((RexVisitor)propertyChecker, arg_0));
                        builder.filter((Iterable)extraFilters);
                        extraFilters.clear();
                    }
                    tableScan = (AbstractBindableTableScan)builder.build();
                }
            }
        }
        if (tableScan instanceof GraphLogicalSource && !uniqueKeyFilters.isEmpty()) {
            GraphLogicalSource source = (GraphLogicalSource)tableScan;
            if (source.getUniqueKeyFilters() != null || uniqueKeyFilters.size() > 1) {
                extraFilters.addAll(uniqueKeyFilters);
            } else {
                source.setUniqueKeyFilters((RexNode)uniqueKeyFilters.get(0));
            }
        }
        if (!extraFilters.isEmpty()) {
            ImmutableList<RexNode> originalFilters = tableScan.getFilters();
            if (ObjectUtils.isNotEmpty(originalFilters)) {
                for (int i = 0; i < originalFilters.size(); ++i) {
                    extraFilters.add(i, (RexNode)originalFilters.get(i));
                }
            }
            tableScan.setFilters((ImmutableList<RexNode>)ImmutableList.of((Object)RexUtil.composeConjunction((RexBuilder)this.getRexBuilder(), (Iterable)extraFilters)));
        }
        return tableScan;
    }

    private AbstractLogicalMatch fuseFilters(AbstractLogicalMatch match, RexNode condition, List<RexNode> extraFilters, GraphBuilder builder) {
        RexFilterClassifier classifier = new RexFilterClassifier(builder, null);
        ClassifiedFilter filter = classifier.classify(condition);
        List<RexNode> labelFilters = filter.getLabelFilters();
        extraFilters.addAll(filter.getExtraFilters());
        for (RexNode labelFilter : labelFilters) {
            PushFilterVisitor visitor = new PushFilterVisitor(builder, labelFilter);
            match = (AbstractLogicalMatch)match.accept((RelShuttle)visitor);
            if (visitor.isPushed()) continue;
            extraFilters.add(labelFilter);
        }
        return match;
    }

    private Filter topFilter() {
        if (this.size() > 0 && this.peek() instanceof Filter) {
            return (Filter)this.peek();
        }
        return null;
    }

    public GraphBuilder project(RexNode ... nodes) {
        return this.project((Iterable)ImmutableList.copyOf((Object[])nodes));
    }

    public GraphBuilder project(Iterable<? extends RexNode> nodes) {
        return this.project((Iterable)nodes, (Iterable)ImmutableList.of());
    }

    public GraphBuilder project(Iterable<? extends RexNode> nodes, Iterable<? extends @Nullable String> fieldNames) {
        return this.project((Iterable)nodes, (Iterable)fieldNames, false);
    }

    public GraphBuilder project(Iterable<? extends RexNode> nodes, Iterable<? extends @Nullable String> aliases, boolean isAppend) {
        RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        RelBuilder.Config config = (RelBuilder.Config)com.alibaba.graphscope.gremlin.Utils.getFieldValue(RelBuilder.class, (Object)this, "config");
        RexSimplify simplifier = (RexSimplify)com.alibaba.graphscope.gremlin.Utils.getFieldValue(RelBuilder.class, (Object)this, "simplifier");
        nodes = this.flatExprs(nodes);
        List<Object> nodeList = Lists.newArrayList(nodes);
        List<@Nullable Object> fieldNameList = Lists.newArrayList(aliases);
        if (config.simplify()) {
            for (int i = 0; i < nodeList.size(); ++i) {
                nodeList.set(i, simplifier.simplifyPreservingType((RexNode)nodeList.get(i)));
            }
        }
        RexSubQueryPreComputer preComputer = new RexSubQueryPreComputer(this);
        ArrayList newNodeList = Lists.newArrayList();
        for (RexNode node : nodeList) {
            newNodeList.add(preComputer.precompute(node));
        }
        if (!preComputer.getSubQueryNodes().isEmpty()) {
            this.project(preComputer.getSubQueryNodes(), preComputer.getSubQueryAliases(), true);
            nodeList = newNodeList.stream().map(k -> (RexNode)k.accept((RexVisitor)new RexTmpVariableConverter(true, this))).collect(Collectors.toList());
            input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        }
        if (this.projectOneTag(nodeList, fieldNameList, isAppend) != null) {
            fieldNameList = ImmutableList.of((Object)"_");
        } else {
            AliasNameWithId defaultAlias;
            ArrayList inputTags;
            AliasNameWithId inputOneTag;
            if (input instanceof Project && (inputOneTag = this.projectOneTag(((Project)input).getProjects(), input.getRowType().getFieldNames(), ((GraphLogicalProject)input).isAppend())) != null && this.projectPropertyOfTags(nodeList, inputTags = Lists.newArrayList((Object[])new AliasNameWithId[]{inputOneTag, defaultAlias = new AliasNameWithId("_", -1)}))) {
                inputTags.removeAll(Lists.newArrayList((Object[])new AliasNameWithId[]{defaultAlias}));
                if (inputTags.size() == 1) {
                    RexVariableAliasConverter converter = new RexVariableAliasConverter(true, this, ((AliasNameWithId)inputTags.get(0)).getAliasName(), ((AliasNameWithId)inputTags.get(0)).getAliasId());
                    nodeList = nodeList.stream().map(k -> (RexNode)k.accept((RexVisitor)converter)).collect(Collectors.toList());
                }
                input = input.getInput(0);
            }
            fieldNameList = AliasInference.inferProject(nodeList, fieldNameList, AliasInference.getUniqueAliasList(input, isAppend));
        }
        GraphLogicalProject project = GraphLogicalProject.create((GraphOptCluster)this.getCluster(), (List<RelHint>)ImmutableList.of(), input, nodeList, this.deriveType(nodeList, fieldNameList, input, isAppend), isAppend);
        this.replaceTop((RelNode)project);
        return this;
    }

    private @Nullable AliasNameWithId projectOneTag(List<RexNode> exprs, List<String> aliases, boolean isAppend) {
        if (isAppend && exprs.size() == 1 && exprs.get(0) instanceof RexGraphVariable && ((RexGraphVariable)exprs.get(0)).getProperty() == null && (aliases.isEmpty() || AliasInference.isDefaultAlias(aliases.get(0)))) {
            RexVariableAliasCollector<AliasNameWithId> collector = new RexVariableAliasCollector<AliasNameWithId>(true, var -> {
                String[] splits = var.getName().split(Pattern.quote("."));
                String aliasName = splits.length > 0 ? splits[0] : "_";
                return new AliasNameWithId(aliasName, var.getAliasId());
            });
            return (AliasNameWithId)((List)exprs.get(0).accept(collector)).get(0);
        }
        return null;
    }

    private boolean projectPropertyOfTags(List<RexNode> exprs, List<AliasNameWithId> tags) {
        List tagIds = tags.stream().map(k -> k.getAliasId()).collect(Collectors.toList());
        RexVariableAliasCollector<Integer> collector = new RexVariableAliasCollector<Integer>(true, var -> var.getAliasId());
        return exprs.stream().allMatch(k -> tagIds.containsAll((Collection)k.accept((RexVisitor)collector)));
    }

    private RelDataType deriveType(List<RexNode> nodeList, List<String> aliasList, @Nullable RelNode input, boolean isAppend) {
        assert (nodeList.size() == aliasList.size());
        ArrayList fields = Lists.newArrayList();
        for (int i = 0; i < aliasList.size(); ++i) {
            String aliasName = aliasList.get(i);
            fields.add(new RelDataTypeFieldImpl(aliasName, this.generateAliasId(aliasName), nodeList.get(i).getType()));
        }
        return new RelRecordType(StructKind.FULLY_QUALIFIED, (List)fields);
    }

    public RelBuilder.GroupKey groupKey() {
        return this.groupKey_((List<RexNode>)ImmutableList.of(), (List<String>)ImmutableList.of());
    }

    public RelBuilder.GroupKey groupKey(RexNode ... variables) {
        return this.groupKey_((List<RexNode>)ImmutableList.copyOf((Object[])variables), (List<String>)ImmutableList.of());
    }

    public RelBuilder.GroupKey groupKey(Iterable<? extends RexNode> variables) {
        return this.groupKey_((List<RexNode>)ImmutableList.copyOf(variables), (List<String>)ImmutableList.of());
    }

    public RelBuilder.GroupKey groupKey(List<RexNode> variables, List<@Nullable String> aliases) {
        return this.groupKey_(variables, aliases);
    }

    private RelBuilder.GroupKey groupKey_(List<RexNode> variables, List<@Nullable String> aliases) {
        return new GraphGroupKeys((List)this.flatExprs(variables), aliases);
    }

    public RelBuilder.AggCall collect(boolean distinct, @Nullable String alias, RexNode ... operands) {
        return this.aggregateCall(GraphStdOperatorTable.COLLECT, distinct, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.copyOf((Object[])operands));
    }

    public RelBuilder.AggCall collect(boolean distinct, @Nullable String alias, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(GraphStdOperatorTable.COLLECT, distinct, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.copyOf(operands));
    }

    public RelBuilder.AggCall collect(RexNode ... operands) {
        return this.collect(false, null, operands);
    }

    public RelBuilder.AggCall collect(Iterable<? extends RexNode> operands) {
        return this.collect(false, null, operands);
    }

    public RelBuilder.AggCall sum0(RexNode operand) {
        return this.sum(false, null, operand);
    }

    public RelBuilder.AggCall sum0(boolean distinct, @Nullable String alias, RexNode operand) {
        return this.aggregateCall(GraphStdOperatorTable.SUM0, distinct, false, false, null, null, (ImmutableList<RexNode>)ImmutableList.of(), alias, (ImmutableList<RexNode>)ImmutableList.of((Object)operand));
    }

    protected RelBuilder.AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, @Nullable RexNode filter, @Nullable ImmutableList<RexNode> distinctKeys, ImmutableList<RexNode> orderKeys, @Nullable String alias, ImmutableList<RexNode> operands) {
        if (operands.isEmpty()) {
            operands = ImmutableList.of((Object)((Object)this.variable("*")));
        }
        operands = ImmutableList.copyOf(this.flatExprs((Iterable<RexNode>)operands));
        return new GraphAggCall(this.getCluster(), aggFunction, (List<RexNode>)operands).as(alias).distinct(distinct);
    }

    public GraphBuilder aggregate(RelBuilder.GroupKey groupKey, Iterable<RelBuilder.AggCall> aggCalls) {
        Objects.requireNonNull(groupKey);
        Objects.requireNonNull(aggCalls);
        RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        Registrar registrar = new Registrar(this, input, true);
        List<RexNode> registerKeys = registrar.registerExpressions(((GraphGroupKeys)groupKey).getVariables());
        ArrayList<List<RexNode>> registerCallsList = new ArrayList<List<RexNode>>();
        for (RelBuilder.AggCall call : aggCalls) {
            registerCallsList.add(registrar.registerExpressions(((GraphAggCall)call).getOperands()));
        }
        ArrayList<GraphAggCall> aggCallList = new ArrayList<GraphAggCall>();
        if (!registrar.getExtraNodes().isEmpty()) {
            this.project(registrar.getExtraNodes(), registrar.getExtraAliases(), registrar.isAppend());
            Object converter = new RexTmpVariableConverter(true, this);
            groupKey = new GraphGroupKeys(registerKeys.stream().map(k -> (RexNode)k.accept((RexVisitor)converter)).collect(Collectors.toList()), ((GraphGroupKeys)groupKey).getAliases());
            int i = 0;
            for (RelBuilder.AggCall call : aggCalls) {
                GraphAggCall call1 = (GraphAggCall)call;
                aggCallList.add(new GraphAggCall(call1.getCluster(), call1.getAggFunction(), ((List)registerCallsList.get(i)).stream().map(k -> (RexNode)k.accept((RexVisitor)converter)).collect(Collectors.toList())).as(call1.getAlias()).distinct(call1.isDistinct()));
                ++i;
            }
            input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        } else {
            for (RelBuilder.AggCall aggCall : aggCalls) {
                aggCallList.add((GraphAggCall)aggCall);
            }
        }
        GraphLogicalAggregate aggregate = GraphLogicalAggregate.create((GraphOptCluster)this.getCluster(), (List<RelHint>)ImmutableList.of(), input, (GraphGroupKeys)groupKey, aggCallList);
        this.replaceTop((RelNode)aggregate);
        return this;
    }

    public GraphBuilder sortLimit(@Nullable RexNode offsetNode, @Nullable RexNode fetchNode, Iterable<? extends RexNode> nodes) {
        if (offsetNode != null && !(offsetNode instanceof RexLiteral)) {
            throw new IllegalArgumentException("OFFSET node must be RexLiteral");
        }
        if (offsetNode != null && !(offsetNode instanceof RexLiteral)) {
            throw new IllegalArgumentException("FETCH node must be RexLiteral");
        }
        nodes = this.flatExprs(nodes);
        RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        List originalFields = input.getRowType().getFieldList();
        Registrar registrar = new Registrar(this, input, true);
        List<Object> registerNodes = registrar.registerExpressions((List<RexNode>)ImmutableList.copyOf(nodes));
        if (!registrar.getExtraNodes().isEmpty()) {
            RelDataTypeField field;
            if (input.getRowType().getFieldList().size() == 1 && (field = (RelDataTypeField)input.getRowType().getFieldList().get(0)).getName() == "_") {
                Set<String> uniqueAliases = AliasInference.getUniqueAliasList(input, true);
                uniqueAliases.addAll(registrar.getExtraAliases());
                String nonDefault = AliasInference.inferAliasWithPrefix("$f", uniqueAliases);
                this.as(nonDefault);
                originalFields = Lists.newArrayList((Object[])new RelDataTypeField[]{new RelDataTypeFieldImpl(nonDefault, this.generateAliasId(nonDefault), field.getType())});
            }
            this.project(registrar.getExtraNodes(), registrar.getExtraAliases(), registrar.isAppend());
            RexTmpVariableConverter converter = new RexTmpVariableConverter(true, this);
            registerNodes = registerNodes.stream().map(k -> (RexNode)k.accept((RexVisitor)converter)).collect(Collectors.toList());
            input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        }
        List<RelFieldCollation> fieldCollations = this.fieldCollations(registerNodes);
        RelBuilder.Config config = (RelBuilder.Config)com.alibaba.graphscope.gremlin.Utils.getFieldValue(RelBuilder.class, (Object)this, "config");
        if (fetchNode != null && RexLiteral.intValue((RexNode)fetchNode) == 0 && config.simplifyLimit()) {
            return (GraphBuilder)this.empty();
        }
        if (offsetNode == null && fetchNode == null && fieldCollations.isEmpty()) {
            return this;
        }
        if (fieldCollations.isEmpty()) {
            Project project;
            if (input instanceof Sort) {
                Sort sort2 = (Sort)input;
                if (sort2.offset == null && sort2.fetch == null) {
                    GraphLogicalSort sort = GraphLogicalSort.create(sort2.getInput(), sort2.collation, offsetNode, fetchNode);
                    this.replaceTop((RelNode)sort);
                    return this;
                }
            }
            if (input instanceof Project && (project = (Project)input).getInput() instanceof Sort) {
                Sort sort2 = (Sort)project.getInput();
                if (sort2.offset == null && sort2.fetch == null) {
                    GraphLogicalSort sort = GraphLogicalSort.create(sort2.getInput(), sort2.collation, offsetNode, fetchNode);
                    this.replaceTop((RelNode)GraphLogicalProject.create((GraphOptCluster)project.getCluster(), (List<RelHint>)project.getHints(), (RelNode)sort, project.getProjects(), project.getRowType(), ((GraphLogicalProject)project).isAppend()));
                    return this;
                }
            }
        }
        GraphLogicalSort sort = GraphLogicalSort.create(input, GraphRelCollations.of(fieldCollations), offsetNode, fetchNode);
        this.replaceTop((RelNode)sort);
        if (!registrar.getExtraAliases().isEmpty()) {
            ArrayList<RexGraphVariable> originalExprs = new ArrayList<RexGraphVariable>();
            ArrayList<String> originalAliases = new ArrayList<String>();
            for (RelDataTypeField field : originalFields) {
                originalExprs.add(this.variable(field.getName()));
                originalAliases.add(field.getName());
            }
            this.project(originalExprs, originalAliases, false);
        }
        return this;
    }

    public GraphBuilder dedupBy(Iterable<? extends RexNode> nodes) {
        RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        nodes = this.flatExprs(nodes);
        List originalFields = input.getRowType().getFieldList();
        Registrar registrar = new Registrar(this, input, true);
        List<Object> registerNodes = registrar.registerExpressions((List<RexNode>)ImmutableList.copyOf(nodes));
        if (!registrar.getExtraNodes().isEmpty()) {
            RelDataTypeField field;
            if (input.getRowType().getFieldList().size() == 1 && (field = (RelDataTypeField)input.getRowType().getFieldList().get(0)).getName() == "_") {
                Set<String> uniqueAliases = AliasInference.getUniqueAliasList(input, true);
                uniqueAliases.addAll(registrar.getExtraAliases());
                String nonDefault = AliasInference.inferAliasWithPrefix("$f", uniqueAliases);
                this.as(nonDefault);
                originalFields = Lists.newArrayList((Object[])new RelDataTypeField[]{new RelDataTypeFieldImpl(nonDefault, this.generateAliasId(nonDefault), field.getType())});
            }
            this.project(registrar.getExtraNodes(), registrar.getExtraAliases(), registrar.isAppend());
            RexTmpVariableConverter converter = new RexTmpVariableConverter(true, this);
            registerNodes = registerNodes.stream().map(k -> (RexNode)k.accept((RexVisitor)converter)).collect(Collectors.toList());
            input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        }
        if (registerNodes.isEmpty()) {
            registerNodes.add((RexNode)this.variable(null));
        }
        GraphLogicalDedupBy dedupBy = GraphLogicalDedupBy.create((GraphOptCluster)this.getCluster(), input, registerNodes);
        this.replaceTop((RelNode)dedupBy);
        if (!registrar.getExtraAliases().isEmpty()) {
            ArrayList<RexGraphVariable> originalExprs = new ArrayList<RexGraphVariable>();
            ArrayList<String> originalAliases = new ArrayList<String>();
            for (RelDataTypeField field : originalFields) {
                originalExprs.add(this.variable(field.getName()));
                originalAliases.add(field.getName());
            }
            this.project(originalExprs, originalAliases, false);
        }
        return this;
    }

    public GraphBuilder unfold(RexNode unfoldKey, @Nullable String aliasName) {
        RelNode input = Objects.requireNonNull(this.peek(), "frame stack is empty");
        RelDataType keyType = unfoldKey.getType();
        Preconditions.checkArgument((keyType.getComponentType() != null ? 1 : 0) != 0, (String)"input type of 'unfold' should be set or array with single component type, but is [%s]", (Object)keyType);
        GraphLogicalUnfold unfold = new GraphLogicalUnfold((GraphOptCluster)this.getCluster(), input, unfoldKey, aliasName);
        this.replaceTop((RelNode)unfold);
        return this;
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition, Set<CorrelationId> variablesSet) {
        Join join = (Join)super.join(joinType, condition, variablesSet).peek();
        com.alibaba.graphscope.gremlin.Utils.setFieldValue(AbstractRelNode.class, join, "rowType", this.reorgAliasId(join));
        return this;
    }

    public RelBuilder antiJoin(Iterable<? extends RexNode> conditions) {
        Join join = (Join)super.antiJoin(conditions).peek();
        com.alibaba.graphscope.gremlin.Utils.setFieldValue(AbstractRelNode.class, join, "rowType", this.reorgAliasId(join));
        return this;
    }

    private RelDataType reorgAliasId(Join join) {
        RelDataType originalType = join.getRowType();
        RelDataType leftType = join.getLeft().getRowType();
        RelDataType rightType = join.getRight().getRowType();
        List newFields = originalType.getFieldList().stream().map(k -> {
            if (k.getIndex() < leftType.getFieldCount()) {
                RelDataTypeField leftField = (RelDataTypeField)leftType.getFieldList().get(k.getIndex());
                return new RelDataTypeFieldImpl(k.getName(), leftField.getIndex(), k.getType());
            }
            RelDataTypeField rightField = (RelDataTypeField)rightType.getFieldList().get(k.getIndex() - leftType.getFieldCount());
            return new RelDataTypeFieldImpl(k.getName(), rightField.getIndex(), k.getType());
        }).collect(Collectors.toList());
        return new RelRecordType(StructKind.FULLY_QUALIFIED, newFields);
    }

    public RexLiteral literal(@Nullable Object value) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        if (value == null) {
            RelDataType type = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
            return rexBuilder.makeNullLiteral(type);
        }
        if (value instanceof Boolean) {
            return rexBuilder.makeLiteral(((Boolean)value).booleanValue());
        }
        if (value instanceof BigDecimal) {
            return rexBuilder.makeExactLiteral((BigDecimal)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Long) {
            return rexBuilder.makeBigintLiteral(BigDecimal.valueOf(((Number)value).longValue()));
        }
        if (value instanceof Number) {
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(((Number)value).longValue()));
        }
        if (value instanceof String) {
            return rexBuilder.makeLiteral((String)value);
        }
        if (value instanceof Enum) {
            return rexBuilder.makeLiteral(value, this.getTypeFactory().createSqlType(SqlTypeName.SYMBOL));
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to a constant");
    }

    private List<RelFieldCollation> fieldCollations(Iterable<? extends RexNode> nodes) {
        Objects.requireNonNull(nodes);
        Iterator<? extends RexNode> iterator = nodes.iterator();
        ArrayList<RelFieldCollation> collations = new ArrayList<RelFieldCollation>();
        while (iterator.hasNext()) {
            collations.add(this.fieldCollation(iterator.next(), RelFieldCollation.Direction.ASCENDING));
        }
        return collations;
    }

    private RelFieldCollation fieldCollation(RexNode node, RelFieldCollation.Direction direction) {
        if (node instanceof RexGraphVariable) {
            return new GraphFieldCollation((RexGraphVariable)node, direction);
        }
        switch (node.getKind()) {
            case DESCENDING: {
                return this.fieldCollation((RexNode)((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING);
            }
        }
        throw new UnsupportedOperationException("type " + node.getType() + " can not be converted to collation");
    }

    protected void pop() {
        this.build();
    }

    protected void replaceTop(RelNode node) {
        this.pop();
        this.push(node);
    }

    public RexNode equals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)GraphStdOperatorTable.EQUALS, operand0, operand1);
    }

    public RexNode not(RexNode operand) {
        return this.call((SqlOperator)GraphStdOperatorTable.NOT, operand);
    }

    public GraphBuilder convert(RelDataType castRowType, boolean rename) {
        return this;
    }

    public GraphBuilder as(String alias) {
        RelNode top = Objects.requireNonNull(this.peek(), "frame stack is empty");
        RelNode parent = null;
        while (!top.getInputs().isEmpty() && top.getInput(0).getRowType() == top.getRowType()) {
            parent = top;
            top = top.getInput(0);
        }
        if (top instanceof AbstractBindableTableScan || top instanceof GraphLogicalPathExpand || top instanceof GraphLogicalProject || top instanceof GraphLogicalAggregate) {
            GraphLogicalAggregate aggregate;
            RelDataType rowType = top.getRowType();
            if (rowType.getFieldList().size() != 1) {
                return this;
            }
            this.build();
            if (!top.getInputs().isEmpty()) {
                this.push(top.getInput(0));
            }
            if (top instanceof GraphLogicalSource) {
                GraphLogicalSource source = (GraphLogicalSource)top;
                this.source(new SourceConfig(source.getOpt(), this.getLabelConfig(source.getTableConfig()), alias));
                if (source.getUniqueKeyFilters() != null) {
                    this.filter(source.getUniqueKeyFilters());
                }
                if (ObjectUtils.isNotEmpty(source.getFilters())) {
                    this.filter((Iterable)source.getFilters());
                }
            } else if (top instanceof GraphLogicalExpand) {
                GraphLogicalExpand expand = (GraphLogicalExpand)top;
                this.expand(new ExpandConfig(expand.getOpt(), this.getLabelConfig(expand.getTableConfig()), alias));
                if (ObjectUtils.isNotEmpty(expand.getFilters())) {
                    this.filter((Iterable)expand.getFilters());
                }
            } else if (top instanceof GraphLogicalGetV) {
                GraphLogicalGetV getV = (GraphLogicalGetV)top;
                this.getV(new GetVConfig(getV.getOpt(), this.getLabelConfig(getV.getTableConfig()), alias));
                if (ObjectUtils.isNotEmpty(getV.getFilters())) {
                    this.filter((Iterable)getV.getFilters());
                }
            } else if (top instanceof GraphLogicalPathExpand) {
                GraphLogicalPathExpand pxdExpand = (GraphLogicalPathExpand)top;
                GraphLogicalExpand expand = (GraphLogicalExpand)pxdExpand.getExpand();
                GraphLogicalGetV getV = (GraphLogicalGetV)pxdExpand.getGetV();
                PathExpandConfig.Builder pxdBuilder = PathExpandConfig.newBuilder(this);
                RexNode offset = pxdExpand.getOffset();
                RexNode fetch = pxdExpand.getFetch();
                pxdBuilder.expand(new ExpandConfig(expand.getOpt(), this.getLabelConfig(expand.getTableConfig()), expand.getAliasName())).getV(new GetVConfig(getV.getOpt(), this.getLabelConfig(getV.getTableConfig()), getV.getAliasName())).pathOpt(pxdExpand.getPathOpt()).resultOpt(pxdExpand.getResultOpt()).range(offset == null ? 0 : (Integer)((RexLiteral)offset).getValueAs(Integer.class), fetch == null ? -1 : (Integer)((RexLiteral)fetch).getValueAs(Integer.class)).startAlias(pxdExpand.getStartAlias().getAliasName()).alias(alias);
                this.pathExpand(pxdBuilder.buildConfig());
            } else if (top instanceof GraphLogicalProject) {
                GraphLogicalProject project = (GraphLogicalProject)top;
                this.project((Iterable)project.getProjects(), (Iterable)Lists.newArrayList((Object[])new String[]{alias}), project.isAppend());
            } else if (top instanceof GraphLogicalAggregate && (aggregate = (GraphLogicalAggregate)top).getGroupKey().groupKeyCount() == 0 && aggregate.getAggCalls().size() == 1) {
                GraphAggCall aggCall = aggregate.getAggCalls().get(0);
                this.aggregate((RelBuilder.GroupKey)aggregate.getGroupKey(), (Iterable)ImmutableList.of((Object)aggCall.as(alias)));
            }
            if (parent != null && this.peek() != top) {
                parent.replaceInput(0, this.build());
                this.push(parent);
            }
        }
        return this;
    }

    private LabelConfig getLabelConfig(TableConfig tableConfig) {
        List<String> labels = tableConfig.getTables().stream().map(k -> (String)k.getQualifiedName().get(0)).collect(Collectors.toList());
        LabelConfig labelConfig = new LabelConfig(tableConfig.isAll());
        labels.forEach(k -> labelConfig.addLabel((String)k));
        return labelConfig;
    }

    private Iterable<RexNode> flatExprs(Iterable<RexNode> exprs) {
        ArrayList flatExprs = Lists.newArrayList();
        exprs.forEach(expr -> {
            block7: {
                block5: {
                    block6: {
                        if (!(expr instanceof RexCall)) break block5;
                        List operands = ((RexCall)expr).getOperands();
                        if (!operands.stream().anyMatch(operand -> operand instanceof RexGraphVariableList)) break block6;
                        switch (expr.getKind()) {
                            case DESCENDING: {
                                operands = (List)this.flatExprs((Iterable<RexNode>)ImmutableList.of((Object)((RexNode)operands.get(0))));
                                operands.forEach(operand -> flatExprs.add(this.desc((RexNode)operand)));
                                break block7;
                            }
                            default: {
                                throw new IllegalArgumentException("cannot flat operands of " + expr.getKind() + " operator");
                            }
                        }
                    }
                    flatExprs.add(expr);
                    break block7;
                }
                if (expr instanceof RexGraphVariableList) {
                    flatExprs.addAll((RexGraphVariableList)expr);
                } else {
                    flatExprs.add(expr);
                }
            }
        });
        return flatExprs;
    }

    private static /* synthetic */ void lambda$fuseFilters$14(RexVisitor propertyChecker, RexNode k) {
        k.accept(propertyChecker);
    }

    private static /* synthetic */ void lambda$fuseFilters$13(RexVisitor propertyChecker, Object k) {
        ((RexNode)k).accept(propertyChecker);
    }

    private static class ColumnField
    extends Pair<Integer, RelDataTypeField> {
        public ColumnField(Integer left, RelDataTypeField right) {
            super((Object)left, (Object)right);
        }
    }
}

