/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools;

import com.alibaba.graphscope.common.ir.meta.procedure.StoredProcedureMeta;
import com.alibaba.graphscope.common.ir.rel.graph.match.AbstractLogicalMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalMultiMatch;
import com.alibaba.graphscope.common.ir.rel.graph.match.GraphLogicalSingleMatch;
import com.alibaba.graphscope.common.ir.tools.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogicalPlan {
    private @Nullable RelNode regularQuery;
    private @Nullable RexNode procedureCall;
    private boolean returnEmpty;
    private final List<StoredProcedureMeta.Parameter> dynamicParams;

    public LogicalPlan(RelNode regularQuery) {
        this(regularQuery, (List<StoredProcedureMeta.Parameter>)ImmutableList.of());
    }

    public LogicalPlan(RelNode regularQuery, List<StoredProcedureMeta.Parameter> dynamicParams) {
        this.regularQuery = Objects.requireNonNull(regularQuery);
        this.returnEmpty = this.returnEmpty(this.regularQuery);
        this.dynamicParams = Objects.requireNonNull(dynamicParams);
    }

    public LogicalPlan(RexNode procedureCall) {
        this.procedureCall = Objects.requireNonNull(procedureCall);
        this.dynamicParams = ImmutableList.of();
    }

    public @Nullable RelNode getRegularQuery() {
        return this.regularQuery;
    }

    public @Nullable RexNode getProcedureCall() {
        return this.procedureCall;
    }

    public boolean isReturnEmpty() {
        return this.returnEmpty;
    }

    public String explain() {
        if (this.regularQuery != null) {
            return this.regularQuery.explain();
        }
        if (this.procedureCall != null) {
            return this.procedureCall.toString();
        }
        return "";
    }

    private boolean returnEmpty(RelNode relNode) {
        ArrayList inputs = Lists.newArrayList((Object[])new RelNode[]{relNode});
        while (!inputs.isEmpty()) {
            AbstractLogicalMatch match;
            RelNode cur = (RelNode)inputs.remove(0);
            if (cur instanceof LogicalValues) {
                return true;
            }
            if (cur instanceof GraphLogicalSingleMatch) {
                match = (GraphLogicalSingleMatch)cur;
                if (this.returnEmpty(((GraphLogicalSingleMatch)match).getSentence())) {
                    return true;
                }
            } else if (cur instanceof GraphLogicalMultiMatch) {
                match = (GraphLogicalMultiMatch)cur;
                for (RelNode sentence : ((GraphLogicalMultiMatch)match).getSentences()) {
                    if (!this.returnEmpty(sentence)) continue;
                    return true;
                }
            }
            inputs.addAll(cur.getInputs());
        }
        return false;
    }

    public @Nullable RelDataType getOutputType() {
        if (this.regularQuery != null) {
            return Utils.getOutputType(this.regularQuery);
        }
        if (this.procedureCall != null) {
            return this.procedureCall.getType();
        }
        return null;
    }

    public List<StoredProcedureMeta.Parameter> getDynamicParams() {
        return Collections.unmodifiableList(this.dynamicParams);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalPlan that = (LogicalPlan)o;
        return this.returnEmpty == that.returnEmpty && Objects.equals(this.getDigest(this.regularQuery), this.getDigest(that.regularQuery)) && Objects.equals(this.procedureCall, that.procedureCall) && Objects.equals(this.dynamicParams, that.dynamicParams);
    }

    public int hashCode() {
        return Objects.hash(this.getDigest(this.regularQuery), this.procedureCall, this.returnEmpty, this.dynamicParams);
    }

    private String getDigest(RelNode rel) {
        return rel == null ? null : rel.explain();
    }
}

