/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FrontendConfig;
import com.alibaba.graphscope.common.ir.tools.GraphPlanner;
import com.alibaba.graphscope.common.ir.tools.LogicalPlan;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class QueryCache {
    private final LoadingCache<Key, Value> cache;

    public QueryCache(Configs configs) {
        int cacheSize = FrontendConfig.QUERY_CACHE_SIZE.get(configs);
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).build(CacheLoader.from(key -> new Value(key.instance.plan(), null)));
    }

    public Key createKey(GraphPlanner.PlannerInstance instance) {
        return new Key(instance);
    }

    public Value get(Key key) throws ExecutionException {
        return (Value)this.cache.get((Object)key);
    }

    public static class Result<T> {
        public final long queryId;
        public final List<T> records;
        public boolean isCompleted;

        public Result(long queryId, List<T> records, boolean isCompleted) {
            this.queryId = queryId;
            this.records = Objects.requireNonNull(records);
            this.isCompleted = isCompleted;
        }
    }

    public static class Value {
        public final GraphPlanner.Summary summary;
        public @Nullable Result result;

        public Value(GraphPlanner.Summary summary, Result result) {
            this.summary = Objects.requireNonNull(summary);
            this.result = result;
        }
    }

    public class Key {
        public final GraphPlanner.PlannerInstance instance;
        public final LogicalPlan logicalPlan;

        public Key(GraphPlanner.PlannerInstance instance) {
            this.instance = instance;
            this.logicalPlan = instance.getParsedPlan();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return Objects.equals(this.logicalPlan, that.logicalPlan);
        }

        public int hashCode() {
            return Objects.hash(this.logicalPlan);
        }
    }
}

