/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.tools;

import com.alibaba.graphscope.common.ir.meta.schema.CommonOptTable;
import com.alibaba.graphscope.common.ir.rel.CommonTableScan;
import com.alibaba.graphscope.common.ir.tools.AliasInference;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.externalize.RelWriterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Sarg;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Utils {
    public static RelDataType getOutputType(RelNode topNode) {
        ArrayList outputFields = Lists.newArrayList();
        ArrayList inputs = Lists.newArrayList((Object[])new RelNode[]{topNode});
        while (!inputs.isEmpty()) {
            RelNode cur = (RelNode)inputs.remove(0);
            outputFields.addAll(0, cur.getRowType().getFieldList());
            if (AliasInference.removeAlias(cur)) break;
            inputs.addAll(cur.getInputs());
        }
        HashSet uniqueNames = Sets.newHashSet();
        ArrayList dedup = Lists.newArrayList();
        for (int i = outputFields.size() - 1; i >= 0; --i) {
            RelDataTypeField field = (RelDataTypeField)outputFields.get(i);
            if (field.getName() == "_" && i != outputFields.size() - 1 || uniqueNames.contains(field.getName())) continue;
            uniqueNames.add(field.getName());
            dedup.add(0, field);
        }
        return new RelRecordType(StructKind.FULLY_QUALIFIED, (List)dedup);
    }

    public static List<Comparable> getValuesAsList(Comparable value) {
        ArrayList values = Lists.newArrayList();
        if (value instanceof NlsString) {
            values.add(((NlsString)value).getValue());
        } else if (value instanceof Sarg) {
            Sarg sarg = (Sarg)value;
            if (sarg.isPoints()) {
                Set rangeSets = sarg.rangeSet.asRanges();
                for (Range range : rangeSets) {
                    values.addAll(Utils.getValuesAsList(range.lowerEndpoint()));
                }
            }
        } else {
            values.add(value);
        }
        return values;
    }

    public static GraphLabelType getGraphLabels(RelDataType rowType) {
        if (rowType instanceof GraphSchemaType) {
            return ((GraphSchemaType)rowType).getLabelType();
        }
        List fields = rowType.getFieldList();
        Preconditions.checkArgument((!fields.isEmpty() && ((RelDataTypeField)fields.get(0)).getType() instanceof GraphSchemaType ? 1 : 0) != 0, (String)"data type of graph operators should be %s ", GraphSchemaType.class);
        GraphSchemaType schemaType = (GraphSchemaType)((RelDataTypeField)fields.get(0)).getType();
        return schemaType.getLabelType();
    }

    public static String toString(RelNode node, SqlExplainLevel detailLevel) {
        return Utils.toString("root:", node, Sets.newHashSet(), detailLevel);
    }

    public static String toString(RelNode node) {
        return Utils.toString("root:", node, Sets.newHashSet(), SqlExplainLevel.EXPPLAN_ATTRIBUTES);
    }

    private static String toString(String header, RelNode node, Set<String> dedup, SqlExplainLevel detailLevel) {
        StringBuilder builder = new StringBuilder();
        if (!header.isEmpty()) {
            dedup.add(header);
            builder.append(header).append("\n");
        }
        builder.append(Utils.explain(node, detailLevel));
        ArrayList inputs = Lists.newArrayList((Iterable)node.getInputs());
        while (!inputs.isEmpty()) {
            CommonOptTable optTable;
            String name;
            RelNode input = (RelNode)inputs.remove(0);
            if (input instanceof CommonTableScan && !dedup.contains(name = (optTable = (CommonOptTable)((CommonTableScan)input).getTable()).getQualifiedName().get(0) + ":")) {
                builder.append(Utils.toString(name, optTable.getCommon(), dedup, detailLevel));
            }
            inputs.addAll(input.getInputs());
        }
        return builder.toString();
    }

    public static @Nullable String explain(@Nullable RelNode rel, SqlExplainLevel detailLevel) {
        if (rel == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        RelWriterImpl planWriter = new RelWriterImpl(new PrintWriter(sw), detailLevel, false){

            protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
                List inputs = rel.getInputs();
                RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
                if (!mq.isVisibleInExplain(rel, this.detailLevel).booleanValue()) {
                    this.explainInputs(inputs);
                    return;
                }
                StringBuilder s = new StringBuilder();
                this.spacer.spaces(s);
                if (this.withIdPrefix) {
                    s.append(rel.getId()).append(":");
                }
                s.append(rel.getRelTypeName());
                if (this.detailLevel != SqlExplainLevel.NO_ATTRIBUTES) {
                    int j = 0;
                    for (Pair<String, Object> value : values) {
                        if (value.right instanceof RelNode) continue;
                        if (j++ == 0) {
                            s.append("(");
                        } else {
                            s.append(", ");
                        }
                        s.append((String)value.left).append("=[").append(value.right).append("]");
                    }
                    if (j > 0) {
                        s.append(")");
                    }
                }
                switch (this.detailLevel) {
                    case ALL_ATTRIBUTES: {
                        s.append(": rowcount = ").append(mq.getRowCount(rel)).append(", cumulative cost = ").append(mq.getCumulativeCost(rel));
                        break;
                    }
                    case NON_COST_ATTRIBUTES: {
                        s.append(": rowcount = ").append(mq.getRowCount(rel));
                    }
                }
                switch (this.detailLevel) {
                    case ALL_ATTRIBUTES: 
                    case NON_COST_ATTRIBUTES: {
                        break;
                    }
                }
                this.pw.println(s);
                this.spacer.add(2);
                this.explainInputs(inputs);
                this.spacer.subtract(2);
            }

            private void explainInputs(List<RelNode> inputs) {
                for (RelNode input : inputs) {
                    input.explain((RelWriter)this);
                }
            }
        };
        rel.explain((RelWriter)planWriter);
        return sw.toString();
    }
}

