/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.type;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphLabelType
extends AbstractSqlType {
    private final List<Entry> labels;

    public GraphLabelType(Entry label) {
        this((List<Entry>)ImmutableList.of((Object)label));
    }

    public GraphLabelType(List<Entry> labels) {
        this(labels, SqlTypeName.CHAR);
    }

    public GraphLabelType(Entry label, SqlTypeName typeName) {
        this((List<Entry>)ImmutableList.of((Object)label), typeName);
    }

    public GraphLabelType(List<Entry> labels, SqlTypeName typeName) {
        super(typeName, false, null);
        this.labels = (List)ObjectUtils.requireNonEmpty(labels);
        this.computeDigest();
    }

    public Entry getSingleLabelEntry() {
        return this.labels.get(0);
    }

    public List<Entry> getLabelsEntry() {
        return Collections.unmodifiableList(this.labels);
    }

    public List<String> getLabelsString() {
        return this.getLabelsEntry().stream().map(k -> k.toString()).collect(Collectors.toUnmodifiableList());
    }

    protected void generateTypeString(StringBuilder stringBuilder, boolean b) {
        stringBuilder.append(this.getLabelsString());
    }

    public void removeLabels(List<Entry> labelsToRemove) {
        this.labels.removeAll(labelsToRemove);
    }

    public static class Entry {
        private String label = "";
        private Integer labelId = -1;
        private @Nullable String srcLabel;
        private @Nullable Integer srcLabelId;
        private @Nullable String dstLabel;
        private @Nullable Integer dstLabelId;

        public Entry label(String label) {
            Objects.requireNonNull(label);
            this.label = label;
            return this;
        }

        public Entry labelId(int labelId) {
            this.labelId = labelId;
            return this;
        }

        public Entry srcLabel(String srcLabel) {
            this.srcLabel = srcLabel;
            return this;
        }

        public Entry srcLabelId(int srcLabelId) {
            this.srcLabelId = srcLabelId;
            return this;
        }

        public Entry dstLabel(String dstLabel) {
            this.dstLabel = dstLabel;
            return this;
        }

        public Entry dstLabelId(int dstLabelId) {
            this.dstLabelId = dstLabelId;
            return this;
        }

        public String getLabel() {
            return this.label;
        }

        public Integer getLabelId() {
            return this.labelId;
        }

        public @Nullable String getSrcLabel() {
            return this.srcLabel;
        }

        public @Nullable Integer getSrcLabelId() {
            return this.srcLabelId;
        }

        public @Nullable String getDstLabel() {
            return this.dstLabel;
        }

        public @Nullable Integer getDstLabelId() {
            return this.dstLabelId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.srcLabel == null || this.dstLabel == null) {
                builder.append("VertexLabel(");
                builder.append(this.label);
                builder.append(")");
            } else {
                builder.append("EdgeLabel(");
                builder.append(this.label + ", " + this.srcLabel + ", " + this.dstLabel);
                builder.append(")");
            }
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.label, entry.label) && Objects.equals(this.labelId, entry.labelId) && Objects.equals(this.srcLabel, entry.srcLabel) && Objects.equals(this.srcLabelId, entry.srcLabelId) && Objects.equals(this.dstLabel, entry.dstLabel) && Objects.equals(this.dstLabelId, entry.dstLabelId);
        }

        public int hashCode() {
            return Objects.hash(this.label, this.labelId, this.srcLabel, this.srcLabelId, this.dstLabel, this.dstLabelId);
        }
    }
}

