/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.type;

import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphTypeFamily;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rel.type.StructKind;
import org.apache.commons.lang3.ObjectUtils;

public class GraphSchemaType
extends RelRecordType {
    private final GraphOpt.Source scanOpt;
    private final GraphLabelType labelType;
    private final List<GraphSchemaType> fuzzySchemaTypes;

    public GraphSchemaType(GraphOpt.Source scanOpt, GraphLabelType labelType, List<RelDataTypeField> fields) {
        this(scanOpt, labelType, fields, false);
    }

    public GraphSchemaType(GraphOpt.Source scanOpt, GraphLabelType labelType, List<RelDataTypeField> fields, boolean isNullable) {
        super(StructKind.NONE, fields, isNullable);
        this.scanOpt = scanOpt;
        Preconditions.checkArgument((labelType.getLabelsEntry().size() == 1 ? 1 : 0) != 0, (String)"can not use label=%s to init GraphSchemaType with single label", (Object)((Object)labelType));
        this.labelType = labelType;
        this.fuzzySchemaTypes = ImmutableList.of();
    }

    protected GraphSchemaType(GraphOpt.Source scanOpt, GraphLabelType labelType, List<RelDataTypeField> fields, List<GraphSchemaType> fuzzySchemaTypes, boolean isNullable) {
        super(StructKind.NONE, fields, isNullable);
        this.scanOpt = scanOpt;
        this.fuzzySchemaTypes = Objects.requireNonNull(fuzzySchemaTypes);
        this.labelType = labelType;
    }

    public static GraphSchemaType create(List<GraphSchemaType> list, RelDataTypeFactory typeFactory) {
        return GraphSchemaType.create(list, typeFactory, false);
    }

    public static GraphSchemaType create(List<GraphSchemaType> list, RelDataTypeFactory typeFactory, boolean isNullable) {
        ObjectUtils.requireNonEmpty(list, (String)"schema type list should not be empty");
        if (list.size() == 1) {
            return list.get(0);
        }
        GraphOpt.Source scanOpt = list.get(0).getScanOpt();
        ArrayList labelOpts = Lists.newArrayList();
        List<Object> fields = Lists.newArrayList();
        ArrayList commonFields = Lists.newArrayList((Iterable)list.get(0).getFieldList());
        ArrayList fuzzyEntries = Lists.newArrayList();
        for (GraphSchemaType type : list) {
            Preconditions.checkArgument((!type.fuzzy() ? 1 : 0) != 0, (Object)("fuzzy label types nested in list of " + GraphSchemaType.class + " is considered to be invalid here"));
            labelOpts.add("{label=" + type.getLabelType().getLabelsString() + ", opt=" + type.scanOpt + "}");
            if (type.getScanOpt() != scanOpt) {
                throw new IllegalArgumentException("fuzzy label types should have the same opt, but is " + labelOpts);
            }
            fields.addAll(type.getFieldList());
            commonFields.retainAll(type.getFieldList());
            fuzzyEntries.addAll(type.getLabelType().getLabelsEntry());
        }
        fields = fields.stream().distinct().map(k -> {
            if (!commonFields.contains(k)) {
                return new RelDataTypeFieldImpl(k.getName(), k.getIndex(), typeFactory.createTypeWithNullability(k.getType(), true));
            }
            return k;
        }).collect(Collectors.toList());
        return new GraphSchemaType(scanOpt, new GraphLabelType(fuzzyEntries), (List<RelDataTypeField>)fields, list, isNullable);
    }

    public GraphOpt.Source getScanOpt() {
        return this.scanOpt;
    }

    public GraphLabelType getLabelType() {
        return this.labelType;
    }

    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("Graph_Schema_Type");
        sb.append("(");
        sb.append("labels=" + this.labelType);
        sb.append(", properties=[");
        for (Ord ord : Ord.zip((List)Objects.requireNonNull(this.fieldList, "fieldList"))) {
            if (ord.i > 0) {
                sb.append(", ");
            }
            RelDataTypeField field = (RelDataTypeField)ord.e;
            if (withDetail) {
                sb.append(field.getType().getFullTypeString());
            } else {
                sb.append(field.getType().toString());
            }
            sb.append(" ");
            sb.append(field.getName());
        }
        sb.append("]");
        sb.append(")");
    }

    protected void computeDigest() {
        StringBuilder sb = new StringBuilder();
        this.generateTypeString(sb, false);
        this.digest = sb.toString();
    }

    public boolean isStruct() {
        return false;
    }

    public RelDataTypeFamily getFamily() {
        return this.scanOpt == GraphOpt.Source.VERTEX ? GraphTypeFamily.VERTEX : GraphTypeFamily.EDGE;
    }

    public List<GraphSchemaType> getSchemaTypeAsList() {
        return ObjectUtils.isEmpty(this.fuzzySchemaTypes) ? ImmutableList.of((Object)((Object)this)) : Collections.unmodifiableList(this.fuzzySchemaTypes);
    }

    public boolean fuzzy() {
        return this.labelType.getLabelsEntry().size() > 1 || this.fuzzySchemaTypes.size() > 1;
    }
}

