/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.type;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FrontendConfig;
import com.alibaba.graphscope.common.ir.type.ArbitraryArrayType;
import com.alibaba.graphscope.common.ir.type.ArbitraryMapType;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphTypeFactoryImpl
extends JavaTypeFactoryImpl {
    private final Configs configs;

    public GraphTypeFactoryImpl(Configs configs) {
        this.configs = configs;
    }

    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        GraphSchemaType schemaType;
        Object newType = type instanceof GraphSchemaType ? ((schemaType = (GraphSchemaType)type).getSchemaTypeAsList().size() > 1 ? new GraphSchemaType(schemaType.getScanOpt(), schemaType.getLabelType(), schemaType.getFieldList(), schemaType.getSchemaTypeAsList(), nullable) : new GraphSchemaType(schemaType.getScanOpt(), schemaType.getLabelType(), schemaType.getFieldList(), nullable)) : (type instanceof GraphPathType ? new GraphPathType(((GraphPathType)type).getComponentType(), nullable) : super.createTypeWithNullability(type, nullable));
        return newType;
    }

    public Charset getDefaultCharset() {
        return Charset.forName(FrontendConfig.CALCITE_DEFAULT_CHARSET.get(this.configs));
    }

    public RelDataType createArbitraryArrayType(List<RelDataType> componentTypes, boolean isNullable) {
        return new ArbitraryArrayType(componentTypes, isNullable);
    }

    public RelDataType createArbitraryMapType(Map<RexNode, ArbitraryMapType.KeyValueType> keyValueTypeMap, boolean isNullable) {
        return new ArbitraryMapType(keyValueTypeMap, isNullable);
    }

    public @Nullable RelDataType leastRestrictive(List<RelDataType> types) {
        if (types.stream().anyMatch(t -> t instanceof GraphLabelType)) {
            for (RelDataType type : types) {
                if (type instanceof GraphLabelType) continue;
                return null;
            }
            return types.get(0);
        }
        if (types.stream().anyMatch(t -> t instanceof ArbitraryMapType)) {
            return this.leastRestrictiveForArbitraryMapType(types);
        }
        return super.leastRestrictive(types);
    }

    private @Nullable RelDataType leastRestrictiveForArbitraryMapType(List<RelDataType> types) {
        boolean isNullable = false;
        HashMap leastKeyValueTypes = Maps.newHashMap();
        for (RelDataType type : types) {
            if (!(type instanceof ArbitraryMapType)) {
                return null;
            }
            ArbitraryMapType mapType = (ArbitraryMapType)type;
            if (mapType.isNullable()) {
                isNullable = true;
            }
            if (leastKeyValueTypes.isEmpty()) {
                mapType.getKeyValueTypeMap().forEach((k, v) -> leastKeyValueTypes.put(k, Lists.newArrayList((Object[])new ArbitraryMapType.KeyValueType[]{v})));
                continue;
            }
            for (Map.Entry<RexNode, ArbitraryMapType.KeyValueType> entry : mapType.getKeyValueTypeMap().entrySet()) {
                List leastTypes = (List)leastKeyValueTypes.get(entry.getKey());
                if (leastTypes == null) {
                    return null;
                }
                leastTypes.add(entry.getValue());
            }
        }
        HashMap leastKeyValueType = Maps.newHashMap();
        for (Map.Entry entry : leastKeyValueTypes.entrySet()) {
            RelDataType leastKeyType = this.leastRestrictive(((List)entry.getValue()).stream().map(Pair::getKey).collect(Collectors.toList()));
            if (leastKeyType == null) {
                return null;
            }
            RelDataType leastValueType = this.leastRestrictive(((List)entry.getValue()).stream().map(Pair::getValue).collect(Collectors.toList()));
            if (leastValueType == null) {
                return null;
            }
            leastKeyValueType.put((RexNode)entry.getKey(), new ArbitraryMapType.KeyValueType(leastKeyType, leastValueType));
        }
        return this.createArbitraryMapType(leastKeyValueType, isNullable);
    }
}

