/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.ir.type;

import com.alibaba.graphscope.common.ir.rel.graph.AbstractBindableTableScan;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalGetV;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalPathExpand;
import com.alibaba.graphscope.common.ir.rel.graph.GraphLogicalSource;
import com.alibaba.graphscope.common.ir.rel.type.AliasNameWithId;
import com.alibaba.graphscope.common.ir.rel.type.TableConfig;
import com.alibaba.graphscope.common.ir.tools.GraphBuilder;
import com.alibaba.graphscope.common.ir.tools.config.GraphOpt;
import com.alibaba.graphscope.common.ir.type.GraphLabelType;
import com.alibaba.graphscope.common.ir.type.GraphPathType;
import com.alibaba.graphscope.common.ir.type.GraphSchemaType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.GraphOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GraphTypeInference {
    private final GraphBuilder builder;

    public GraphTypeInference(GraphBuilder builder) {
        this.builder = builder;
    }

    public RelNode inferTypes(RelNode top) {
        return this.visitRels((List<RelNode>)ImmutableList.of((Object)top)).get(0);
    }

    public List<RelNode> inferTypes(List<RelNode> sentences) {
        return this.visitRels(sentences);
    }

    private List<RelNode> visitRels(List<RelNode> rels) {
        int maxIter = this.calculateMaxIters(rels);
        ArrayList updated = Lists.newArrayList();
        do {
            if (!updated.isEmpty()) {
                updated.clear();
            }
            RelGraph relGraph = new RelGraph(rels);
            rels = relGraph.getRels().stream().map(k -> this.dfs(relGraph, (RelNode)k, this.getType((RelNode)k), Sets.newHashSet(), updated)).collect(Collectors.toList());
        } while (maxIter-- > 0 && !updated.isEmpty());
        return rels;
    }

    private int calculateMaxIters(List<RelNode> rels) {
        ArrayList queue = Lists.newArrayList(rels);
        int maxIters = 0;
        while (!queue.isEmpty()) {
            RelNode cur = (RelNode)queue.remove(0);
            ++maxIters;
            queue.addAll(cur.getInputs());
        }
        return maxIters;
    }

    private RelNode dfs(RelGraph relGraph, RelNode top, RelDataType restriction, Set<RelNode> visited, List<RelNode> updated) {
        RelDataType oldType;
        List<RelNode> relsWithSameAlias;
        if (visited.contains(top) || !(top instanceof AbstractBindableTableScan) && !(top instanceof GraphLogicalPathExpand)) {
            return top;
        }
        visited.add(top);
        List<RelNode> newNeighbors = relGraph.getNeighbors(top).stream().map(k -> this.dfs(relGraph, (RelNode)k, this.restrictChild(relGraph, (RelNode)k, top, restriction), visited, updated)).collect(Collectors.toList());
        RelDataType newType = this.restrictParent(relGraph, newNeighbors, top, restriction);
        String alias = relGraph.getAliasName(top);
        if (alias != null && alias != "_" && ObjectUtils.isNotEmpty(relsWithSameAlias = relGraph.aliasNameToRels.get(alias))) {
            newType = this.restrictShared(relsWithSameAlias, top, newType);
        }
        if (!this.typeEquals(oldType = this.getType(top), newType)) {
            updated.add(top);
            RelNode newTop = this.newRel(top, newType);
            RelNode parent = relGraph.getParent(top);
            if (parent != null) {
                parent.replaceInput(0, newTop);
            }
            return newTop;
        }
        return top;
    }

    private boolean typeEquals(RelDataType type1, RelDataType type2) {
        if (type1 instanceof GraphSchemaType && type2 instanceof GraphSchemaType) {
            return ((GraphSchemaType)type1).getLabelType().equals((Object)((GraphSchemaType)type2).getLabelType());
        }
        if (type1 instanceof GraphPathType && type2 instanceof GraphPathType) {
            GraphPathType pathType1 = (GraphPathType)type1;
            GraphPathType pathType2 = (GraphPathType)type2;
            return this.typeEquals(pathType1.getComponentType().getExpandType(), pathType2.getComponentType().getExpandType()) && this.typeEquals(pathType1.getComponentType().getGetVType(), pathType2.getComponentType().getGetVType());
        }
        return true;
    }

    private RelDataType restrictChild(RelGraph relGraph, RelNode child, RelNode parent, RelDataType parentType) {
        if (child instanceof GraphLogicalSource && ((GraphLogicalSource)child).getOpt() == GraphOpt.Source.VERTEX || child instanceof GraphLogicalGetV) {
            GraphSchemaType childType = (GraphSchemaType)this.getType(child);
            GraphLabelType childLabelType = childType.getLabelType();
            if (parent instanceof GraphLogicalPathExpand) {
                GraphLogicalPathExpand pxd = (GraphLogicalPathExpand)parent;
                int minHop = pxd.getOffset() == null ? 0 : ((Number)((Object)((RexLiteral)pxd.getOffset()).getValue())).intValue();
                int maxHop = pxd.getFetch() == null ? Integer.MAX_VALUE : ((Number)((Object)((RexLiteral)pxd.getFetch()).getValue())).intValue() + minHop - 1;
                GraphPathTypeInference pathTypeInfer = new GraphPathTypeInference(childLabelType, null, (GraphPathType)parentType, ((GraphLogicalExpand)pxd.getExpand()).getOpt(), minHop, maxHop);
                return this.createSchemaType(GraphOpt.Source.VERTEX, pathTypeInfer.inferStartVType().getLabelsEntry(), childType);
            }
            if (parent instanceof GraphLogicalExpand) {
                GraphLogicalExpand expand = (GraphLogicalExpand)parent;
                GraphLabelType parentLabelType = ((GraphSchemaType)parentType).getLabelType();
                List<GraphLabelType.Entry> commonLabels = this.commonLabels(childLabelType, parentLabelType, expand.getOpt(), true, false);
                return this.createSchemaType(GraphOpt.Source.VERTEX, commonLabels, childType);
            }
            throw new IllegalArgumentException("graph generic type error: unable to establish an extension relationship between node " + child + " with node " + parent);
        }
        if (child instanceof GraphLogicalSource && ((GraphLogicalSource)child).getOpt() == GraphOpt.Source.EDGE || child instanceof GraphLogicalExpand) {
            Preconditions.checkArgument((boolean)(parent instanceof GraphLogicalGetV), (String)"graph generic type error: unable to establish an extension relationship between node %s with node %s", (Object)child, (Object)parent);
            GraphLogicalGetV getV = (GraphLogicalGetV)parent;
            GraphSchemaType childType = (GraphSchemaType)this.getType(child);
            GraphLabelType childLabelType = childType.getLabelType();
            GraphLabelType parentLabelType = ((GraphSchemaType)parentType).getLabelType();
            GraphLabelType otherVLabelType = null;
            if (getV.getOpt() == GraphOpt.GetV.OTHER) {
                RelDataType otherVType = relGraph.getNeighborsType(child);
                Preconditions.checkArgument((otherVType != null && otherVType instanceof GraphSchemaType ? 1 : 0) != 0, (String)"graph generic type error: invalid opt %s in node %s", (Object)((Object)getV.getOpt()), (Object)((Object)getV));
                otherVLabelType = ((GraphSchemaType)otherVType).getLabelType();
            }
            List<GraphLabelType.Entry> commonLabels = this.commonLabels(otherVLabelType, childLabelType, parentLabelType, getV.getOpt(), true);
            return this.createSchemaType(GraphOpt.Source.EDGE, commonLabels, childType);
        }
        if (child instanceof GraphLogicalPathExpand) {
            Preconditions.checkArgument((boolean)(parent instanceof GraphLogicalGetV), (String)"graph generic type error: unable to establish an extension relationship between node %s with node %s", (Object)child, (Object)parent);
            GraphLogicalPathExpand pxd = (GraphLogicalPathExpand)child;
            int minHop = pxd.getOffset() == null ? 0 : ((Number)((Object)((RexLiteral)pxd.getOffset()).getValue())).intValue();
            int maxHop = pxd.getFetch() == null ? Integer.MAX_VALUE : ((Number)((Object)((RexLiteral)pxd.getFetch()).getValue())).intValue() + minHop - 1;
            GraphPathTypeInference pathTypeInfer = new GraphPathTypeInference(((GraphSchemaType)this.getType(child.getInput(0))).getLabelType(), ((GraphSchemaType)parentType).getLabelType(), (GraphPathType)this.getType(child), ((GraphLogicalExpand)pxd.getExpand()).getOpt(), minHop, maxHop);
            return pathTypeInfer.inferPathType();
        }
        throw new IllegalArgumentException("graph generic type error: unable to establish an extension relationship between node " + child + " with node " + parent);
    }

    private RelDataType restrictParent(RelGraph relGraph, List<RelNode> children, RelNode parent, RelDataType parentType) {
        for (RelNode child : children) {
            parentType = this.restrictParent(relGraph, child, parent, parentType);
        }
        return parentType;
    }

    private RelDataType restrictParent(RelGraph relGraph, RelNode child, RelNode parent, RelDataType parentType) {
        if (child instanceof GraphLogicalSource && ((GraphLogicalSource)child).getOpt() == GraphOpt.Source.VERTEX || child instanceof GraphLogicalGetV) {
            if (parent instanceof GraphLogicalExpand) {
                GraphLogicalExpand expand = (GraphLogicalExpand)parent;
                GraphLabelType childLabelType = ((GraphSchemaType)this.getType(child)).getLabelType();
                GraphLabelType parentLabelType = ((GraphSchemaType)parentType).getLabelType();
                List<GraphLabelType.Entry> commonLabels = this.commonLabels(childLabelType, parentLabelType, expand.getOpt(), false, false);
                return this.createSchemaType(GraphOpt.Source.EDGE, commonLabels, (GraphSchemaType)parentType);
            }
            if (parent instanceof GraphLogicalPathExpand) {
                GraphLogicalPathExpand pxd = (GraphLogicalPathExpand)parent;
                int minHop = pxd.getOffset() == null ? 0 : ((Number)((Object)((RexLiteral)pxd.getOffset()).getValue())).intValue();
                int maxHop = pxd.getFetch() == null ? Integer.MAX_VALUE : ((Number)((Object)((RexLiteral)pxd.getFetch()).getValue())).intValue() + minHop - 1;
                GraphPathTypeInference pathTypeInfer = new GraphPathTypeInference(((GraphSchemaType)this.getType(child)).getLabelType(), ((GraphSchemaType)this.getType(pxd.getGetV())).getLabelType(), (GraphPathType)parentType, ((GraphLogicalExpand)pxd.getExpand()).getOpt(), minHop, maxHop);
                return pathTypeInfer.inferPathType();
            }
            throw new IllegalArgumentException("graph generic type error: unable to establish an extension relationship between node " + child + " with node " + parent);
        }
        if (child instanceof GraphLogicalSource && ((GraphLogicalSource)child).getOpt() == GraphOpt.Source.EDGE || child instanceof GraphLogicalExpand) {
            Preconditions.checkArgument((boolean)(parent instanceof GraphLogicalGetV), (String)"graph generic type error: unable to establish an extension relationship between node %s with node %s", (Object)child, (Object)parent);
            GraphLogicalGetV getV = (GraphLogicalGetV)parent;
            GraphLabelType childLabelType = ((GraphSchemaType)this.getType(child)).getLabelType();
            GraphLabelType parentLabelType = ((GraphSchemaType)parentType).getLabelType();
            GraphLabelType otherVLabelType = null;
            if (getV.getOpt() == GraphOpt.GetV.OTHER) {
                RelDataType otherVType = relGraph.getNeighborsType(child);
                Preconditions.checkArgument((otherVType != null && otherVType instanceof GraphSchemaType ? 1 : 0) != 0, (String)"graph generic type error: invalid opt %s in node %s", (Object)((Object)getV.getOpt()), (Object)((Object)getV));
                otherVLabelType = ((GraphSchemaType)otherVType).getLabelType();
            }
            List<GraphLabelType.Entry> commonLabels = this.commonLabels(otherVLabelType, childLabelType, parentLabelType, getV.getOpt(), false);
            return this.createSchemaType(GraphOpt.Source.VERTEX, commonLabels, (GraphSchemaType)parentType);
        }
        if (child instanceof GraphLogicalPathExpand) {
            Preconditions.checkArgument((boolean)(parent instanceof GraphLogicalGetV), (String)"graph generic type error: unable to establish an extension relationship between node %s with node %s", (Object)child, (Object)parent);
            GraphLabelType outerGetVLabelType = ((GraphSchemaType)parentType).getLabelType();
            GraphLogicalPathExpand pxd = (GraphLogicalPathExpand)child;
            int minHop = pxd.getOffset() == null ? 0 : ((Number)((Object)((RexLiteral)pxd.getOffset()).getValue())).intValue();
            int maxHop = pxd.getFetch() == null ? Integer.MAX_VALUE : ((Number)((Object)((RexLiteral)pxd.getFetch()).getValue())).intValue() + minHop - 1;
            GraphPathTypeInference pathTypeInfer = new GraphPathTypeInference(null, outerGetVLabelType, (GraphPathType)this.getType((RelNode)pxd), ((GraphLogicalExpand)pxd.getExpand()).getOpt(), minHop, maxHop);
            return this.createSchemaType(GraphOpt.Source.VERTEX, pathTypeInfer.inferGetVType().getLabelsEntry(), (GraphSchemaType)parentType);
        }
        throw new IllegalArgumentException("graph generic type error: unable to establish an extension relationship between node " + child + " with node " + parent);
    }

    private RelDataType restrictShared(List<RelNode> rels, @Nullable RelNode shared, RelDataType sharedType) {
        if (sharedType instanceof GraphSchemaType) {
            GraphLabelType sharedLabelType = ((GraphSchemaType)sharedType).getLabelType();
            for (RelNode rel : rels) {
                RelDataType relType = this.getType(rel);
                Preconditions.checkArgument((relType instanceof GraphSchemaType && ((GraphSchemaType)relType).getScanOpt() == ((GraphSchemaType)sharedType).getScanOpt() ? 1 : 0) != 0, (String)"graph schema type error : rel type %s is not compatible with shared type %s", (Object)relType, (Object)sharedType);
                GraphLabelType relLabelType = ((GraphSchemaType)relType).getLabelType();
                sharedLabelType = new GraphLabelType(this.commonLabels(relLabelType, sharedLabelType));
            }
            return this.createSchemaType(((GraphSchemaType)sharedType).getScanOpt(), sharedLabelType.getLabelsEntry(), (GraphSchemaType)sharedType);
        }
        if (sharedType instanceof GraphPathType) {
            ArrayList expandRels = Lists.newArrayList();
            ArrayList getVRels = Lists.newArrayList();
            for (RelNode rel : rels) {
                Preconditions.checkArgument((boolean)(rel instanceof GraphLogicalPathExpand), (String)"graph schema type error : rel %s is not compatible with shared type %s", (Object)rel, (Object)sharedType);
                expandRels.add(((GraphLogicalPathExpand)rel).getExpand());
                getVRels.add(((GraphLogicalPathExpand)rel).getGetV());
            }
            RelDataType restrictExpand = this.restrictShared(expandRels, null, ((GraphPathType)sharedType).getComponentType().getExpandType());
            RelDataType restrictGetV = this.restrictShared(getVRels, null, ((GraphPathType)sharedType).getComponentType().getGetVType());
            return new GraphPathType(new GraphPathType.ElementType(restrictExpand, restrictGetV));
        }
        throw new IllegalArgumentException("graph schema type error: unable to restrict shared type " + sharedType);
    }

    private List<GraphLabelType.Entry> commonLabels(GraphLabelType labelType1, GraphLabelType labelType2) {
        ArrayList commonLabels = Lists.newArrayList(labelType1.getLabelsEntry());
        commonLabels.retainAll(labelType2.getLabelsEntry());
        Preconditions.checkArgument((!commonLabels.isEmpty() ? 1 : 0) != 0, (String)"graph schema type error: unable to find common labels between %s and %s", (Object)((Object)labelType1), (Object)((Object)labelType2));
        return commonLabels;
    }

    private List<GraphLabelType.Entry> commonLabels(@Nullable GraphLabelType otherVType, GraphLabelType expandType, GraphLabelType getVType, GraphOpt.GetV getVOpt, boolean recordExpand) {
        List<Object> commonLabels = Lists.newArrayList();
        for (GraphLabelType.Entry entry1 : expandType.getLabelsEntry()) {
            for (GraphLabelType.Entry entry2 : getVType.getLabelsEntry()) {
                if ((getVOpt == GraphOpt.GetV.START || getVOpt == GraphOpt.GetV.BOTH) && entry1.getSrcLabel().equals(entry2.getLabel())) {
                    if (recordExpand) {
                        commonLabels.add(entry1);
                    } else {
                        commonLabels.add(entry2);
                    }
                }
                if ((getVOpt == GraphOpt.GetV.END || getVOpt == GraphOpt.GetV.BOTH) && entry1.getDstLabel().equals(entry2.getLabel())) {
                    if (recordExpand) {
                        commonLabels.add(entry1);
                    } else {
                        commonLabels.add(entry2);
                    }
                }
                if (getVOpt != GraphOpt.GetV.OTHER || otherVType == null) continue;
                for (GraphLabelType.Entry entry3 : otherVType.getLabelsEntry()) {
                    if ((!entry1.getSrcLabel().equals(entry3.getLabel()) || !entry1.getDstLabel().equals(entry2.getLabel())) && (!entry1.getDstLabel().equals(entry3.getLabel()) || !entry1.getSrcLabel().equals(entry2.getLabel()))) continue;
                    if (recordExpand) {
                        commonLabels.add(entry1);
                        continue;
                    }
                    commonLabels.add(entry2);
                }
            }
        }
        if ((commonLabels = commonLabels.stream().distinct().collect(Collectors.toList())).isEmpty()) {
            String errorMsg;
            switch (getVOpt) {
                case OTHER: {
                    errorMsg = String.format("graph schema type error: unable to find expand with [type=%s] between getV with [type=%s] and getV with [opt=%s, type=%s]", new Object[]{expandType, otherVType, getVOpt, getVType});
                    break;
                }
                default: {
                    errorMsg = String.format("graph schema type error: unable to find getV with [opt=%s, type=%s] from expand with [type=%s]", new Object[]{getVOpt, getVType, expandType});
                }
            }
            throw new IllegalArgumentException(errorMsg);
        }
        return commonLabels;
    }

    private List<GraphLabelType.Entry> commonLabels(GraphLabelType getVType, GraphLabelType expandType, GraphOpt.Expand expandOpt, boolean recordGetV, boolean containsZeroPath) {
        List<Object> commonLabels = Lists.newArrayList();
        for (GraphLabelType.Entry entry1 : getVType.getLabelsEntry()) {
            for (GraphLabelType.Entry entry2 : expandType.getLabelsEntry()) {
                if (expandOpt != GraphOpt.Expand.OUT) {
                    if (entry1.getLabel().equals(entry2.getDstLabel())) {
                        if (recordGetV) {
                            commonLabels.add(entry1);
                        } else {
                            commonLabels.add(entry2);
                        }
                    }
                    if (containsZeroPath && recordGetV && entry1.getLabel().equals(entry2.getSrcLabel())) {
                        commonLabels.add(entry1);
                    }
                }
                if (expandOpt == GraphOpt.Expand.IN) continue;
                if (entry1.getLabel().equals(entry2.getSrcLabel())) {
                    if (recordGetV) {
                        commonLabels.add(entry1);
                    } else {
                        commonLabels.add(entry2);
                    }
                }
                if (!containsZeroPath || !recordGetV || !entry1.getLabel().equals(entry2.getDstLabel())) continue;
                commonLabels.add(entry1);
            }
        }
        Preconditions.checkArgument((!(commonLabels = commonLabels.stream().distinct().collect(Collectors.toList())).isEmpty() ? 1 : 0) != 0, (String)"graph schema type error: unable to find getV with [type=%s] from expand with [opt=%s, type=%s]", (Object)((Object)getVType), (Object)((Object)expandOpt), (Object)((Object)expandType));
        return commonLabels;
    }

    private RelNode newRel(RelNode rel, RelDataType newType) {
        TableConfig newTableConfig;
        if (rel instanceof GraphLogicalSource) {
            GraphLogicalSource source = (GraphLogicalSource)rel;
            newTableConfig = this.newTableConfig((GraphLogicalSource)rel, newType);
            if (newTableConfig != source.getTableConfig()) {
                GraphLogicalSource newSource = GraphLogicalSource.create((GraphOptCluster)this.builder.getCluster(), (List<RelHint>)ImmutableList.of(), source.getOpt(), newTableConfig, source.getAliasName());
                ArrayList filters = Lists.newArrayList();
                if (source.getUniqueKeyFilters() != null) {
                    filters.add(source.getUniqueKeyFilters());
                }
                if (ObjectUtils.isNotEmpty(source.getFilters())) {
                    filters.addAll(source.getFilters());
                }
                if (!filters.isEmpty()) {
                    return this.builder.push((RelNode)newSource).filter((Iterable)filters).build();
                }
                return newSource;
            }
        }
        if (rel instanceof GraphLogicalExpand) {
            GraphLogicalExpand expand = (GraphLogicalExpand)rel;
            newTableConfig = this.newTableConfig((GraphLogicalExpand)rel, newType);
            if (newTableConfig != expand.getTableConfig()) {
                GraphLogicalExpand newExpand = GraphLogicalExpand.create((GraphOptCluster)this.builder.getCluster(), (List<RelHint>)ImmutableList.of(), expand.getInputs().isEmpty() ? null : expand.getInput(0), expand.getOpt(), newTableConfig, expand.getAliasName(), expand.getStartAlias());
                newExpand.setSchemaType((GraphSchemaType)newType);
                if (ObjectUtils.isNotEmpty(expand.getFilters())) {
                    return this.builder.push((RelNode)newExpand).filter((Iterable)expand.getFilters()).build();
                }
                return newExpand;
            }
            expand.setSchemaType((GraphSchemaType)newType);
        }
        if (rel instanceof GraphLogicalGetV) {
            GraphLogicalGetV getV = (GraphLogicalGetV)rel;
            newTableConfig = this.newTableConfig((GraphLogicalGetV)rel, newType);
            if (newTableConfig != getV.getTableConfig()) {
                GraphLogicalGetV newGetV = GraphLogicalGetV.create((GraphOptCluster)this.builder.getCluster(), (List<RelHint>)ImmutableList.of(), getV.getInputs().isEmpty() ? null : getV.getInput(0), getV.getOpt(), newTableConfig, getV.getAliasName(), getV.getStartAlias());
                if (ObjectUtils.isNotEmpty(getV.getFilters())) {
                    return this.builder.push((RelNode)newGetV).filter((Iterable)getV.getFilters()).build();
                }
                return newGetV;
            }
        }
        if (rel instanceof GraphLogicalPathExpand) {
            GraphLogicalPathExpand pxd = (GraphLogicalPathExpand)rel;
            RelNode newExpand = this.newRel(pxd.getExpand(), ((GraphPathType)newType).getComponentType().getExpandType());
            RelNode newGetV = this.newRel(pxd.getGetV(), ((GraphPathType)newType).getComponentType().getGetVType());
            return GraphLogicalPathExpand.create((GraphOptCluster)this.builder.getCluster(), (List<RelHint>)ImmutableList.of(), pxd.getInput(), newExpand, newGetV, pxd.getOffset(), pxd.getFetch(), pxd.getResultOpt(), pxd.getPathOpt(), pxd.getUntilCondition(), pxd.getAliasName(), pxd.getStartAlias());
        }
        return rel;
    }

    private TableConfig newTableConfig(AbstractBindableTableScan rel, RelDataType newType) {
        List<RelOptTable> oldTables = rel.getTableConfig().getTables();
        ArrayList newTables = Lists.newArrayList();
        List newLabels = ((GraphSchemaType)newType).getLabelType().getLabelsEntry().stream().map(k -> k.getLabel()).collect(Collectors.toList());
        oldTables.forEach(k -> {
            if (k.getQualifiedName().size() > 0 && newLabels.contains(k.getQualifiedName().get(0))) {
                newTables.add(k);
            }
        });
        if (newTables.size() < oldTables.size()) {
            return new TableConfig(newTables);
        }
        return rel.getTableConfig();
    }

    private RelDataType getType(RelNode node) {
        if (node instanceof AbstractBindableTableScan || node instanceof GraphLogicalPathExpand) {
            return ((RelDataTypeField)node.getRowType().getFieldList().get(0)).getType();
        }
        return node.getRowType();
    }

    private GraphSchemaType createSchemaType(GraphOpt.Source opt, List<GraphLabelType.Entry> newLabels, @Nullable GraphSchemaType originalType) {
        boolean isNullable;
        boolean bl = isNullable = originalType == null ? false : originalType.isNullable();
        if (newLabels.size() == 1) {
            return new GraphSchemaType(opt, new GraphLabelType(newLabels), this.getOriginalFields(newLabels.get(0), originalType), isNullable);
        }
        List<GraphSchemaType> fuzzyTypes = newLabels.stream().map(k -> new GraphSchemaType(opt, new GraphLabelType((List<GraphLabelType.Entry>)ImmutableList.of((Object)k)), this.getOriginalFields((GraphLabelType.Entry)k, originalType))).collect(Collectors.toList());
        return GraphSchemaType.create(fuzzyTypes, this.builder.getTypeFactory(), isNullable);
    }

    private List<RelDataTypeField> getOriginalFields(GraphLabelType.Entry labelEntry, @Nullable GraphSchemaType originalType) {
        if (originalType == null) {
            return ImmutableList.of();
        }
        List<GraphSchemaType> candidates = originalType.getSchemaTypeAsList();
        for (GraphSchemaType candidate : candidates) {
            if (!candidate.getLabelType().getLabelsEntry().contains(labelEntry)) continue;
            return candidate.getFieldList();
        }
        return ImmutableList.of();
    }

    private class GraphPathTypeInference {
        private final GraphLabelType startVType;
        private final GraphLabelType endVType;
        private final GraphPathType pxdType;
        private final GraphOpt.Expand expandOpt;
        private final List<CompositePathType> allValidPathTypes;
        private final int minHop;
        private final int maxHop;

        public GraphPathTypeInference(GraphLabelType startVType, GraphLabelType endVType, GraphPathType pxdType, GraphOpt.Expand expandOpt, int minHop, int maxHop) {
            this.startVType = startVType;
            this.endVType = endVType;
            this.pxdType = pxdType;
            this.expandOpt = expandOpt;
            this.minHop = minHop;
            this.maxHop = maxHop;
            this.allValidPathTypes = Lists.newArrayList();
        }

        public GraphPathType inferPathType() {
            this.recursive(this.startVType, new CompositePathType(Lists.newArrayList()), 0);
            ArrayList expandTypes = Lists.newArrayList();
            ArrayList getVTypes = Lists.newArrayList();
            this.allValidPathTypes.forEach(k -> k.getElementTypes().forEach(k1 -> {
                if (k1.getExpandType() != null) {
                    expandTypes.addAll(((GraphLabelType)k1.getExpandType()).getLabelsEntry());
                }
                if (k1.getGetVType() != null) {
                    getVTypes.addAll(((GraphLabelType)k1.getGetVType()).getLabelsEntry());
                }
            }));
            Preconditions.checkArgument((!expandTypes.isEmpty() && !getVTypes.isEmpty() ? 1 : 0) != 0, (String)"cannot find any path within hops of [%s, %s] between startV type [%s] and endV type [%s] with the expand type constraints [%s]", (Object[])new Object[]{this.minHop, this.maxHop, this.startVType, this.endVType, this.pxdType});
            GraphSchemaType expandType = (GraphSchemaType)this.pxdType.getComponentType().getExpandType();
            GraphSchemaType getVType = (GraphSchemaType)this.pxdType.getComponentType().getGetVType();
            return new GraphPathType(new GraphPathType.ElementType((RelDataType)GraphTypeInference.this.createSchemaType(GraphOpt.Source.EDGE, expandTypes.stream().distinct().collect(Collectors.toList()), expandType), (RelDataType)GraphTypeInference.this.createSchemaType(GraphOpt.Source.VERTEX, getVTypes.stream().distinct().collect(Collectors.toList()), getVType)));
        }

        public GraphLabelType inferStartVType() {
            GraphLabelType expandType = ((GraphSchemaType)this.pxdType.getComponentType().getExpandType()).getLabelType();
            return new GraphLabelType(GraphTypeInference.this.commonLabels(this.startVType, expandType, this.expandOpt, true, this.minHop == 0));
        }

        public GraphLabelType inferGetVType() {
            GraphLabelType innerGetVLabelType = ((GraphSchemaType)this.pxdType.getComponentType().getGetVType()).getLabelType();
            List<GraphLabelType.Entry> commonLabels = GraphTypeInference.this.commonLabels(innerGetVLabelType, this.endVType);
            return new GraphLabelType(commonLabels);
        }

        private void recursive(GraphLabelType curEndVType, CompositePathType curPathType, int curHop) {
            if (curHop > this.maxHop) {
                return;
            }
            if (curHop >= this.minHop && curHop <= this.maxHop) {
                ArrayList candidates = Lists.newArrayList(curEndVType.getLabelsEntry());
                candidates.retainAll(this.endVType.getLabelsEntry());
                if (!candidates.isEmpty()) {
                    if (curPathType.isEmpty() || candidates.size() < curEndVType.getLabelsEntry().size()) {
                        curPathType.setEndVType(new GraphLabelType(candidates));
                    }
                    this.allValidPathTypes.add(curPathType);
                }
            }
            GraphLabelType expandType = ((GraphSchemaType)this.pxdType.getComponentType().getExpandType()).getLabelType();
            curEndVType.getLabelsEntry().forEach(v -> expandType.getLabelsEntry().forEach(e -> {
                GraphLabelType nextEndVType = null;
                switch (this.expandOpt) {
                    case OUT: {
                        if (e.getSrcLabel() != v.getLabel()) break;
                        nextEndVType = new GraphLabelType(new GraphLabelType.Entry().label(e.getDstLabel()).labelId(e.getDstLabelId()));
                        break;
                    }
                    case IN: {
                        if (e.getDstLabel() != v.getLabel()) break;
                        nextEndVType = new GraphLabelType(new GraphLabelType.Entry().label(e.getSrcLabel()).labelId(e.getSrcLabelId()));
                        break;
                    }
                    case BOTH: {
                        if (e.getSrcLabel() == v.getLabel()) {
                            nextEndVType = new GraphLabelType(new GraphLabelType.Entry().label(e.getDstLabel()).labelId(e.getDstLabelId()));
                            break;
                        }
                        if (e.getDstLabel() != v.getLabel()) break;
                        nextEndVType = new GraphLabelType(new GraphLabelType.Entry().label(e.getSrcLabel()).labelId(e.getSrcLabelId()));
                    }
                }
                if (nextEndVType != null) {
                    this.recursive(nextEndVType, curPathType.copy(new GraphPathType.ElementType((RelDataType)new GraphLabelType((GraphLabelType.Entry)e), (RelDataType)nextEndVType)), curHop + 1);
                }
            }));
        }

        private class CompositePathType {
            private final List<GraphPathType.ElementType> elementTypes;

            public CompositePathType(List<GraphPathType.ElementType> elementTypes) {
                this.elementTypes = elementTypes;
            }

            public void setEndVType(GraphLabelType endVType) {
                if (this.elementTypes.isEmpty()) {
                    this.elementTypes.add(new GraphPathType.ElementType(null, (RelDataType)endVType));
                } else {
                    GraphPathType.ElementType last = this.elementTypes.get(this.elementTypes.size() - 1);
                    this.elementTypes.set(this.elementTypes.size() - 1, new GraphPathType.ElementType(last.getExpandType(), (RelDataType)endVType));
                }
            }

            public void add(GraphPathType.ElementType last) {
                this.elementTypes.add(last);
            }

            public List<GraphPathType.ElementType> getElementTypes() {
                return this.elementTypes;
            }

            public CompositePathType copy(GraphPathType.ElementType addOne) {
                ArrayList newElementTypes = Lists.newArrayList(this.elementTypes);
                newElementTypes.add(addOne);
                return new CompositePathType(newElementTypes);
            }

            public boolean isEmpty() {
                return this.elementTypes.isEmpty();
            }
        }
    }

    private class RelGraph {
        private final Map<String, List<RelNode>> aliasNameToRels = Maps.newHashMap();
        private final List<RelNode> rels = Lists.newArrayList();
        private final IdentityHashMap<RelNode, RelNode> relToParent = new IdentityHashMap();

        public RelGraph(RelNode rel) {
            this((List<RelNode>)ImmutableList.of((Object)rel));
        }

        public RelGraph(List<RelNode> rels) {
            for (RelNode rel : rels) {
                this.initialize(rel);
            }
        }

        private void initialize(RelNode rel) {
            this.rels.add(rel);
            ArrayList queue = Lists.newArrayList((Object[])new RelNode[]{rel});
            while (!queue.isEmpty()) {
                RelNode cur = (RelNode)queue.remove(0);
                String alias = this.getAliasName(cur);
                if (alias != null && alias != "_") {
                    this.aliasNameToRels.computeIfAbsent(alias, k -> Lists.newArrayList()).add(cur);
                }
                for (RelNode input : cur.getInputs()) {
                    this.relToParent.put(input, cur);
                    queue.add(input);
                }
            }
        }

        public List<RelNode> getNeighbors(RelNode rel) {
            AliasNameWithId startAlias = this.getStartAlias(rel);
            if (startAlias != null && startAlias.getAliasName() == "_") {
                RelNode input;
                RelNode relNode = input = rel.getInputs().isEmpty() ? null : rel.getInput(0);
                if (input != null) {
                    String alias = this.getAliasName(input);
                    if (alias != null && alias != "_") {
                        return this.aliasNameToRels.get(alias);
                    }
                    return Lists.newArrayList((Object[])new RelNode[]{input});
                }
                return Lists.newArrayList();
            }
            if (startAlias != null) {
                return this.aliasNameToRels.get(startAlias.getAliasName());
            }
            return Lists.newArrayList();
        }

        public @Nullable RelDataType getNeighborsType(RelNode rel) {
            List<RelNode> neighbors = this.getNeighbors(rel);
            if (!neighbors.isEmpty()) {
                return GraphTypeInference.this.restrictShared(neighbors, null, GraphTypeInference.this.getType(neighbors.get(0)));
            }
            return null;
        }

        public @Nullable RelNode getParent(RelNode rel) {
            return this.relToParent.get(rel);
        }

        public List<RelNode> getRels() {
            return Collections.unmodifiableList(this.rels);
        }

        private @Nullable AliasNameWithId getStartAlias(RelNode rel) {
            if (rel instanceof AbstractBindableTableScan) {
                return ((AbstractBindableTableScan)rel).getStartAlias();
            }
            if (rel instanceof GraphLogicalPathExpand) {
                return ((GraphLogicalPathExpand)rel).getStartAlias();
            }
            return null;
        }

        private @Nullable String getAliasName(RelNode rel) {
            if (rel instanceof AbstractBindableTableScan) {
                return ((AbstractBindableTableScan)rel).getAliasName();
            }
            if (rel instanceof GraphLogicalPathExpand) {
                return ((GraphLogicalPathExpand)rel).getAliasName();
            }
            return null;
        }
    }
}

