/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.graphscope.common.manager;

import com.alibaba.graphscope.common.config.Configs;
import com.alibaba.graphscope.common.config.FrontendConfig;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitExecutor
extends ThreadPoolExecutor {
    private static final Logger logger = LoggerFactory.getLogger(RateLimitExecutor.class);
    private final RateLimiter rateLimiter;

    public RateLimitExecutor(Configs configs, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        int permitsPerSecond = FrontendConfig.QUERY_PER_SECOND_LIMIT.get(configs);
        this.rateLimiter = RateLimiter.create((double)permitsPerSecond);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.rateLimiter.tryAcquire()) {
            return super.submit(task);
        }
        throw new RejectedExecutionException("rate limit exceeded, current limit is " + this.rateLimiter.getRate() + " per second. Please increase the QPS limit by the config 'query.per.second.limit' or slow down the query sending speed");
    }
}

